/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorEntryNodeGen;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public abstract class TRegexExecutorEntryNode
extends Node {
    private static final Unsafe UNSAFE;
    private static final Field coderField;
    private static final long coderFieldOffset;
    @Node.Child
    TRegexExecutorNode executor;

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException e1) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e2) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e2);
            }
        }
    }

    public TRegexExecutorEntryNode(TRegexExecutorNode executor) {
        this.executor = executor;
    }

    public static TRegexExecutorEntryNode create(TRegexExecutorNode executor) {
        if (executor == null) {
            return null;
        }
        return TRegexExecutorEntryNodeGen.create(executor);
    }

    public TRegexExecutorNode getExecutor() {
        return this.executor;
    }

    public abstract Object execute(Object var1, int var2, int var3, int var4);

    @Specialization(guards={"isCompactString(input)"})
    Object doStringCompact(String input, int fromIndex, int index, int maxIndex) {
        return this.executor.execute(this.executor.createLocals(input, fromIndex, index, maxIndex), true);
    }

    @Specialization(guards={"!isCompactString(input)"})
    Object doStringNonCompact(String input, int fromIndex, int index, int maxIndex) {
        return this.executor.execute(this.executor.createLocals(input, fromIndex, index, maxIndex), false);
    }

    @Specialization
    Object doTruffleObject(TruffleObject input, int fromIndex, int index, int maxIndex, @Cached(value="createClassProfile()") ValueProfile inputClassProfile) {
        return this.executor.execute(this.executor.createLocals(inputClassProfile.profile((Object)input), fromIndex, index, maxIndex), false);
    }

    static boolean isCompactString(String str) {
        return UNSAFE != null && UNSAFE.getByte(str, coderFieldOffset) == 0;
    }

    static {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion != null && javaVersion.compareTo("1.9") < 0) {
            UNSAFE = null;
            coderField = null;
            coderFieldOffset = 0L;
        } else {
            UNSAFE = TRegexExecutorEntryNode.getUnsafe();
            Field field = null;
            for (Field f : String.class.getDeclaredFields()) {
                if (!f.getName().equals("coder")) continue;
                field = f;
                break;
            }
            if ((coderField = field) == null) {
                throw new RuntimeException("failed to get coder field offset");
            }
            coderFieldOffset = UNSAFE.objectFieldOffset(coderField);
        }
    }
}

