/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.truffleinterop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.js.runtime.truffleinterop.JSMetaType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSMetaType.class)
final class JSMetaTypeGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private JSMetaTypeGen() {
    }

    static {
        LibraryExport.register(JSMetaType.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JSMetaType.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, JSMetaType.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSMetaType);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSMetaType);
            return new Cached();
        }

        @GeneratedBy(value=JSMetaType.class)
        private static final class Uncached
        extends InteropLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JSMetaType) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.js.runtime.truffleinterop.JSMetaType'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof JSMetaType;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMetaInstance(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSMetaType arg0Value = (JSMetaType)arg0Value_;
                return JSMetaType.IsMetaInstance.doGeneric(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSMetaType)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSMetaType)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSMetaType)receiver).isMetaObject();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSMetaType)receiver).getTypeName();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSMetaType)receiver).getTypeName();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSMetaType)receiver).toDisplayString(allowSideEffects);
            }
        }

        @GeneratedBy(value=JSMetaType.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private int exclude_;
            @Node.Child
            private Cached0Data cached0_cache;
            @Node.Child
            private Cached1Data cached1_cache;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JSMetaType) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.js.runtime.truffleinterop.JSMetaType'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof JSMetaType;
            }

            @ExplodeLoop
            public boolean isMetaInstance(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSMetaType arg0Value = (JSMetaType)arg0Value_;
                int state = this.state_;
                if (state != 0) {
                    if ((state & 1) != 0) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if (s1_.valueLib_.accepts(arg1Value) && arg0Value == s1_.cachedType_) {
                                return JSMetaType.IsMetaInstance.doCached(arg0Value, arg1Value, s1_.cachedType_, s1_.valueLib_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 2) != 0) {
                        Cached1Data s2_ = this.cached1_cache;
                        while (s2_ != null) {
                            if (arg0Value == s2_.cachedType_) {
                                return this.cached1Boundary(state, s2_, arg0Value, arg1Value);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 4) != 0) {
                        return JSMetaType.IsMetaInstance.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private boolean cached1Boundary(int state, Cached1Data s2_, JSMetaType arg0Value, Object arg1Value) throws UnsupportedMessageException {
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    boolean bl = JSMetaType.IsMetaInstance.doCached(arg0Value, arg1Value, s2_.cachedType_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value));
                    return bl;
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean executeAndSpecialize(JSMetaType arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    if ((exclude & 1) == 0) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 1) != 0) {
                            while (!(s1_ == null || s1_.valueLib_.accepts(arg1Value) && arg0Value == s1_.cachedType_)) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && count1_ < 3) {
                            s1_ = (Cached0Data)super.insert((Node)new Cached0Data(this.cached0_cache));
                            s1_.cachedType_ = arg0Value;
                            s1_.valueLib_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value));
                            this.cached0_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            boolean bl = JSMetaType.IsMetaInstance.doCached(arg0Value, arg1Value, s1_.cachedType_, s1_.valueLib_);
                            return bl;
                        }
                    }
                    if ((exclude & 2) == 0) {
                        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                        try {
                            int count2_ = 0;
                            Cached1Data s2_ = this.cached1_cache;
                            if ((state & 2) != 0) {
                                while (s2_ != null && arg0Value != s2_.cachedType_) {
                                    s2_ = s2_.next_;
                                    ++count2_;
                                }
                            }
                            if (s2_ == null && count2_ < 3) {
                                s2_ = (Cached1Data)super.insert((Node)new Cached1Data(this.cached1_cache));
                                s2_.cachedType_ = arg0Value;
                                this.cached1_cache = s2_;
                                this.exclude_ = exclude |= 1;
                                this.cached0_cache = null;
                                state &= 0xFFFFFFFE;
                                this.state_ = state |= 2;
                            }
                            if (s2_ != null) {
                                lock.unlock();
                                hasLock = false;
                                boolean bl = JSMetaType.IsMetaInstance.doCached(arg0Value, arg1Value, s2_.cachedType_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value));
                                return bl;
                            }
                        }
                        finally {
                            NodeUtil.popEncapsulatingNode((Node)prev_);
                        }
                    }
                    this.exclude_ = exclude |= 3;
                    this.cached0_cache = null;
                    this.cached1_cache = null;
                    state &= 0xFFFFFFFC;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSMetaType.IsMetaInstance.doGeneric(arg0Value, arg1Value);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & state - 1) == 0) {
                    Cached0Data s1_ = this.cached0_cache;
                    Cached1Data s2_ = this.cached1_cache;
                    if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSMetaType)receiver).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSMetaType)receiver).getLanguage();
            }

            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSMetaType)receiver).isMetaObject();
            }

            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSMetaType)receiver).getTypeName();
            }

            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSMetaType)receiver).getTypeName();
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSMetaType)receiver).toDisplayString(allowSideEffects);
            }

            @GeneratedBy(value=JSMetaType.class)
            private static final class Cached1Data
            extends Node {
                @Node.Child
                Cached1Data next_;
                @CompilerDirectives.CompilationFinal
                JSMetaType cachedType_;

                Cached1Data(Cached1Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }

            @GeneratedBy(value=JSMetaType.class)
            private static final class Cached0Data
            extends Node {
                @Node.Child
                Cached0Data next_;
                @CompilerDirectives.CompilationFinal
                JSMetaType cachedType_;
                @Node.Child
                InteropLibrary valueLib_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }
}

