/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;

public final class JSSlowArgumentsObject
extends JSAbstractArgumentsObject {
    static final JSSlowArgumentsObject INSTANCE = new JSSlowArgumentsObject();

    private JSSlowArgumentsObject() {
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        boolean wasDeleted;
        if (JSSlowArgumentsObject.isSealedOrFrozen(thisObj)) {
            return true;
        }
        boolean indexDisconnected = JSSlowArgumentsObject.wasIndexDisconnected(thisObj, index);
        Object oldValue = indexDisconnected ? null : this.get(thisObj, index);
        ScriptArray arrayType = JSSlowArgumentsObject.arrayGetArrayType(thisObj, JSSlowArgumentsObject.isJSSlowArgumentsObject(thisObj));
        if (arrayType.hasElement(thisObj, index)) {
            JSSlowArgumentsObject.arraySetArrayType(thisObj, arrayType.deleteElement(thisObj, index, false));
            wasDeleted = true;
        } else {
            wasDeleted = JSUserObject.INSTANCE.delete(thisObj, index, isStrict);
        }
        if (wasDeleted && !indexDisconnected) {
            JSSlowArgumentsObject.disconnectIndex(thisObj, index, oldValue);
        }
        return wasDeleted;
    }

    private static boolean isSealedOrFrozen(DynamicObject thisObj) {
        ScriptArray array = JSSlowArgumentsObject.arrayGetArrayType(thisObj);
        return array.isSealed() || array.isFrozen();
    }

    public static boolean isJSSlowArgumentsObject(DynamicObject obj) {
        return JSSlowArgumentsObject.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    protected DynamicObject makeSlowArray(DynamicObject thisObj) {
        assert (JSSlowArgumentsObject.isJSSlowArgumentsObject(thisObj));
        return thisObj;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        String indexAsString = Boundaries.stringValueOf(index);
        if (JSUserObject.INSTANCE.hasOwnProperty(thisObj, indexAsString)) {
            return JSSlowArgumentsObject.ordinarySet(thisObj, indexAsString, value, receiver, isStrict);
        }
        return super.set(thisObj, index, value, receiver, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, long index) {
        String indexAsString = Boundaries.stringValueOf(index);
        if (JSUserObject.INSTANCE.hasOwnProperty(store, indexAsString)) {
            return JSUserObject.INSTANCE.getOwnHelper(store, thisObj, indexAsString);
        }
        return super.getOwnHelper(store, thisObj, index);
    }
}

