/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.MapPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;
import java.util.EnumSet;

public final class JSMap
extends JSBuiltinObject
implements JSConstructorFactory.Default.WithSpecies,
PrototypeSupplier {
    public static final JSMap INSTANCE = new JSMap();
    public static final String CLASS_NAME = "Map";
    public static final String PROTOTYPE_NAME = "Map.prototype";
    public static final String ITERATOR_CLASS_NAME = "Map Iterator";
    public static final String ITERATOR_PROTOTYPE_NAME = "Map Iterator.prototype";
    private static final String SIZE = "size";
    private static final HiddenKey MAP_ID = new HiddenKey("map");
    private static final Property MAP_PROPERTY;
    public static final HiddenKey MAP_ITERATION_KIND_ID;

    private JSMap() {
    }

    public static DynamicObject create(JSContext context) {
        DynamicObject obj = JSObject.create(context, context.getMapFactory(), new JSHashMap());
        assert (JSMap.isJSMap(obj));
        return obj;
    }

    public static JSHashMap getInternalMap(DynamicObject obj) {
        assert (JSMap.isJSMap(obj));
        return (JSHashMap)MAP_PROPERTY.get(obj, JSMap.isJSMap(obj));
    }

    public static int getMapSize(DynamicObject obj) {
        assert (JSMap.isJSMap(obj));
        return JSMap.getInternalMap(obj).size();
    }

    private static DynamicObject createSizeGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.MapGetSize, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){
                private final BranchProfile errorBranch = BranchProfile.create();

                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSMap.isJSMap(obj)) {
                        return JSMap.getMapSize((DynamicObject)obj);
                    }
                    this.errorBranch.enter();
                    throw Errors.createTypeErrorMapExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get size");
        });
        DynamicObject sizeGetter = JSFunction.create(realm, getterData);
        JSObject.preventExtensions(sizeGetter);
        return sizeGetter;
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putConstantAccessorProperty(ctx, prototype, SIZE, JSMap.createSizeGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, MapPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(ctx, prototype, Symbol.SYMBOL_TO_STRING_TAG, CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putDataProperty(ctx, prototype, Symbol.SYMBOL_ITERATOR, prototype.get((Object)"entries"), JSAttributes.getDefaultNotEnumerable());
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        initialShape = initialShape.addProperty(MAP_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String safeToString(DynamicObject obj, int depth, JSContext context) {
        if (context.isOptionNashornCompatibilityMode()) {
            return "[" + this.getClassName() + "]";
        }
        JSHashMap map = JSMap.getInternalMap(obj);
        return JSRuntime.collectionToConsoleString(obj, this.getClassName(obj), map, depth);
    }

    public static boolean isJSMap(Object obj) {
        return JSObject.isDynamicObject(obj) && JSMap.isJSMap((DynamicObject)obj);
    }

    public static boolean isJSMap(DynamicObject obj) {
        return JSMap.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getMapPrototype();
    }

    static {
        MAP_ITERATION_KIND_ID = new HiddenKey("MapIterationKind");
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        MAP_PROPERTY = JSObjectUtil.makeHiddenProperty(MAP_ID, allocator.locationForType(JSHashMap.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
    }
}

