/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.AbstractFunctionArgumentsNode;
import com.oracle.truffle.js.nodes.function.JSNewNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSNewNode.class)
public final class JSNewNodeGen
extends JSNewNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private NewForeignObjectData newForeignObject_cache;

    private JSNewNodeGen(JSContext context, JavaScriptNode targetNode, AbstractFunctionArgumentsNode arguments) {
        super(context, targetNode, arguments);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object targetNodeValue_ = this.targetNode.execute(frameValue);
        if ((state & 0xF) != 0 && JSTypes.isDynamicObject(targetNodeValue_)) {
            DynamicObject targetNodeValue__ = (DynamicObject)targetNodeValue_;
            if ((state & 1) != 0 && JSGuards.isJSFunction(targetNodeValue__)) {
                return this.doNewReturnThis(frameValue, targetNodeValue__);
            }
            if ((state & 2) != 0 && JSGuards.isJSAdapter(targetNodeValue__)) {
                return this.doJSAdapter(frameValue, targetNodeValue__);
            }
            if ((state & 4) != 0 && JSProxy.isProxy(targetNodeValue__)) {
                return this.doNewJSProxy(frameValue, targetNodeValue__);
            }
            if ((state & 8) != 0 && JSGuards.isJavaPackage(targetNodeValue__)) {
                return this.createClassNotFoundError(frameValue, targetNodeValue__);
            }
        }
        if ((state & 0x30) != 0) {
            NewForeignObjectData s5_;
            if ((state & 0x10) != 0 && (s5_ = this.newForeignObject_cache) != null && JSGuards.isForeignObject(targetNodeValue_)) {
                return this.doNewForeignObject(frameValue, targetNodeValue_, s5_.interop_, s5_.convert_, s5_.toJSType_, s5_.isHostClassProf_, s5_.isAbstractProf_);
            }
            if (!((state & 0x20) == 0 || JSGuards.isJSFunction(targetNodeValue_) || JSGuards.isJSAdapter(targetNodeValue_) || JSProxy.isProxy(targetNodeValue_) || JSGuards.isJavaPackage(targetNodeValue_) || JSGuards.isForeignObject(targetNodeValue_))) {
                return this.createFunctionTypeError(frameValue, targetNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, targetNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object targetNodeValue) {
        int state;
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int oldState = state = this.state_;
        try {
            if (JSTypes.isDynamicObject(targetNodeValue)) {
                DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
                if (JSGuards.isJSFunction(targetNodeValue_)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doNewReturnThis(frameValue, targetNodeValue_);
                    return object;
                }
                if (JSGuards.isJSAdapter(targetNodeValue_)) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doJSAdapter(frameValue, targetNodeValue_);
                    return object;
                }
                if (JSProxy.isProxy(targetNodeValue_)) {
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doNewJSProxy(frameValue, targetNodeValue_);
                    return object;
                }
                if (JSGuards.isJavaPackage(targetNodeValue_)) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.createClassNotFoundError(frameValue, targetNodeValue_);
                    return object;
                }
            }
            if (JSGuards.isForeignObject(targetNodeValue)) {
                NewForeignObjectData s5_ = (NewForeignObjectData)super.insert((Node)new NewForeignObjectData());
                s5_.interop_ = (InteropLibrary)s5_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                s5_.convert_ = s5_.insertAccessor(ExportValueNode.create());
                s5_.toJSType_ = s5_.insertAccessor(JSForeignToJSTypeNode.create());
                s5_.isHostClassProf_ = ConditionProfile.createBinaryProfile();
                s5_.isAbstractProf_ = ConditionProfile.createBinaryProfile();
                this.newForeignObject_cache = s5_;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                Object object = this.doNewForeignObject(frameValue, targetNodeValue, s5_.interop_, s5_.convert_, s5_.toJSType_, s5_.isHostClassProf_, s5_.isAbstractProf_);
                return object;
            }
            if (!(JSGuards.isJSFunction(targetNodeValue) || JSGuards.isJSAdapter(targetNodeValue) || JSProxy.isProxy(targetNodeValue) || JSGuards.isJavaPackage(targetNodeValue) || JSGuards.isForeignObject(targetNodeValue))) {
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                Object object = this.createFunctionTypeError(frameValue, targetNodeValue);
                return object;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.targetNode}, new Object[]{targetNodeValue});
        }
        finally {
            if (oldState != 0) {
                this.checkForPolymorphicSpecialize(oldState);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(int oldState) {
        int newState = this.state_;
        if ((oldState ^ newState) != 0) {
            this.reportPolymorphicSpecialize();
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[7];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doNewReturnThis";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doJSAdapter";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doNewJSProxy";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "createClassNotFoundError";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doNewForeignObject";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
            NewForeignObjectData s5_ = this.newForeignObject_cache;
            if (s5_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s5_.interop_, s5_.convert_, s5_.toJSType_, s5_.isHostClassProf_, s5_.isAbstractProf_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "createFunctionTypeError";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSNewNode create(JSContext context, JavaScriptNode targetNode, AbstractFunctionArgumentsNode arguments) {
        return new JSNewNodeGen(context, targetNode, arguments);
    }

    @GeneratedBy(value=JSNewNode.class)
    private static final class NewForeignObjectData
    extends Node {
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        ExportValueNode convert_;
        @Node.Child
        JSForeignToJSTypeNode toJSType_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile isHostClassProf_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile isAbstractProf_;

        NewForeignObjectData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

