/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSWriteScopeFrameSlotNodeGen;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.Set;

abstract class JSWriteScopeFrameSlotNode
extends JSWriteFrameSlotNode {
    @Node.Child
    @Executed
    ScopeFrameNode scopeFrameNode;
    @Node.Child
    @Executed
    JavaScriptNode rhsNode;

    protected JSWriteScopeFrameSlotNode(FrameSlot frameSlot, ScopeFrameNode scopeFrameNode, JavaScriptNode rhsNode) {
        super(frameSlot);
        this.scopeFrameNode = scopeFrameNode;
        this.rhsNode = rhsNode;
    }

    @Specialization(guards={"isBooleanKind(levelFrame)"})
    protected final boolean doBoolean(Frame levelFrame, boolean value) {
        levelFrame.setBoolean(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"isIntegerKind(levelFrame)"})
    protected final int doInt(Frame levelFrame, int value) {
        levelFrame.setInt(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"isLongKind(levelFrame)"})
    protected final int doSafeIntegerInt(Frame levelFrame, int value) {
        levelFrame.setLong(this.frameSlot, (long)value);
        return value;
    }

    @Specialization(guards={"isLongKind(levelFrame)"})
    protected final SafeInteger doSafeInteger(Frame levelFrame, SafeInteger value) {
        levelFrame.setLong(this.frameSlot, value.longValue());
        return value;
    }

    @Specialization(guards={"ensureObjectKind(levelFrame)"})
    protected final long doLong(Frame levelFrame, long value) {
        levelFrame.setObject(this.frameSlot, (Object)value);
        return value;
    }

    @Specialization(guards={"isDoubleKind(levelFrame)"}, replaces={"doInt", "doSafeInteger", "doSafeIntegerInt"})
    protected final double doDouble(Frame levelFrame, double value) {
        levelFrame.setDouble(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"ensureObjectKind(levelFrame)"}, replaces={"doBoolean", "doInt", "doDouble", "doSafeInteger", "doSafeIntegerInt", "doLong"})
    protected final Object doObject(Frame levelFrame, Object value) {
        levelFrame.setObject(this.frameSlot, value);
        return value;
    }

    @Override
    public final Object executeWithFrame(Frame frame, Object value) {
        return this.executeEvaluated(null, frame, value);
    }

    abstract Object executeEvaluated(VirtualFrame var1, Frame var2, Object var3);

    @Override
    public final Object executeWrite(VirtualFrame frame, Object value) {
        return this.executeEvaluated(frame, this.getLevelFrameNode().executeFrame((Frame)frame), value);
    }

    @Override
    public ScopeFrameNode getLevelFrameNode() {
        return this.scopeFrameNode;
    }

    @Override
    public JavaScriptNode getRhs() {
        return this.rhsNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSWriteScopeFrameSlotNodeGen.create(this.frameSlot, this.getLevelFrameNode(), JSWriteScopeFrameSlotNode.cloneUninitialized(this.getRhs(), materializedTags));
    }
}

