/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.DotDirectiveArchiveFinalizer;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.FilterEnabled;
import org.codehaus.plexus.archiver.FinalizerEnabled;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.util.DefaultArchivedFileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.util.FilterSupport;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractArchiver
extends AbstractLogEnabled
implements Archiver,
Contextualizable,
FilterEnabled,
FinalizerEnabled {
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    private Logger logger;
    private File destFile;
    private Map filesMap = new LinkedHashMap();
    private Map dirsMap = new LinkedHashMap();
    private int defaultFileMode = 33188;
    private boolean includeEmptyDirs = true;
    private int defaultDirectoryMode = 16877;
    private boolean forced = true;
    private FilterSupport filterSupport;
    private List finalizers;
    private File dotFileDirectory;
    private ArchiverManager archiverManager;
    private Set explodedArchiveDirs = new HashSet();

    public void setDefaultFileMode(int mode) {
        this.defaultFileMode = mode & 0xFFF | 0x8000;
    }

    public int getDefaultFileMode() {
        return this.defaultFileMode;
    }

    public void setDefaultDirectoryMode(int mode) {
        this.defaultDirectoryMode = mode & 0xFFF | 0x4000;
    }

    public int getDefaultDirectoryMode() {
        return this.defaultDirectoryMode;
    }

    public boolean getIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    public void addDirectory(File directory) throws ArchiverException {
        this.addDirectory(directory, "");
    }

    public void addDirectory(File directory, String prefix) throws ArchiverException {
        this.addDirectory(directory, prefix, null, null);
    }

    public void addDirectory(File directory, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directory, "", includes, excludes);
    }

    public void addDirectory(File directory, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        DefaultFileSet fileSet = new DefaultFileSet();
        fileSet.setDirectory(directory);
        fileSet.setPrefix(prefix);
        fileSet.setIncludes(includes);
        fileSet.setExcludes(excludes);
        fileSet.setIncludingEmptyDirectories(this.includeEmptyDirs);
        this.addFileSet(fileSet);
    }

    public void addFileSet(FileSet fileSet) throws ArchiverException {
        int i;
        File directory;
        DirectoryScanner scanner = new DirectoryScanner();
        if (fileSet.getIncludes() != null) {
            scanner.setIncludes(fileSet.getIncludes());
        }
        if (fileSet.getExcludes() != null) {
            scanner.setExcludes(fileSet.getExcludes());
        }
        if ((directory = fileSet.getDirectory()) == null) {
            throw new ArchiverException("The file sets base directory is null.");
        }
        if (!directory.isDirectory()) {
            throw new ArchiverException(directory.getAbsolutePath() + " isn't a directory.");
        }
        String basedir = directory.getAbsolutePath();
        scanner.setBasedir(basedir);
        scanner.scan();
        String prefix = fileSet.getPrefix() == null ? "" : fileSet.getPrefix();
        ArchiverFileInfo fileInfo = new ArchiverFileInfo();
        FileSelector[] fileSelectors = fileSet.getFileSelectors();
        if (fileSet.isIncludingEmptyDirectories()) {
            String[] dirs = scanner.getIncludedDirectories();
            for (i = 0; i < dirs.length; ++i) {
                String name = dirs[i];
                String sourceDir = name.replace('\\', '/');
                File dir = new File(basedir, sourceDir);
                fileInfo.setFile(dir);
                fileInfo.setName(name);
                if (!this.isSelected(fileSelectors, fileInfo)) continue;
                String targetDir = prefix + sourceDir;
                this.getDirs().put(targetDir, ArchiveEntry.createDirectoryEntry(targetDir, dir, this.getDefaultDirectoryMode()));
            }
        }
        String[] files = scanner.getIncludedFiles();
        for (i = 0; i < files.length; ++i) {
            String file = files[i];
            String sourceFile = file.replace('\\', '/');
            File source = new File(basedir, sourceFile);
            fileInfo.setName(file);
            fileInfo.setFile(source);
            if (!this.isSelected(fileSelectors, fileInfo)) continue;
            String targetFile = prefix + sourceFile;
            this.addFile(source, targetFile);
        }
    }

    private boolean isSelected(FileSelector[] fileSelectors, FileInfo fileInfo) throws ArchiverException {
        if (fileSelectors != null) {
            for (int i = 0; i < fileSelectors.length; ++i) {
                try {
                    if (fileSelectors[i].isSelected(fileInfo)) continue;
                    return false;
                }
                catch (IOException e) {
                    throw new ArchiverException("Failed to check, whether " + fileInfo.getName() + " is selected.", e);
                }
            }
        }
        return true;
    }

    public void addFile(File inputFile, String destFileName) throws ArchiverException {
        this.addFile(inputFile, destFileName, this.getDefaultFileMode());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFile(File inputFile, String destFileName, int permissions) throws ArchiverException {
        FileInputStream fileStream;
        block8: {
            if (!inputFile.isFile()) throw new ArchiverException(inputFile.getAbsolutePath() + " isn't a file.");
            if (!inputFile.exists()) {
                throw new ArchiverException(inputFile.getAbsolutePath() + " isn't a file.");
            }
            fileStream = null;
            destFileName = destFileName.replace('\\', '/');
            try {
                if (this.filterSupport != null) {
                    fileStream = new FileInputStream(inputFile);
                    if (this.include(fileStream, destFileName)) {
                        this.filesMap.put(destFileName, ArchiveEntry.createFileEntry(destFileName, inputFile, permissions));
                    }
                    break block8;
                }
                this.filesMap.put(destFileName, ArchiveEntry.createFileEntry(destFileName, inputFile, permissions));
            }
            catch (IOException e) {
                try {
                    throw new ArchiverException("Failed to determine inclusion status for: " + inputFile, e);
                    catch (ArchiveFilterException e2) {
                        throw new ArchiverException("Failed to determine inclusion status for: " + inputFile, e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileStream);
                    throw throwable;
                }
            }
        }
        IOUtil.close((InputStream)fileStream);
    }

    public Map getFiles() {
        if (!this.includeEmptyDirs) {
            return this.filesMap;
        }
        LinkedHashMap resources = new LinkedHashMap();
        resources.putAll(this.getDirs());
        resources.putAll(this.filesMap);
        return resources;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
        if (destFile != null) {
            destFile.getParentFile().mkdirs();
        }
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = super.getLogger() != null ? super.getLogger() : new ConsoleLogger(1, "console");
        }
        return this.logger;
    }

    public Map getDirs() {
        return this.dirsMap;
    }

    public void addArchivedFileSet(final ArchivedFileSet fileSet) throws ArchiverException {
        UnArchiver unArchiver;
        File archiveFile = fileSet.getArchive();
        try {
            unArchiver = this.archiverManager.getUnArchiver(archiveFile);
            if (unArchiver instanceof FilterEnabled) {
                ((FilterEnabled)((Object)unArchiver)).setArchiveFilters(Collections.EMPTY_LIST);
            }
        }
        catch (NoSuchArchiverException e) {
            throw new ArchiverException("Error adding archived file-set. UnArchiver not found for: " + archiveFile, e);
        }
        final File tempDir = FileUtils.createTempFile((String)"archived-file-set.", (String)".tmp", null);
        this.explodedArchiveDirs.add(tempDir);
        tempDir.mkdirs();
        unArchiver.setSourceFile(archiveFile);
        unArchiver.setDestDirectory(tempDir);
        unArchiver.extract();
        this.addFileSet(new FileSet(){

            public File getDirectory() {
                return tempDir;
            }

            public String[] getExcludes() {
                return fileSet.getExcludes();
            }

            public FileSelector[] getFileSelectors() {
                return fileSet.getFileSelectors();
            }

            public String[] getIncludes() {
                return fileSet.getIncludes();
            }

            public String getPrefix() {
                return fileSet.getPrefix();
            }

            public boolean isCaseSensitive() {
                return fileSet.isCaseSensitive();
            }

            public boolean isIncludingEmptyDirectories() {
                return fileSet.isIncludingEmptyDirectories();
            }

            public boolean isUsingDefaultExcludes() {
                return fileSet.isUsingDefaultExcludes();
            }
        });
    }

    public void addArchivedFileSet(File archiveFile, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        DefaultArchivedFileSet fileSet = new DefaultArchivedFileSet();
        fileSet.setArchive(archiveFile);
        fileSet.setPrefix(prefix);
        fileSet.setIncludes(includes);
        fileSet.setExcludes(excludes);
        fileSet.setIncludingEmptyDirectories(this.includeEmptyDirs);
        this.addArchivedFileSet(fileSet);
    }

    public void addArchivedFileSet(File archiveFile, String prefix) throws ArchiverException {
        this.addArchivedFileSet(archiveFile, prefix, null, null);
    }

    public void addArchivedFileSet(File archiveFile, String[] includes, String[] excludes) throws ArchiverException {
        this.addArchivedFileSet(archiveFile, null, includes, excludes);
    }

    public void addArchivedFileSet(File archiveFile) throws ArchiverException {
        this.addArchivedFileSet(archiveFile, null, null, null);
    }

    public void contextualize(Context context) throws ContextException {
        PlexusContainer container = (PlexusContainer)context.get((Object)"plexus");
        try {
            this.archiverManager = (ArchiverManager)container.lookup(ArchiverManager.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new ContextException("Error retrieving ArchiverManager instance: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public void setArchiveFilters(List filters) {
        this.filterSupport = new FilterSupport(filters, this.getLogger());
    }

    public void addArchiveFinalizer(ArchiveFinalizer finalizer) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList();
        }
        this.finalizers.add(finalizer);
    }

    public void setArchiveFinalizers(List archiveFinalizers) {
        this.finalizers = archiveFinalizers;
    }

    public void setDotFileDirectory(File dotFileDirectory) {
        this.dotFileDirectory = dotFileDirectory;
    }

    protected boolean isUptodate() {
        File zipFile = this.getDestFile();
        long destTimestamp = zipFile.lastModified();
        if (destTimestamp == 0L) {
            this.getLogger().debug("isUp2date: false (Destination " + zipFile.getPath() + " not found.)");
            return false;
        }
        Map archiveEntries = this.getFiles();
        if (archiveEntries == null || archiveEntries.isEmpty()) {
            this.getLogger().debug("isUp2date: false (No input files.)");
            return false;
        }
        Iterator iter = archiveEntries.values().iterator();
        while (iter.hasNext()) {
            ArchiveEntry entry = (ArchiveEntry)iter.next();
            long l = entry.getFile().lastModified();
            if (l == 0L) {
                this.getLogger().debug("isUp2date: false (Input file " + entry.getFile().getPath() + " not found.)");
                return false;
            }
            if (l <= destTimestamp) continue;
            this.getLogger().debug("isUp2date: false (Input file " + entry.getFile().getPath() + " is newer.)");
            return false;
        }
        this.getLogger().debug("isUp2date: true");
        return true;
    }

    protected boolean checkForced() {
        if (!this.isForced() && this.isSupportingForced() && this.isUptodate()) {
            this.getLogger().debug("Archive " + this.getDestFile() + " is uptodate.");
            return false;
        }
        return true;
    }

    public boolean isSupportingForced() {
        return false;
    }

    protected List getArchiveFinalizers() {
        return this.finalizers;
    }

    protected void runArchiveFinalizers() throws ArchiverException {
        if (this.finalizers != null) {
            Iterator it = this.finalizers.iterator();
            while (it.hasNext()) {
                ArchiveFinalizer finalizer = (ArchiveFinalizer)it.next();
                finalizer.finalizeArchiveCreation(this);
            }
        }
    }

    private boolean include(InputStream in, String path) throws ArchiveFilterException {
        return this.filterSupport == null || this.filterSupport.include(in, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createArchive() throws ArchiverException, IOException {
        this.validate();
        try {
            try {
                if (this.dotFileDirectory != null) {
                    this.addArchiveFinalizer(new DotDirectiveArchiveFinalizer(this.dotFileDirectory));
                }
                this.runArchiveFinalizers();
                this.execute();
            }
            finally {
                this.close();
            }
        }
        catch (IOException e) {
            String msg = "Problem creating " + this.getArchiveType() + ": " + e.getMessage();
            StringBuffer revertBuffer = new StringBuffer();
            if (!this.revert(revertBuffer)) {
                msg = msg + revertBuffer.toString();
            }
            throw new ArchiverException(msg, e);
        }
        finally {
            this.cleanUpInternal();
            this.cleanUp();
        }
    }

    protected boolean hasVirtualFiles() {
        if (this.finalizers != null) {
            Iterator it = this.finalizers.iterator();
            while (it.hasNext()) {
                ArchiveFinalizer finalizer = (ArchiveFinalizer)it.next();
                List virtualFiles = finalizer.getVirtualFiles();
                if (virtualFiles == null || virtualFiles.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean revert(StringBuffer messageBuffer) {
        return true;
    }

    protected void validate() throws ArchiverException, IOException {
    }

    private void cleanUpInternal() {
        Iterator it = this.explodedArchiveDirs.iterator();
        while (it.hasNext()) {
            File dir = (File)it.next();
            if (!dir.exists()) continue;
            try {
                FileUtils.forceDelete((File)dir);
            }
            catch (IOException e) {
                this.getLogger().debug("Failed to delete exploded-archive temp directory: " + dir, (Throwable)e);
            }
        }
    }

    protected abstract String getArchiveType();

    protected abstract void close() throws IOException;

    protected abstract void cleanUp();

    protected abstract void execute() throws ArchiverException, IOException;

    private static class ArchiverFileInfo
    implements FileInfo {
        private String name;
        private File file;

        private ArchiverFileInfo() {
        }

        void setFile(File file) {
            this.file = file;
        }

        void setName(String name) {
            this.name = name;
        }

        public InputStream getContents() throws IOException {
            return new FileInputStream(this.file);
        }

        public String getName() {
            return this.name;
        }

        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        public boolean isFile() {
            return this.file.isFile();
        }
    }
}

