/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.BlockParser;
import org.apache.maven.doxia.module.twiki.parser.TextBlock;
import org.apache.maven.doxia.module.twiki.parser.VerbatimBlock;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineSource;

public class VerbatimBlockParser
implements BlockParser {
    private static final Pattern VERBATIM_START_PATTERN = Pattern.compile("\\s*<verbatim>");
    private static final Pattern VERBATIM_END_PATTERN = Pattern.compile("</verbatim>");

    @Override
    public final boolean accept(String line) {
        return VERBATIM_START_PATTERN.matcher(line).lookingAt();
    }

    @Override
    public final Block visit(String line, ByLineSource source) throws ParseException {
        if (!this.accept(line)) {
            throw new IllegalAccessError("call accept before this ;)");
        }
        ArrayList<TextBlock> lines = new ArrayList<TextBlock>();
        Matcher matcher = VERBATIM_START_PATTERN.matcher(line);
        matcher.find();
        String l = line.substring(matcher.end());
        while (l != null) {
            matcher = VERBATIM_END_PATTERN.matcher(l);
            if (matcher.find()) {
                lines.add(new TextBlock(l.substring(0, matcher.start()) + "\n"));
                break;
            }
            lines.add(new TextBlock(l + "\n"));
            l = source.getNextLine();
        }
        return new VerbatimBlock(lines.toArray(new Block[0]));
    }
}

