/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.regex.charset.CP16BitMatchers;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.RangeTreeMatcherNodeGen;
import com.oracle.truffle.regex.tregex.util.MathUtil;

public abstract class RangeTreeMatcher
extends InvertibleCharMatcher {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final char[] sortedRanges;

    public static RangeTreeMatcher fromRanges(boolean invert, char[] ranges) {
        return RangeTreeMatcherNodeGen.create(invert, ranges);
    }

    RangeTreeMatcher(boolean invert, char[] sortedRanges) {
        super(invert);
        this.sortedRanges = sortedRanges;
    }

    @Specialization
    public boolean match(char c, boolean compactString) {
        assert (!compactString) : "this matcher should be avoided via ProfilingCharMatcher on compact strings";
        CompilerAsserts.partialEvaluationConstant((Object)((Object)this));
        return this.matchTree(0, (this.sortedRanges.length >>> 1) - 1, c);
    }

    private boolean matchTree(int fromIndex, int toIndex, char c) {
        CompilerAsserts.partialEvaluationConstant((int)fromIndex);
        CompilerAsserts.partialEvaluationConstant((int)toIndex);
        if (fromIndex > toIndex) {
            return this.result(false);
        }
        int mid = fromIndex + toIndex >>> 1;
        CompilerAsserts.partialEvaluationConstant((int)mid);
        if (c < this.sortedRanges[mid << 1]) {
            return this.matchTree(fromIndex, mid - 1, c);
        }
        if (c > this.sortedRanges[(mid << 1) + 1]) {
            return this.matchTree(mid + 1, toIndex, c);
        }
        return this.result(true);
    }

    @Override
    public int estimatedCost() {
        return 2 * (MathUtil.log2ceil(this.sortedRanges.length / 2) - 1);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "tree " + this.modifiersToString() + "[" + CP16BitMatchers.rangesToString(this.sortedRanges) + "]";
    }
}

