/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.locators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassRealmUtils {
    private static final boolean GET_IMPORT_REALMS_SUPPORTED;

    private ClassRealmUtils() {
    }

    public static ClassRealm contextRealm() {
        for (ClassLoader tccl = Thread.currentThread().getContextClassLoader(); tccl != null; tccl = tccl.getParent()) {
            if (!(tccl instanceof ClassRealm)) continue;
            return (ClassRealm)tccl;
        }
        return null;
    }

    public static Set<String> visibleRealmNames(ClassRealm contextRealm) {
        if (!GET_IMPORT_REALMS_SUPPORTED || null == contextRealm) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> visibleRealms = new HashSet<String>();
        ArrayList<ClassRealm> searchRealms = new ArrayList<ClassRealm>();
        searchRealms.add(contextRealm);
        for (int i = 0; i < searchRealms.size(); ++i) {
            ClassRealm realm = (ClassRealm)searchRealms.get(i);
            if (!visibleRealms.add(realm.toString())) continue;
            searchRealms.addAll(realm.getImportRealms());
            ClassRealm parent = realm.getParentRealm();
            if (null == parent) continue;
            searchRealms.add(parent);
        }
        return visibleRealms;
    }

    static {
        new ClassRealmUtils();
        boolean getImportRealmsSupported = true;
        try {
            ClassRealm.class.getDeclaredMethod("getImportRealms", new Class[0]);
        }
        catch (Throwable e) {
            getImportRealmsSupported = false;
        }
        GET_IMPORT_REALMS_SUPPORTED = getImportRealmsSupported;
    }
}

