/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexBodyNode;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.result.RegexResult;
import com.oracle.truffle.regex.tregex.nodes.input.InputCharAtNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputLengthNode;

public abstract class RegexExecRootNode
extends RegexBodyNode {
    private final boolean mustCheckUnicodeSurrogates;
    @Node.Child
    private InputLengthNode lengthNode;
    @Node.Child
    private InputCharAtNode charAtNode;

    public RegexExecRootNode(RegexLanguage language, RegexSource source, boolean mustCheckUnicodeSurrogates) {
        super(language, source);
        this.mustCheckUnicodeSurrogates = mustCheckUnicodeSurrogates;
    }

    public final RegexResult execute(VirtualFrame frame) {
        Object[] args = frame.getArguments();
        assert (args.length == 2);
        Object input = args[0];
        int fromIndex = (Integer)args[1];
        return this.execute(input, this.adjustFromIndex(fromIndex, input));
    }

    private int adjustFromIndex(int fromIndex, Object input) {
        if (this.mustCheckUnicodeSurrogates && fromIndex > 0 && fromIndex < this.inputLength(input) && Character.isLowSurrogate(this.inputCharAt(input, fromIndex)) && Character.isHighSurrogate(this.inputCharAt(input, fromIndex - 1))) {
            return fromIndex - 1;
        }
        return fromIndex;
    }

    public int inputLength(Object input) {
        if (this.lengthNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lengthNode = (InputLengthNode)this.insert(InputLengthNode.create());
        }
        return this.lengthNode.execute(input);
    }

    public char inputCharAt(Object input, int i) {
        if (this.charAtNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.charAtNode = (InputCharAtNode)this.insert(InputCharAtNode.create());
        }
        return this.charAtNode.execute(input, i);
    }

    protected abstract RegexResult execute(Object var1, int var2);
}

