/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.JSLazyStringFlattened;
import com.oracle.truffle.js.runtime.objects.JSLazyStringRaw;

@ExportLibrary(value=InteropLibrary.class)
public final class JSLazyString
implements CharSequence,
TruffleObject,
JSLazyStringFlattened,
JSLazyStringRaw {
    private CharSequence left;
    private CharSequence right;
    private final int length;

    @CompilerDirectives.TruffleBoundary
    public static CharSequence create(CharSequence left, CharSequence right) {
        assert (JSRuntime.isString(left));
        assert (JSRuntime.isString(right));
        if (left.length() == 0) {
            return right;
        }
        if (right.length() == 0) {
            return left;
        }
        int resultLength = left.length() + right.length();
        if (resultLength > JavaScriptLanguage.getCurrentJSRealm().getContext().getStringLengthLimit()) {
            throw Errors.createRangeErrorInvalidStringLength();
        }
        if (resultLength < 20) {
            return left.toString().concat(right.toString());
        }
        return new JSLazyString(left, right, resultLength);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static JSLazyString createChecked(CharSequence left, CharSequence right, int length) {
        assert (JSLazyString.assertChecked(left, right, length));
        return new JSLazyString(left, right, length);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean assertChecked(CharSequence left, CharSequence right, int length) {
        assert (JSRuntime.isString(left) && JSRuntime.isString(right));
        assert (length == left.length() + right.length());
        assert (left.length() > 0 && right.length() > 0);
        assert (left.length() + right.length() <= JavaScriptLanguage.getCurrentJSRealm().getContext().getStringLengthLimit());
        assert (length >= 20);
        return true;
    }

    public static JSLazyString concatToLeafMaybe(CharSequence left, CharSequence right, int length) {
        assert (JSLazyString.assertChecked(left, right, length));
        if (left instanceof JSLazyString && right instanceof String) {
            return JSLazyString.concatToLeafMaybe((JSLazyString)left, (String)right, length);
        }
        if (left instanceof String && right instanceof JSLazyString) {
            return JSLazyString.concatToLeafMaybe((String)left, (JSLazyString)right, length);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSLazyString concatToLeafMaybe(JSLazyString left, String right, int length) {
        assert (JSLazyString.assertChecked(left, right, length));
        CharSequence ll = left.left;
        CharSequence lr = left.right;
        if (lr != null && lr instanceof String && lr.length() + right.length() <= 10) {
            return JSLazyString.createChecked(ll, lr.toString().concat(right), length);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSLazyString concatToLeafMaybe(String left, JSLazyString right, int length) {
        assert (JSLazyString.assertChecked(left, right, length));
        CharSequence ll = right.left;
        CharSequence lr = right.right;
        if (lr != null && ll instanceof String && left.length() + ll.length() <= 10) {
            return JSLazyString.createChecked(left.concat(ll.toString()), lr, length);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static CharSequence createLazyInt(CharSequence left, int right) {
        assert (JSRuntime.isString(left));
        if (left.length() == 0) {
            return String.valueOf(right);
        }
        return new JSLazyString(left, new JSLazyIntWrapper(right));
    }

    @CompilerDirectives.TruffleBoundary
    public static CharSequence createLazyInt(int left, CharSequence right) {
        assert (JSRuntime.isString(right));
        if (right.length() == 0) {
            return String.valueOf(left);
        }
        return new JSLazyString(new JSLazyIntWrapper(left), right);
    }

    private JSLazyString(CharSequence left, CharSequence right, int length) {
        assert (left.length() > 0 && right.length() > 0 && length == left.length() + right.length());
        this.left = left;
        this.right = right;
        this.length = length;
    }

    private JSLazyString(CharSequence left, CharSequence right) {
        this(left, right, left.length() + right.length());
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public String toString() {
        if (!this.isFlat()) {
            this.flatten();
        }
        return (String)this.left;
    }

    public String toString(ConditionProfile profile) {
        if (profile.profile(!this.isFlat())) {
            this.flatten();
        }
        return (String)this.left;
    }

    public boolean isFlat() {
        return this.right == null;
    }

    @CompilerDirectives.TruffleBoundary
    private void flatten() {
        char[] dst = new char[this.length];
        JSLazyString.flatten(this, 0, this.length, dst, 0);
        this.left = new String(dst);
        this.right = null;
    }

    private static void flatten(CharSequence src, int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        CompilerAsserts.neverPartOfCompilation();
        CharSequence str = src;
        int from = srcBegin;
        int to = srcEnd;
        int dstFrom = dstBegin;
        while (true) {
            assert (0 <= from && from <= to && to <= str.length());
            if (!(str instanceof JSLazyString)) break;
            JSLazyString lazyString = (JSLazyString)str;
            CharSequence left = lazyString.left;
            CharSequence right = lazyString.right;
            int mid = left.length();
            if (to - mid >= mid - from) {
                if (from < mid) {
                    if (left instanceof String) {
                        ((String)left).getChars(from, mid, dst, dstFrom);
                    } else {
                        JSLazyString.flatten(left, from, mid, dst, dstFrom);
                    }
                    dstFrom += mid - from;
                    from = 0;
                } else {
                    from -= mid;
                }
                to -= mid;
                str = right;
                continue;
            }
            if (to > mid) {
                if (right instanceof String) {
                    ((String)right).getChars(0, to - mid, dst, dstFrom + mid - from);
                } else {
                    JSLazyString.flatten(right, 0, to - mid, dst, dstFrom + mid - from);
                }
                to = mid;
            }
            str = left;
        }
        if (str instanceof String) {
            ((String)str).getChars(from, to, dst, dstFrom);
            return;
        }
        assert (JSRuntime.isString(str) || str instanceof JSLazyIntWrapper);
        str.toString().getChars(from, to, dst, dstFrom);
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    public static boolean isInstance(TruffleObject object) {
        return object instanceof JSLazyString;
    }

    @Override
    public String getFlattenedString() {
        assert (this.isFlat());
        return (String)this.left;
    }

    @ExportMessage
    boolean isString() {
        return true;
    }

    @ExportMessage
    String asString() {
        return this.toString();
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return JavaScriptLanguage.class;
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return this.toString();
    }

    private static class JSLazyIntWrapper
    implements CharSequence {
        private final int value;
        private String str;

        JSLazyIntWrapper(int value) {
            this.value = value;
            this.str = null;
        }

        @Override
        public int length() {
            long absValue = Math.abs((long)this.value);
            int count = 1;
            for (long temp = 10L; absValue >= temp; temp *= 10L) {
                ++count;
            }
            return this.value >= 0 ? count : count + 1;
        }

        @Override
        public char charAt(int index) {
            return this.toString().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        @Override
        public String toString() {
            if (this.str == null) {
                this.str = String.valueOf(this.value);
            }
            return this.str;
        }
    }
}

