/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class JSException
extends GraalJSException {
    private static final long serialVersionUID = -2139936643139844157L;
    private final JSErrorType type;
    private DynamicObject exceptionObj;
    private JSRealm realm;
    private boolean useCallerRealm;
    private final boolean isIncompleteSource;

    private JSException(JSErrorType type, String message, Throwable cause, Node originatingNode, int stackTraceLimit) {
        super(message, cause, originatingNode, stackTraceLimit);
        CompilerAsserts.neverPartOfCompilation((String)"JSException constructor");
        this.type = type;
        this.exceptionObj = null;
        this.isIncompleteSource = false;
    }

    private JSException(JSErrorType type, String message, Node originatingNode, DynamicObject exceptionObj, int stackTraceLimit) {
        super(message, originatingNode, stackTraceLimit);
        CompilerAsserts.neverPartOfCompilation((String)"JSException constructor");
        this.type = type;
        this.exceptionObj = exceptionObj;
        this.isIncompleteSource = false;
    }

    private JSException(JSErrorType type, String message, SourceSection sourceLocation, int stackTraceLimit, boolean isIncompleteSource) {
        super(message, sourceLocation, stackTraceLimit);
        CompilerAsserts.neverPartOfCompilation((String)"JSException constructor");
        this.type = type;
        this.exceptionObj = null;
        this.isIncompleteSource = isIncompleteSource;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSException createCapture(JSErrorType type, String message, DynamicObject exceptionObj, int stackTraceLimit, DynamicObject skipFramesUpTo) {
        return JSException.fillInStackTrace(new JSException(type, message, null, exceptionObj, stackTraceLimit), skipFramesUpTo, true);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSException createCapture(JSErrorType type, String message, DynamicObject exceptionObj) {
        return JSException.createCapture(type, message, exceptionObj, JSException.getStackTraceLimit(), Undefined.instance);
    }

    public static JSException create(JSErrorType type, String message) {
        return JSException.create(type, message, null);
    }

    public static JSException create(JSErrorType type, String message, Node originatingNode) {
        return JSException.fillInStackTrace(new JSException(type, message, originatingNode, null, JSException.getStackTraceLimit()), Undefined.instance, false);
    }

    public static JSException create(JSErrorType type, String message, Throwable cause, Node originatingNode) {
        return JSException.fillInStackTrace(new JSException(type, message, cause, originatingNode, JSException.getStackTraceLimit()), Undefined.instance, false);
    }

    public static JSException create(JSErrorType type, String message, SourceSection sourceLocation, boolean isIncompleteSource) {
        return JSException.fillInStackTrace(new JSException(type, message, sourceLocation, JSException.getStackTraceLimit(), isIncompleteSource), Undefined.instance, false);
    }

    public static int getStackTraceLimit() {
        JSRealm realm = JavaScriptLanguage.getCurrentJSRealm();
        DynamicObject errorConstructor = realm.getErrorConstructor(JSErrorType.Error);
        Object stackTraceLimit = JSObject.get(errorConstructor, (Object)"stackTraceLimit");
        return Math.max(0, (int)JSRuntime.toInteger(stackTraceLimit));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getMessage() {
        String message = this.getRawMessage();
        return message == null || message.isEmpty() ? this.type.name() : this.type.name() + ": " + message;
    }

    public String getRawMessage() {
        return super.getMessage();
    }

    public JSErrorType getErrorType() {
        return this.type;
    }

    public DynamicObject getErrorObject() {
        return this.exceptionObj;
    }

    public void setErrorObject(DynamicObject exceptionObj) {
        this.exceptionObj = exceptionObj;
    }

    @Override
    public Object getExceptionObject() {
        if (this.exceptionObj == null) {
            JSRealm innerRealm = this.realm != null ? this.realm : JavaScriptLanguage.getCurrentJSRealm();
            String message = this.getRawMessage();
            this.exceptionObj = JSError.createFromJSException(this, innerRealm, message == null ? "" : message);
        }
        return super.getExceptionObject();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getErrorObjectEager(JSContext context) {
        if (this.exceptionObj == null) {
            JSRealm innerRealm = this.realm == null ? context.getRealm() : this.realm;
            String message = this.getRawMessage();
            this.exceptionObj = JSError.createFromJSException(this, innerRealm, message == null ? "" : message);
        }
        return this.exceptionObj;
    }

    public JSException setRealm(JSRealm realm) {
        if (this.realm == null) {
            if (this.useCallerRealm) {
                this.useCallerRealm = false;
            } else {
                this.realm = realm;
            }
        }
        return this;
    }

    public JSRealm getRealm() {
        return this.realm;
    }

    public JSException useCallerRealm() {
        this.useCallerRealm = true;
        return this;
    }

    public boolean isSyntaxError() {
        return this.type == JSErrorType.SyntaxError;
    }

    public boolean isIncompleteSource() {
        return this.isIncompleteSource;
    }
}

