/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import java.util.Set;

public abstract class IterationScopeNode
extends JavaScriptNode {
    public static IterationScopeNode create(FrameDescriptor frameDescriptor, JSReadFrameSlotNode[] reads, JSWriteFrameSlotNode[] writes) {
        return new FrameIterationScopeNode(frameDescriptor, reads, writes);
    }

    public abstract VirtualFrame execute(VirtualFrame var1);

    public abstract void executeCopy(VirtualFrame var1, VirtualFrame var2);

    public static final class FrameIterationScopeNode
    extends IterationScopeNode {
        private final FrameDescriptor frameDescriptor;
        @Node.Children
        private final JSReadFrameSlotNode[] reads;
        @Node.Children
        private final JSWriteFrameSlotNode[] writes;

        public FrameIterationScopeNode(FrameDescriptor frameDescriptor, JSReadFrameSlotNode[] reads, JSWriteFrameSlotNode[] writes) {
            this.frameDescriptor = frameDescriptor;
            this.reads = reads;
            this.writes = writes;
            assert (reads.length == writes.length);
        }

        @Override
        public VirtualFrame execute(VirtualFrame frame) {
            VirtualFrame nextFrame = Truffle.getRuntime().createVirtualFrame(frame.getArguments(), this.frameDescriptor);
            this.writes[0].executeWithFrame((Frame)nextFrame, this.reads[0].execute(frame));
            this.copySlots(nextFrame, frame);
            return nextFrame;
        }

        @Override
        public void executeCopy(VirtualFrame nextFrame, VirtualFrame frame) {
            assert (FrameUtil.getObjectSafe((Frame)nextFrame, (FrameSlot)nextFrame.getFrameDescriptor().findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER)) == FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)frame.getFrameDescriptor().findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER)));
            this.copySlots(nextFrame, frame);
        }

        @ExplodeLoop
        private void copySlots(VirtualFrame nextFrame, VirtualFrame frame) {
            for (int i = 1; i < this.reads.length; ++i) {
                this.writes[i].executeWithFrame((Frame)nextFrame, this.reads[i].execute(frame));
            }
        }

        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new FrameIterationScopeNode(this.frameDescriptor, FrameIterationScopeNode.cloneUninitialized(this.reads, materializedTags), FrameIterationScopeNode.cloneUninitialized(this.writes, materializedTags));
        }
    }
}

