/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class DefaultProfileManager
implements ProfileManager {
    private PlexusContainer container;
    private List activatedIds = new ArrayList();
    private List deactivatedIds = new ArrayList();
    private List defaultIds = new ArrayList();
    private Map profilesById = new LinkedHashMap();
    private Properties requestProperties;

    public DefaultProfileManager(PlexusContainer container) {
        this(container, (Settings)null);
    }

    public DefaultProfileManager(PlexusContainer container, Properties props) {
        this(container, null, props);
    }

    public DefaultProfileManager(PlexusContainer container, Settings settings) {
        this.container = container;
        this.loadSettingsProfiles(settings);
    }

    public DefaultProfileManager(PlexusContainer container, Settings settings, Properties props) {
        this.container = container;
        this.loadSettingsProfiles(settings);
        if (props != null) {
            this.requestProperties = props;
        }
    }

    public Properties getRequestProperties() {
        return this.requestProperties;
    }

    public Map getProfilesById() {
        return this.profilesById;
    }

    public void addProfile(Profile profile) {
        String profileId = profile.getId();
        Profile existing = (Profile)this.profilesById.get(profileId);
        if (existing != null) {
            this.container.getLogger().warn("Overriding profile: '" + profileId + "' (source: " + existing.getSource() + ") with new instance from source: " + profile.getSource());
        }
        this.profilesById.put(profile.getId(), profile);
        Activation activation = profile.getActivation();
        if (activation != null && activation.isActiveByDefault()) {
            this.activateAsDefault(profileId);
        }
    }

    public void explicitlyActivate(String profileId) {
        if (!this.activatedIds.contains(profileId)) {
            this.container.getLogger().debug("Profile with id: '" + profileId + "' has been explicitly activated.");
            this.activatedIds.add(profileId);
        }
    }

    public void explicitlyActivate(List profileIds) {
        Iterator it = profileIds.iterator();
        while (it.hasNext()) {
            String profileId = (String)it.next();
            this.explicitlyActivate(profileId);
        }
    }

    public void explicitlyDeactivate(String profileId) {
        if (!this.deactivatedIds.contains(profileId)) {
            this.container.getLogger().debug("Profile with id: '" + profileId + "' has been explicitly deactivated.");
            this.deactivatedIds.add(profileId);
        }
    }

    public void explicitlyDeactivate(List profileIds) {
        Iterator it = profileIds.iterator();
        while (it.hasNext()) {
            String profileId = (String)it.next();
            this.explicitlyDeactivate(profileId);
        }
    }

    public List getActiveProfiles() throws ProfileActivationException {
        ArrayList<Profile> activeFromPom = new ArrayList<Profile>();
        ArrayList<Profile> activeExternal = new ArrayList<Profile>();
        Iterator it = this.profilesById.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String profileId = (String)entry.getKey();
            Profile profile = (Profile)entry.getValue();
            boolean shouldAdd = false;
            if (this.activatedIds.contains(profileId)) {
                shouldAdd = true;
            } else if (this.isActive(profile)) {
                shouldAdd = true;
            }
            if (this.deactivatedIds.contains(profileId) || !shouldAdd) continue;
            if ("pom".equals(profile.getSource())) {
                activeFromPom.add(profile);
                continue;
            }
            activeExternal.add(profile);
        }
        if (activeFromPom.isEmpty()) {
            it = this.defaultIds.iterator();
            while (it.hasNext()) {
                String profileId = (String)((Object)it.next());
                if (this.deactivatedIds.contains(profileId)) continue;
                Profile profile = (Profile)this.profilesById.get(profileId);
                activeFromPom.add(profile);
            }
        }
        ArrayList<Profile> allActive = new ArrayList<Profile>(activeFromPom.size() + activeExternal.size());
        allActive.addAll(activeExternal);
        allActive.addAll(activeFromPom);
        return allActive;
    }

    private boolean isActive(Profile profile) throws ProfileActivationException {
        List activators = null;
        Properties systemProperties = new Properties(System.getProperties());
        if (this.requestProperties != null) {
            systemProperties.putAll((Map<?, ?>)this.requestProperties);
        }
        this.container.addContextValue((Object)"SystemProperties", (Object)systemProperties);
        try {
            activators = this.container.lookupList(ProfileActivator.ROLE);
            Iterator activatorIterator22 = activators.iterator();
            while (activatorIterator22.hasNext()) {
                ProfileActivator activator = (ProfileActivator)activatorIterator22.next();
                if (!activator.canDetermineActivation(profile) || !activator.isActive(profile)) continue;
                boolean bl = true;
                return bl;
            }
            boolean activatorIterator22 = false;
            return activatorIterator22;
        }
        catch (ComponentLookupException e) {
            throw new ProfileActivationException("Cannot retrieve list of profile activators.", e);
        }
        finally {
            this.container.getContext().put((Object)"SystemProperties", null);
            if (activators != null) {
                try {
                    this.container.releaseAll(activators);
                }
                catch (ComponentLifecycleException e) {
                    this.container.getLogger().debug("Error releasing profile activators - ignoring.", (Throwable)e);
                }
            }
        }
    }

    public void addProfiles(List profiles) {
        Iterator it = profiles.iterator();
        while (it.hasNext()) {
            Profile profile = (Profile)it.next();
            this.addProfile(profile);
        }
    }

    public void activateAsDefault(String profileId) {
        if (!this.defaultIds.contains(profileId)) {
            this.defaultIds.add(profileId);
        }
    }

    public List getExplicitlyActivatedIds() {
        return this.activatedIds;
    }

    public List getExplicitlyDeactivatedIds() {
        return this.deactivatedIds;
    }

    public List getIdsActivatedByDefault() {
        return this.defaultIds;
    }

    public void loadSettingsProfiles(Settings settings) {
        if (settings == null) {
            return;
        }
        List settingsProfiles = settings.getProfiles();
        List settingsActiveProfileIds = settings.getActiveProfiles();
        this.explicitlyActivate(settingsActiveProfileIds);
        if (settingsProfiles != null && !settingsProfiles.isEmpty()) {
            Iterator it = settings.getProfiles().iterator();
            while (it.hasNext()) {
                org.apache.maven.settings.Profile rawProfile = (org.apache.maven.settings.Profile)it.next();
                Profile profile = SettingsUtils.convertFromSettingsProfile((org.apache.maven.settings.Profile)rawProfile);
                this.addProfile(profile);
            }
        }
    }
}

