/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.graph.transformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.collection.DependencyGraphTransformationContext;
import org.sonatype.aether.collection.DependencyGraphTransformer;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.util.graph.transformer.ConflictIdSorter;
import org.sonatype.aether.util.graph.transformer.TransformationContextKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEffectiveScopeCalculator
implements DependencyGraphTransformer {
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        Map conflictIds;
        List sortedConflictIds = (List)context.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        if (sortedConflictIds == null) {
            ConflictIdSorter sorter = new ConflictIdSorter();
            sorter.transformGraph(node, context);
            sortedConflictIds = (List)context.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        }
        if ((conflictIds = (Map)context.get(TransformationContextKeys.CONFLICT_IDS)) == null) {
            throw new RepositoryException("conflict groups have not been identified");
        }
        HashMap<Object, ConflictGroup> groups = new HashMap<Object, ConflictGroup>(256);
        this.buildConflictGroups(groups, node, null, conflictIds);
        String rootScope = "";
        if (node.getDependency() != null) {
            Object key = conflictIds.get(node);
            ((ConflictGroup)groups.get(key)).scope = rootScope = node.getDependency().getScope();
        }
        for (DependencyNode child : node.getChildren()) {
            Object key = conflictIds.get(child);
            ((ConflictGroup)groups.get(key)).scope = this.getInheritedScope(rootScope, child.getDependency().getScope());
        }
        for (Object key : sortedConflictIds) {
            ConflictGroup group = (ConflictGroup)groups.get(key);
            this.resolve(group);
        }
        return node;
    }

    private void buildConflictGroups(Map<Object, ConflictGroup> groups, DependencyNode node, DependencyNode parent, Map<?, ?> conflictIds) {
        List<DependencyNode> parents;
        boolean visited;
        Object key = conflictIds.get(node);
        ConflictGroup group = groups.get(key);
        if (group == null) {
            group = new ConflictGroup(key);
            groups.put(key, group);
        }
        boolean bl = visited = (parents = group.parents.get(node)) != null;
        if (parents == null) {
            parents = new ArrayList<DependencyNode>(4);
            group.parents.put(node, parents);
        }
        if (parent != null) {
            parents.add(parent);
        }
        if (!visited) {
            parent = node.getDependency() != null ? node : null;
            for (DependencyNode child : node.getChildren()) {
                this.buildConflictGroups(groups, child, parent, conflictIds);
            }
        }
    }

    private void resolve(ConflictGroup group) {
        if (group.scope == null) {
            Set<String> inheritedScopes = this.getInheritedScopes(group);
            group.scope = this.chooseEffectiveScope(inheritedScopes);
        }
        for (DependencyNode node : group.parents.keySet()) {
            String scope;
            if (node.getPremanagedScope() != null || group.scope.equals(scope = node.getDependency().getScope()) || "system".equals(scope)) continue;
            node.setScope(group.scope);
        }
    }

    private Set<String> getInheritedScopes(ConflictGroup group) {
        HashSet<String> inheritedScopes = new HashSet<String>();
        for (Map.Entry<DependencyNode, List<DependencyNode>> entry : group.parents.entrySet()) {
            String childScope = entry.getKey().getDependency().getScope();
            if (entry.getValue().isEmpty()) {
                inheritedScopes.add(childScope);
                continue;
            }
            for (DependencyNode parent : entry.getValue()) {
                String parentScope = parent.getDependency().getScope();
                String inheritedScope = this.getInheritedScope(parentScope, childScope);
                inheritedScopes.add(inheritedScope);
            }
        }
        return inheritedScopes;
    }

    private String getInheritedScope(String parentScope, String childScope) {
        String inheritedScope = "system".equals(childScope) || "test".equals(childScope) ? childScope : (parentScope == null || parentScope.length() <= 0 || "compile".equals(parentScope) ? childScope : ("test".equals(parentScope) || "runtime".equals(parentScope) ? parentScope : ("system".equals(parentScope) || "provided".equals(parentScope) ? "provided" : "runtime")));
        return inheritedScope;
    }

    private String chooseEffectiveScope(Set<String> scopes) {
        if (scopes.size() > 1) {
            scopes.remove("system");
        }
        String effectiveScope = "";
        if (scopes.size() == 1) {
            effectiveScope = scopes.iterator().next();
        } else if (scopes.contains("compile")) {
            effectiveScope = "compile";
        } else if (scopes.contains("runtime")) {
            effectiveScope = "runtime";
        } else if (scopes.contains("provided")) {
            effectiveScope = "provided";
        } else if (scopes.contains("test")) {
            effectiveScope = "test";
        }
        return effectiveScope;
    }

    static final class ConflictGroup {
        final Object key;
        final Map<DependencyNode, List<DependencyNode>> parents;
        String scope;

        public ConflictGroup(Object key) {
            this.key = key;
            this.parents = new IdentityHashMap<DependencyNode, List<DependencyNode>>();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConflictGroup)) {
                return false;
            }
            ConflictGroup that = (ConflictGroup)obj;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return String.valueOf(this.key);
        }
    }
}

