/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.parser;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.parser.AbstractXmlParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class XhtmlBaseParser
extends AbstractXmlParser
implements HtmlMarkup {
    private boolean scriptBlock;
    private boolean isLink;
    private boolean isAnchor;
    private int orderedListDepth = 0;
    private int sectionLevel;
    private boolean inVerbatim;
    private boolean inFigure;
    boolean hasDefinitionListItem = false;
    private Map<String, Set<String>> warnMessages;

    @Override
    public void parse(Reader source, Sink sink) throws ParseException {
        this.init();
        try {
            super.parse(source, sink);
        }
        finally {
            this.logWarnings();
            this.setSecondParsing(false);
            this.init();
        }
    }

    @Override
    protected void initXmlParser(XmlPullParser parser) throws XmlPullParserException {
        super.initXmlParser(parser);
        parser.defineEntityReplacementText("nbsp", "\u00a0");
        parser.defineEntityReplacementText("iexcl", "\u00a1");
        parser.defineEntityReplacementText("cent", "\u00a2");
        parser.defineEntityReplacementText("pound", "\u00a3");
        parser.defineEntityReplacementText("curren", "\u00a4");
        parser.defineEntityReplacementText("yen", "\u00a5");
        parser.defineEntityReplacementText("brvbar", "\u00a6");
        parser.defineEntityReplacementText("sect", "\u00a7");
        parser.defineEntityReplacementText("uml", "\u00a8");
        parser.defineEntityReplacementText("copy", "\u00a9");
        parser.defineEntityReplacementText("ordf", "\u00aa");
        parser.defineEntityReplacementText("laquo", "\u00ab");
        parser.defineEntityReplacementText("not", "\u00ac");
        parser.defineEntityReplacementText("shy", "\u00ad");
        parser.defineEntityReplacementText("reg", "\u00ae");
        parser.defineEntityReplacementText("macr", "\u00af");
        parser.defineEntityReplacementText("deg", "\u00b0");
        parser.defineEntityReplacementText("plusmn", "\u00b1");
        parser.defineEntityReplacementText("sup2", "\u00b2");
        parser.defineEntityReplacementText("sup3", "\u00b3");
        parser.defineEntityReplacementText("acute", "\u00b4");
        parser.defineEntityReplacementText("micro", "\u00b5");
        parser.defineEntityReplacementText("para", "\u00b6");
        parser.defineEntityReplacementText("middot", "\u00b7");
        parser.defineEntityReplacementText("cedil", "\u00b8");
        parser.defineEntityReplacementText("sup1", "\u00b9");
        parser.defineEntityReplacementText("ordm", "\u00ba");
        parser.defineEntityReplacementText("raquo", "\u00bb");
        parser.defineEntityReplacementText("frac14", "\u00bc");
        parser.defineEntityReplacementText("frac12", "\u00bd");
        parser.defineEntityReplacementText("frac34", "\u00be");
        parser.defineEntityReplacementText("iquest", "\u00bf");
        parser.defineEntityReplacementText("Agrave", "\u00c0");
        parser.defineEntityReplacementText("Aacute", "\u00c1");
        parser.defineEntityReplacementText("Acirc", "\u00c2");
        parser.defineEntityReplacementText("Atilde", "\u00c3");
        parser.defineEntityReplacementText("Auml", "\u00c4");
        parser.defineEntityReplacementText("Aring", "\u00c5");
        parser.defineEntityReplacementText("AElig", "\u00c6");
        parser.defineEntityReplacementText("Ccedil", "\u00c7");
        parser.defineEntityReplacementText("Egrave", "\u00c8");
        parser.defineEntityReplacementText("Eacute", "\u00c9");
        parser.defineEntityReplacementText("Ecirc", "\u00ca");
        parser.defineEntityReplacementText("Euml", "\u00cb");
        parser.defineEntityReplacementText("Igrave", "\u00cc");
        parser.defineEntityReplacementText("Iacute", "\u00cd");
        parser.defineEntityReplacementText("Icirc", "\u00ce");
        parser.defineEntityReplacementText("Iuml", "\u00cf");
        parser.defineEntityReplacementText("ETH", "\u00d0");
        parser.defineEntityReplacementText("Ntilde", "\u00d1");
        parser.defineEntityReplacementText("Ograve", "\u00d2");
        parser.defineEntityReplacementText("Oacute", "\u00d3");
        parser.defineEntityReplacementText("Ocirc", "\u00d4");
        parser.defineEntityReplacementText("Otilde", "\u00d5");
        parser.defineEntityReplacementText("Ouml", "\u00d6");
        parser.defineEntityReplacementText("times", "\u00d7");
        parser.defineEntityReplacementText("Oslash", "\u00d8");
        parser.defineEntityReplacementText("Ugrave", "\u00d9");
        parser.defineEntityReplacementText("Uacute", "\u00da");
        parser.defineEntityReplacementText("Ucirc", "\u00db");
        parser.defineEntityReplacementText("Uuml", "\u00dc");
        parser.defineEntityReplacementText("Yacute", "\u00dd");
        parser.defineEntityReplacementText("THORN", "\u00de");
        parser.defineEntityReplacementText("szlig", "\u00df");
        parser.defineEntityReplacementText("agrave", "\u00e0");
        parser.defineEntityReplacementText("aacute", "\u00e1");
        parser.defineEntityReplacementText("acirc", "\u00e2");
        parser.defineEntityReplacementText("atilde", "\u00e3");
        parser.defineEntityReplacementText("auml", "\u00e4");
        parser.defineEntityReplacementText("aring", "\u00e5");
        parser.defineEntityReplacementText("aelig", "\u00e6");
        parser.defineEntityReplacementText("ccedil", "\u00e7");
        parser.defineEntityReplacementText("egrave", "\u00e8");
        parser.defineEntityReplacementText("eacute", "\u00e9");
        parser.defineEntityReplacementText("ecirc", "\u00ea");
        parser.defineEntityReplacementText("euml", "\u00eb");
        parser.defineEntityReplacementText("igrave", "\u00ec");
        parser.defineEntityReplacementText("iacute", "\u00ed");
        parser.defineEntityReplacementText("icirc", "\u00ee");
        parser.defineEntityReplacementText("iuml", "\u00ef");
        parser.defineEntityReplacementText("eth", "\u00f0");
        parser.defineEntityReplacementText("ntilde", "\u00f1");
        parser.defineEntityReplacementText("ograve", "\u00f2");
        parser.defineEntityReplacementText("oacute", "\u00f3");
        parser.defineEntityReplacementText("ocirc", "\u00f4");
        parser.defineEntityReplacementText("otilde", "\u00f5");
        parser.defineEntityReplacementText("ouml", "\u00f6");
        parser.defineEntityReplacementText("divide", "\u00f7");
        parser.defineEntityReplacementText("oslash", "\u00f8");
        parser.defineEntityReplacementText("ugrave", "\u00f9");
        parser.defineEntityReplacementText("uacute", "\u00fa");
        parser.defineEntityReplacementText("ucirc", "\u00fb");
        parser.defineEntityReplacementText("uuml", "\u00fc");
        parser.defineEntityReplacementText("yacute", "\u00fd");
        parser.defineEntityReplacementText("thorn", "\u00fe");
        parser.defineEntityReplacementText("yuml", "\u00ff");
        parser.defineEntityReplacementText("OElig", "\u0152");
        parser.defineEntityReplacementText("oelig", "\u0153");
        parser.defineEntityReplacementText("Scaron", "\u0160");
        parser.defineEntityReplacementText("scaron", "\u0161");
        parser.defineEntityReplacementText("Yuml", "\u0178");
        parser.defineEntityReplacementText("circ", "\u02c6");
        parser.defineEntityReplacementText("tilde", "\u02dc");
        parser.defineEntityReplacementText("ensp", "\u2002");
        parser.defineEntityReplacementText("emsp", "\u2003");
        parser.defineEntityReplacementText("thinsp", "\u2009");
        parser.defineEntityReplacementText("zwnj", "\u200c");
        parser.defineEntityReplacementText("zwj", "\u200d");
        parser.defineEntityReplacementText("lrm", "\u200e");
        parser.defineEntityReplacementText("rlm", "\u200f");
        parser.defineEntityReplacementText("ndash", "\u2013");
        parser.defineEntityReplacementText("mdash", "\u2014");
        parser.defineEntityReplacementText("lsquo", "\u2018");
        parser.defineEntityReplacementText("rsquo", "\u2019");
        parser.defineEntityReplacementText("sbquo", "\u201a");
        parser.defineEntityReplacementText("ldquo", "\u201c");
        parser.defineEntityReplacementText("rdquo", "\u201d");
        parser.defineEntityReplacementText("bdquo", "\u201e");
        parser.defineEntityReplacementText("dagger", "\u2020");
        parser.defineEntityReplacementText("Dagger", "\u2021");
        parser.defineEntityReplacementText("permil", "\u2030");
        parser.defineEntityReplacementText("lsaquo", "\u2039");
        parser.defineEntityReplacementText("rsaquo", "\u203a");
        parser.defineEntityReplacementText("euro", "\u20ac");
        parser.defineEntityReplacementText("fnof", "\u0192");
        parser.defineEntityReplacementText("Alpha", "\u0391");
        parser.defineEntityReplacementText("Beta", "\u0392");
        parser.defineEntityReplacementText("Gamma", "\u0393");
        parser.defineEntityReplacementText("Delta", "\u0394");
        parser.defineEntityReplacementText("Epsilon", "\u0395");
        parser.defineEntityReplacementText("Zeta", "\u0396");
        parser.defineEntityReplacementText("Eta", "\u0397");
        parser.defineEntityReplacementText("Theta", "\u0398");
        parser.defineEntityReplacementText("Iota", "\u0399");
        parser.defineEntityReplacementText("Kappa", "\u039a");
        parser.defineEntityReplacementText("Lambda", "\u039b");
        parser.defineEntityReplacementText("Mu", "\u039c");
        parser.defineEntityReplacementText("Nu", "\u039d");
        parser.defineEntityReplacementText("Xi", "\u039e");
        parser.defineEntityReplacementText("Omicron", "\u039f");
        parser.defineEntityReplacementText("Pi", "\u03a0");
        parser.defineEntityReplacementText("Rho", "\u03a1");
        parser.defineEntityReplacementText("Sigma", "\u03a3");
        parser.defineEntityReplacementText("Tau", "\u03a4");
        parser.defineEntityReplacementText("Upsilon", "\u03a5");
        parser.defineEntityReplacementText("Phi", "\u03a6");
        parser.defineEntityReplacementText("Chi", "\u03a7");
        parser.defineEntityReplacementText("Psi", "\u03a8");
        parser.defineEntityReplacementText("Omega", "\u03a9");
        parser.defineEntityReplacementText("alpha", "\u03b1");
        parser.defineEntityReplacementText("beta", "\u03b2");
        parser.defineEntityReplacementText("gamma", "\u03b3");
        parser.defineEntityReplacementText("delta", "\u03b4");
        parser.defineEntityReplacementText("epsilon", "\u03b5");
        parser.defineEntityReplacementText("zeta", "\u03b6");
        parser.defineEntityReplacementText("eta", "\u03b7");
        parser.defineEntityReplacementText("theta", "\u03b8");
        parser.defineEntityReplacementText("iota", "\u03b9");
        parser.defineEntityReplacementText("kappa", "\u03ba");
        parser.defineEntityReplacementText("lambda", "\u03bb");
        parser.defineEntityReplacementText("mu", "\u03bc");
        parser.defineEntityReplacementText("nu", "\u03bd");
        parser.defineEntityReplacementText("xi", "\u03be");
        parser.defineEntityReplacementText("omicron", "\u03bf");
        parser.defineEntityReplacementText("pi", "\u03c0");
        parser.defineEntityReplacementText("rho", "\u03c1");
        parser.defineEntityReplacementText("sigmaf", "\u03c2");
        parser.defineEntityReplacementText("sigma", "\u03c3");
        parser.defineEntityReplacementText("tau", "\u03c4");
        parser.defineEntityReplacementText("upsilon", "\u03c5");
        parser.defineEntityReplacementText("phi", "\u03c6");
        parser.defineEntityReplacementText("chi", "\u03c7");
        parser.defineEntityReplacementText("psi", "\u03c8");
        parser.defineEntityReplacementText("omega", "\u03c9");
        parser.defineEntityReplacementText("thetasym", "\u03d1");
        parser.defineEntityReplacementText("upsih", "\u03d2");
        parser.defineEntityReplacementText("piv", "\u03d6");
        parser.defineEntityReplacementText("bull", "\u2022");
        parser.defineEntityReplacementText("hellip", "\u2026");
        parser.defineEntityReplacementText("prime", "\u2032");
        parser.defineEntityReplacementText("Prime", "\u2033");
        parser.defineEntityReplacementText("oline", "\u203e");
        parser.defineEntityReplacementText("frasl", "\u2044");
        parser.defineEntityReplacementText("weierp", "\u2118");
        parser.defineEntityReplacementText("image", "\u2111");
        parser.defineEntityReplacementText("real", "\u211c");
        parser.defineEntityReplacementText("trade", "\u2122");
        parser.defineEntityReplacementText("alefsym", "\u2135");
        parser.defineEntityReplacementText("larr", "\u2190");
        parser.defineEntityReplacementText("uarr", "\u2191");
        parser.defineEntityReplacementText("rarr", "\u2192");
        parser.defineEntityReplacementText("darr", "\u2193");
        parser.defineEntityReplacementText("harr", "\u2194");
        parser.defineEntityReplacementText("crarr", "\u21b5");
        parser.defineEntityReplacementText("lArr", "\u21d0");
        parser.defineEntityReplacementText("uArr", "\u21d1");
        parser.defineEntityReplacementText("rArr", "\u21d2");
        parser.defineEntityReplacementText("dArr", "\u21d3");
        parser.defineEntityReplacementText("hArr", "\u21d4");
        parser.defineEntityReplacementText("forall", "\u2200");
        parser.defineEntityReplacementText("part", "\u2202");
        parser.defineEntityReplacementText("exist", "\u2203");
        parser.defineEntityReplacementText("empty", "\u2205");
        parser.defineEntityReplacementText("nabla", "\u2207");
        parser.defineEntityReplacementText("isin", "\u2208");
        parser.defineEntityReplacementText("notin", "\u2209");
        parser.defineEntityReplacementText("ni", "\u220b");
        parser.defineEntityReplacementText("prod", "\u220f");
        parser.defineEntityReplacementText("sum", "\u2211");
        parser.defineEntityReplacementText("minus", "\u2212");
        parser.defineEntityReplacementText("lowast", "\u2217");
        parser.defineEntityReplacementText("radic", "\u221a");
        parser.defineEntityReplacementText("prop", "\u221d");
        parser.defineEntityReplacementText("infin", "\u221e");
        parser.defineEntityReplacementText("ang", "\u2220");
        parser.defineEntityReplacementText("and", "\u2227");
        parser.defineEntityReplacementText("or", "\u2228");
        parser.defineEntityReplacementText("cap", "\u2229");
        parser.defineEntityReplacementText("cup", "\u222a");
        parser.defineEntityReplacementText("int", "\u222b");
        parser.defineEntityReplacementText("there4", "\u2234");
        parser.defineEntityReplacementText("sim", "\u223c");
        parser.defineEntityReplacementText("cong", "\u2245");
        parser.defineEntityReplacementText("asymp", "\u2248");
        parser.defineEntityReplacementText("ne", "\u2260");
        parser.defineEntityReplacementText("equiv", "\u2261");
        parser.defineEntityReplacementText("le", "\u2264");
        parser.defineEntityReplacementText("ge", "\u2265");
        parser.defineEntityReplacementText("sub", "\u2282");
        parser.defineEntityReplacementText("sup", "\u2283");
        parser.defineEntityReplacementText("nsub", "\u2284");
        parser.defineEntityReplacementText("sube", "\u2286");
        parser.defineEntityReplacementText("supe", "\u2287");
        parser.defineEntityReplacementText("oplus", "\u2295");
        parser.defineEntityReplacementText("otimes", "\u2297");
        parser.defineEntityReplacementText("perp", "\u22a5");
        parser.defineEntityReplacementText("sdot", "\u22c5");
        parser.defineEntityReplacementText("lceil", "\u2308");
        parser.defineEntityReplacementText("rceil", "\u2309");
        parser.defineEntityReplacementText("lfloor", "\u230a");
        parser.defineEntityReplacementText("rfloor", "\u230b");
        parser.defineEntityReplacementText("lang", "\u2329");
        parser.defineEntityReplacementText("rang", "\u232a");
        parser.defineEntityReplacementText("loz", "\u25ca");
        parser.defineEntityReplacementText("spades", "\u2660");
        parser.defineEntityReplacementText("clubs", "\u2663");
        parser.defineEntityReplacementText("hearts", "\u2665");
        parser.defineEntityReplacementText("diams", "\u2666");
    }

    protected boolean baseStartTag(XmlPullParser parser, Sink sink) {
        boolean visited = true;
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        if (parser.getName().equals(HtmlMarkup.H2.toString())) {
            this.handleSectionStart(sink, 1, attribs);
        } else if (parser.getName().equals(HtmlMarkup.H3.toString())) {
            this.handleSectionStart(sink, 2, attribs);
        } else if (parser.getName().equals(HtmlMarkup.H4.toString())) {
            this.handleSectionStart(sink, 3, attribs);
        } else if (parser.getName().equals(HtmlMarkup.H5.toString())) {
            this.handleSectionStart(sink, 4, attribs);
        } else if (parser.getName().equals(HtmlMarkup.H6.toString())) {
            this.handleSectionStart(sink, 5, attribs);
        } else if (parser.getName().equals(HtmlMarkup.U.toString())) {
            attribs.addAttributes((AttributeSet)SinkEventAttributeSet.Semantics.ANNOTATION);
            sink.inline((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.S.toString()) || parser.getName().equals(HtmlMarkup.STRIKE.toString()) || parser.getName().equals("del")) {
            attribs.addAttributes((AttributeSet)SinkEventAttributeSet.Semantics.LINE_THROUGH);
            sink.inline((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.SUB.toString())) {
            attribs.addAttributes((AttributeSet)SinkEventAttributeSet.Semantics.SUBSCRIPT);
            sink.inline((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.SUP.toString())) {
            attribs.addAttributes((AttributeSet)SinkEventAttributeSet.Semantics.SUPERSCRIPT);
            sink.inline((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.P.toString())) {
            this.handlePStart(sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.DIV.toString())) {
            visited = this.handleDivStart(parser, attribs, sink);
        } else if (parser.getName().equals(HtmlMarkup.PRE.toString())) {
            this.handlePreStart(attribs, sink);
        } else if (parser.getName().equals(HtmlMarkup.UL.toString())) {
            sink.list((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.OL.toString())) {
            this.handleOLStart(parser, sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.LI.toString())) {
            this.handleLIStart(sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.DL.toString())) {
            sink.definitionList((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.DT.toString())) {
            if (this.hasDefinitionListItem) {
                sink.definitionListItem_();
            }
            sink.definitionListItem((SinkEventAttributes)attribs);
            this.hasDefinitionListItem = true;
            sink.definedTerm((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.DD.toString())) {
            if (!this.hasDefinitionListItem) {
                sink.definitionListItem((SinkEventAttributes)attribs);
            }
            sink.definition((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.B.toString()) || parser.getName().equals(HtmlMarkup.STRONG.toString())) {
            sink.inline(SinkEventAttributeSet.Semantics.BOLD);
        } else if (parser.getName().equals(HtmlMarkup.I.toString()) || parser.getName().equals(HtmlMarkup.EM.toString())) {
            this.handleFigureCaptionStart(sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.CODE.toString()) || parser.getName().equals(HtmlMarkup.SAMP.toString()) || parser.getName().equals(HtmlMarkup.TT.toString())) {
            sink.inline(SinkEventAttributeSet.Semantics.CODE);
        } else if (parser.getName().equals(HtmlMarkup.A.toString())) {
            this.handleAStart(parser, sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.TABLE.toString())) {
            this.handleTableStart(sink, attribs, parser);
        } else if (parser.getName().equals(HtmlMarkup.TR.toString())) {
            sink.tableRow((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.TH.toString())) {
            sink.tableHeaderCell((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.TD.toString())) {
            sink.tableCell((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.CAPTION.toString())) {
            sink.tableCaption((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.BR.toString())) {
            sink.lineBreak((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.HR.toString())) {
            sink.horizontalRule((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HtmlMarkup.IMG.toString())) {
            this.handleImgStart(parser, sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.SCRIPT.toString()) || parser.getName().equals(HtmlMarkup.STYLE.toString())) {
            this.handleUnknown(parser, sink, 2);
            this.scriptBlock = true;
        } else {
            visited = false;
        }
        return visited;
    }

    protected boolean baseEndTag(XmlPullParser parser, Sink sink) {
        boolean visited = true;
        if (parser.getName().equals(HtmlMarkup.P.toString())) {
            if (!this.inFigure) {
                sink.paragraph_();
            }
        } else if (parser.getName().equals(HtmlMarkup.U.toString()) || parser.getName().equals(HtmlMarkup.S.toString()) || parser.getName().equals(HtmlMarkup.STRIKE.toString()) || parser.getName().equals("del")) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.SUB.toString()) || parser.getName().equals(HtmlMarkup.SUP.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.DIV.toString())) {
            if (this.inFigure) {
                sink.figure_();
                this.inFigure = false;
            } else {
                visited = false;
            }
        } else if (parser.getName().equals(HtmlMarkup.PRE.toString())) {
            this.verbatim_();
            sink.verbatim_();
        } else if (parser.getName().equals(HtmlMarkup.UL.toString())) {
            sink.list_();
        } else if (parser.getName().equals(HtmlMarkup.OL.toString())) {
            sink.numberedList_();
            --this.orderedListDepth;
        } else if (parser.getName().equals(HtmlMarkup.LI.toString())) {
            this.handleListItemEnd(sink);
        } else if (parser.getName().equals(HtmlMarkup.DL.toString())) {
            if (this.hasDefinitionListItem) {
                sink.definitionListItem_();
                this.hasDefinitionListItem = false;
            }
            sink.definitionList_();
        } else if (parser.getName().equals(HtmlMarkup.DT.toString())) {
            sink.definedTerm_();
        } else if (parser.getName().equals(HtmlMarkup.DD.toString())) {
            sink.definition_();
            sink.definitionListItem_();
            this.hasDefinitionListItem = false;
        } else if (parser.getName().equals(HtmlMarkup.B.toString()) || parser.getName().equals(HtmlMarkup.STRONG.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.I.toString()) || parser.getName().equals(HtmlMarkup.EM.toString())) {
            this.handleFigureCaptionEnd(sink);
        } else if (parser.getName().equals(HtmlMarkup.CODE.toString()) || parser.getName().equals(HtmlMarkup.SAMP.toString()) || parser.getName().equals(HtmlMarkup.TT.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.A.toString())) {
            this.handleAEnd(sink);
        } else if (parser.getName().equals(HtmlMarkup.TABLE.toString())) {
            sink.tableRows_();
            sink.table_();
        } else if (parser.getName().equals(HtmlMarkup.TR.toString())) {
            sink.tableRow_();
        } else if (parser.getName().equals(HtmlMarkup.TH.toString())) {
            sink.tableHeaderCell_();
        } else if (parser.getName().equals(HtmlMarkup.TD.toString())) {
            sink.tableCell_();
        } else if (parser.getName().equals(HtmlMarkup.CAPTION.toString())) {
            sink.tableCaption_();
        } else if (parser.getName().equals(HtmlMarkup.H2.toString())) {
            sink.sectionTitle1_();
        } else if (parser.getName().equals(HtmlMarkup.H3.toString())) {
            sink.sectionTitle2_();
        } else if (parser.getName().equals(HtmlMarkup.H4.toString())) {
            sink.sectionTitle3_();
        } else if (parser.getName().equals(HtmlMarkup.H5.toString())) {
            sink.sectionTitle4_();
        } else if (parser.getName().equals(HtmlMarkup.H6.toString())) {
            sink.sectionTitle5_();
        } else if (parser.getName().equals(HtmlMarkup.SCRIPT.toString()) || parser.getName().equals(HtmlMarkup.STYLE.toString())) {
            this.handleUnknown(parser, sink, 3);
            this.scriptBlock = false;
        } else {
            visited = false;
        }
        return visited;
    }

    @Override
    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (!this.baseStartTag(parser, sink) && this.getLog().isWarnEnabled()) {
            String position = "[" + parser.getLineNumber() + ":" + parser.getColumnNumber() + "]";
            String tag = "<" + parser.getName() + ">";
            this.getLog().warn((CharSequence)("Unrecognized xml tag: " + tag + " at " + position));
        }
    }

    @Override
    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (!this.baseEndTag(parser, sink)) {
            // empty if block
        }
    }

    @Override
    protected void handleText(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if (StringUtils.isNotEmpty((String)text) && !this.isScriptBlock()) {
            sink.text(text);
        }
    }

    @Override
    protected void handleComment(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if ("PB".equals(text.trim())) {
            sink.pageBreak();
        } else if (this.isEmitComments()) {
            sink.comment(text);
        }
    }

    @Override
    protected void handleCdsect(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if (this.isScriptBlock()) {
            sink.unknown("CDATA", new Object[]{5, text}, null);
        } else {
            sink.text(text);
        }
    }

    protected void consecutiveSections(int newLevel, Sink sink) {
        this.closeOpenSections(newLevel, sink);
        this.openMissingSections(newLevel, sink);
        this.sectionLevel = newLevel;
    }

    private void closeOpenSections(int newLevel, Sink sink) {
        while (this.sectionLevel >= newLevel) {
            if (this.sectionLevel == 5) {
                sink.section5_();
            } else if (this.sectionLevel == 4) {
                sink.section4_();
            } else if (this.sectionLevel == 3) {
                sink.section3_();
            } else if (this.sectionLevel == 2) {
                sink.section2_();
            } else if (this.sectionLevel == 1) {
                sink.section1_();
            }
            --this.sectionLevel;
        }
    }

    private void openMissingSections(int newLevel, Sink sink) {
        while (this.sectionLevel < newLevel - 1) {
            ++this.sectionLevel;
            if (this.sectionLevel == 5) {
                sink.section5();
                continue;
            }
            if (this.sectionLevel == 4) {
                sink.section4();
                continue;
            }
            if (this.sectionLevel == 3) {
                sink.section3();
                continue;
            }
            if (this.sectionLevel == 2) {
                sink.section2();
                continue;
            }
            if (this.sectionLevel != 1) continue;
            sink.section1();
        }
    }

    protected int getSectionLevel() {
        return this.sectionLevel;
    }

    protected void setSectionLevel(int newLevel) {
        this.sectionLevel = newLevel;
    }

    protected void verbatim_() {
        this.inVerbatim = false;
    }

    protected void verbatim() {
        this.inVerbatim = true;
    }

    protected boolean isVerbatim() {
        return this.inVerbatim;
    }

    protected boolean isScriptBlock() {
        return this.scriptBlock;
    }

    protected String validAnchor(String id) {
        if (!DoxiaUtils.isValidId(id)) {
            String linkAnchor = DoxiaUtils.encodeId(id, true);
            String msg = "Modified invalid link: '" + id + "' to '" + linkAnchor + "'";
            this.logMessage("modifiedLink", msg);
            return linkAnchor;
        }
        return id;
    }

    @Override
    protected void init() {
        super.init();
        this.scriptBlock = false;
        this.isLink = false;
        this.isAnchor = false;
        this.orderedListDepth = 0;
        this.sectionLevel = 0;
        this.inVerbatim = false;
        this.inFigure = false;
        this.warnMessages = null;
    }

    private void handleAEnd(Sink sink) {
        if (this.isLink) {
            sink.link_();
            this.isLink = false;
        } else if (this.isAnchor) {
            sink.anchor_();
            this.isAnchor = false;
        }
    }

    private void handleAStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) {
        String href = parser.getAttributeValue(null, HTML.Attribute.HREF.toString());
        if (href != null) {
            String hash;
            int hashIndex = href.indexOf(35);
            if (hashIndex != -1 && !DoxiaUtils.isExternalLink(href) && !DoxiaUtils.isValidId(hash = href.substring(hashIndex + 1))) {
                href = href.substring(0, hashIndex) + "#" + DoxiaUtils.encodeId(hash, true);
                String msg = "Modified invalid link: '" + hash + "' to '" + href + "'";
                this.logMessage("modifiedLink", msg);
            }
            sink.link(href, (SinkEventAttributes)attribs);
            this.isLink = true;
        } else {
            String name = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
            if (name != null) {
                sink.anchor(this.validAnchor(name), (SinkEventAttributes)attribs);
                this.isAnchor = true;
            } else {
                String id = parser.getAttributeValue(null, HTML.Attribute.ID.toString());
                if (id != null) {
                    sink.anchor(this.validAnchor(id), (SinkEventAttributes)attribs);
                    this.isAnchor = true;
                }
            }
        }
    }

    private boolean handleDivStart(XmlPullParser parser, SinkEventAttributeSet attribs, Sink sink) {
        boolean visited = true;
        String divclass = parser.getAttributeValue(null, HTML.Attribute.CLASS.toString());
        if ("figure".equals(divclass)) {
            this.inFigure = true;
            SinkEventAttributeSet atts = new SinkEventAttributeSet((AttributeSet)((Object)attribs));
            atts.removeAttribute("class");
            sink.figure((SinkEventAttributes)atts);
        } else {
            visited = false;
        }
        return visited;
    }

    private void handleFigureCaptionEnd(Sink sink) {
        if (this.inFigure) {
            sink.figureCaption_();
        } else {
            sink.inline_();
        }
    }

    private void handleFigureCaptionStart(Sink sink, SinkEventAttributeSet attribs) {
        if (this.inFigure) {
            sink.figureCaption((SinkEventAttributes)attribs);
        } else {
            sink.inline(SinkEventAttributeSet.Semantics.ITALIC);
        }
    }

    private void handleImgStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) {
        String src = parser.getAttributeValue(null, HTML.Attribute.SRC.toString());
        if (src != null) {
            sink.figureGraphics(src, (SinkEventAttributes)attribs);
        }
    }

    private void handleLIStart(Sink sink, SinkEventAttributeSet attribs) {
        if (this.orderedListDepth == 0) {
            sink.listItem((SinkEventAttributes)attribs);
        } else {
            sink.numberedListItem((SinkEventAttributes)attribs);
        }
    }

    private void handleListItemEnd(Sink sink) {
        if (this.orderedListDepth == 0) {
            sink.listItem_();
        } else {
            sink.numberedListItem_();
        }
    }

    private void handleOLStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) {
        int numbering = 0;
        String style = parser.getAttributeValue(null, HTML.Attribute.STYLE.toString());
        if (style != null) {
            switch (style) {
                case "list-style-type: upper-alpha": {
                    numbering = 2;
                    break;
                }
                case "list-style-type: lower-alpha": {
                    numbering = 1;
                    break;
                }
                case "list-style-type: upper-roman": {
                    numbering = 4;
                    break;
                }
                case "list-style-type: lower-roman": {
                    numbering = 3;
                    break;
                }
                case "list-style-type: decimal": {
                    numbering = 0;
                    break;
                }
            }
        }
        sink.numberedList(numbering, (SinkEventAttributes)attribs);
        ++this.orderedListDepth;
    }

    private void handlePStart(Sink sink, SinkEventAttributeSet attribs) {
        if (!this.inFigure) {
            sink.paragraph((SinkEventAttributes)attribs);
        }
    }

    private void handlePreStart(SinkEventAttributeSet attribs, Sink sink) {
        this.verbatim();
        sink.verbatim((SinkEventAttributes)attribs);
    }

    private void handleSectionStart(Sink sink, int level, SinkEventAttributeSet attribs) {
        this.consecutiveSections(level, sink);
        sink.section(level, (SinkEventAttributes)attribs);
        sink.sectionTitle(level, (SinkEventAttributes)attribs);
    }

    private void handleTableStart(Sink sink, SinkEventAttributeSet attribs, XmlPullParser parser) {
        sink.table((SinkEventAttributes)attribs);
        String border = parser.getAttributeValue(null, HTML.Attribute.BORDER.toString());
        boolean grid = true;
        if (border == null || "0".equals(border)) {
            grid = false;
        }
        String align = parser.getAttributeValue(null, HTML.Attribute.ALIGN.toString());
        int[] justif = new int[]{1};
        if ("center".equals(align)) {
            justif[0] = 0;
        } else if ("right".equals(align)) {
            justif[0] = 2;
        }
        sink.tableRows(justif, grid);
    }

    private void logMessage(String key, String msg) {
        Set<String> set;
        String log = "[XHTML Parser] " + msg;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)log);
            return;
        }
        if (this.warnMessages == null) {
            this.warnMessages = new HashMap<String, Set<String>>();
        }
        if ((set = this.warnMessages.get(key)) == null) {
            set = new TreeSet<String>();
        }
        set.add(log);
        this.warnMessages.put(key, set);
    }

    private void logWarnings() {
        if (this.getLog().isWarnEnabled() && this.warnMessages != null && !this.isSecondParsing()) {
            for (Map.Entry<String, Set<String>> entry : this.warnMessages.entrySet()) {
                for (String msg : entry.getValue()) {
                    this.getLog().warn((CharSequence)msg);
                }
            }
            this.warnMessages = null;
        }
    }
}

