/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;

public class MavenBuildTimestamp {
    public static final String DEFAULT_BUILD_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String BUILD_TIMESTAMP_FORMAT_PROPERTY = "maven.build.timestamp.format";
    public static final TimeZone DEFAULT_BUILD_TIME_ZONE = TimeZone.getTimeZone("Etc/UTC");
    private String formattedTimestamp;

    public MavenBuildTimestamp() {
        this(new Date());
    }

    public MavenBuildTimestamp(Date time) {
        this(time, DEFAULT_BUILD_TIMESTAMP_FORMAT);
    }

    public MavenBuildTimestamp(Date time, Properties properties) {
        this(time, properties != null ? properties.getProperty(BUILD_TIMESTAMP_FORMAT_PROPERTY) : null);
    }

    public MavenBuildTimestamp(Date time, String timestampFormat) {
        SimpleDateFormat dateFormat = timestampFormat == null ? new SimpleDateFormat(DEFAULT_BUILD_TIMESTAMP_FORMAT) : new SimpleDateFormat(timestampFormat);
        dateFormat.setCalendar(new GregorianCalendar());
        dateFormat.setTimeZone(DEFAULT_BUILD_TIME_ZONE);
        this.formattedTimestamp = time == null ? dateFormat.format(new Date()) : dateFormat.format(time);
    }

    public String formattedTimestamp() {
        return this.formattedTimestamp;
    }
}

