/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.doxia.siterenderer.DefaultSiteRenderer;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

public class RenderingContext {
    private final File basedir;
    private final String inputName;
    private final String outputName;
    private final String parserId;
    private final String relativePath;
    private final String extension;
    private Map<String, String> attributes;

    public RenderingContext(File basedir, String document) {
        this(basedir, document, null, null);
    }

    public RenderingContext(File basedir, String document, String parserId, String extension) {
        this.basedir = basedir;
        this.extension = extension;
        this.inputName = document;
        this.parserId = parserId;
        this.attributes = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)extension)) {
            if (DefaultSiteRenderer.endsWithIgnoreCase(document, ".vm")) {
                document = document.substring(0, document.length() - 3);
            }
            String fileNameWithoutExt = document.substring(0, document.length() - extension.length() - 1);
            this.outputName = fileNameWithoutExt + ".html";
        } else {
            this.outputName = document.substring(0, document.lastIndexOf(46)).replace('\\', '/') + ".html";
        }
        this.relativePath = PathTool.getRelativePath((String)basedir.getPath(), (String)new File(basedir, this.inputName).getPath());
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String getInputName() {
        return this.inputName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public String getParserId() {
        return this.parserId;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String getExtension() {
        return this.extension;
    }
}

