/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util.internal;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class DaemonThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final String namePrefix;

    private DaemonThreadFactory() {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
    }

    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement());
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        t.setDaemon(true);
        return t;
    }

    public static ThreadFactory newDaemonThreadFactory() {
        return new DaemonThreadFactory();
    }

    public static ThreadFactory newDaemonThreadFactory(String name) {
        return new NamedThreadFactory(name);
    }

    public static Thread newDaemonThread(Runnable r) {
        SecurityManager s = System.getSecurityManager();
        ThreadGroup group = s == null ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
        Thread t = new Thread(group, r);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        t.setDaemon(true);
        return t;
    }

    public static Thread newDaemonThread(Runnable r, String name) {
        SecurityManager s = System.getSecurityManager();
        ThreadGroup group = s == null ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
        Thread t = new Thread(group, r, name);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        t.setDaemon(true);
        return t;
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final String name;

        private NamedThreadFactory(String name) {
            this.name = name;
        }

        public Thread newThread(Runnable r) {
            return DaemonThreadFactory.newDaemonThread(r, this.name);
        }
    }
}

