/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.ant.tasks;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.ant.tasks.support.SpecificScopesArtifactFilter;
import org.apache.maven.ant.tasks.support.TypesArtifactFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class DependencyFilesetsTask
extends Task {
    public static final String DEFAULT_PROJECT_DEPENDENCIES_ID = "maven.project.dependencies";
    private String mavenProjectId = "maven.project";
    private String projectDependenciesId = "maven.project.dependencies";
    private String prefix = "";
    private String types = "";
    private String scopes = "";

    public String getProjectDependenciesId() {
        return this.projectDependenciesId;
    }

    public void setProjectDependenciesId(String projectDependenciesId) {
        this.projectDependenciesId = projectDependenciesId;
    }

    public void execute() {
        if (this.getProject().getReference(this.mavenProjectId) == null) {
            throw new BuildException("Maven project reference not found: " + this.mavenProjectId);
        }
        MavenProject mavenProject = (MavenProject)this.getProject().getReference("maven.project");
        Set depArtifacts = this.filterArtifacts(mavenProject.getArtifacts());
        FileSet dependenciesFileSet = new FileSet();
        dependenciesFileSet.setProject(this.getProject());
        ArtifactRepository localRepository = (ArtifactRepository)this.getProject().getReference("maven.local.repository");
        dependenciesFileSet.setDir(new File(localRepository.getBasedir()));
        for (Artifact artifact : depArtifacts) {
            String relativeArtifactPath = localRepository.pathOf(artifact);
            dependenciesFileSet.createInclude().setName(relativeArtifactPath);
            String fileSetName = this.getPrefix() + artifact.getDependencyConflictId();
            FileSet singleArtifactFileSet = new FileSet();
            singleArtifactFileSet.setProject(this.getProject());
            singleArtifactFileSet.setFile(artifact.getFile());
            this.getProject().addReference(fileSetName, (Object)singleArtifactFileSet);
        }
        this.getProject().addReference(this.getPrefix() + this.projectDependenciesId, (Object)dependenciesFileSet);
    }

    public String getMavenProjectId() {
        return this.mavenProjectId;
    }

    public void setMavenProjectId(String mavenProjectId) {
        this.mavenProjectId = mavenProjectId;
    }

    public String getPrefix() {
        if (this.prefix == null) {
            this.prefix = "";
        }
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getTypes() {
        return this.types;
    }

    public void setTypes(String types) {
        this.types = types;
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public Set filterArtifacts(Set artifacts) {
        if (this.scopes == null) {
            this.scopes = "";
        }
        if (this.types == null) {
            this.types = "";
        }
        if (this.scopes.equals("") && this.types.equals("")) {
            return artifacts;
        }
        AndArtifactFilter filter = new AndArtifactFilter();
        if (!this.scopes.equals("")) {
            filter.add((ArtifactFilter)new SpecificScopesArtifactFilter(this.getScopes()));
        }
        if (!this.types.equals("")) {
            filter.add((ArtifactFilter)new TypesArtifactFilter(this.getTypes()));
        }
        LinkedHashSet<Artifact> artifactsResult = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!filter.include(artifact)) continue;
            artifactsResult.add(artifact);
        }
        return artifactsResult;
    }
}

