/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;

public class MultipleArtifactsNotFoundException
extends ArtifactResolutionException {
    private final List missingArtifacts;

    public MultipleArtifactsNotFoundException(Artifact originatingArtifact, List artifacts, List remoteRepositories) {
        super(MultipleArtifactsNotFoundException.constructMessage(artifacts), originatingArtifact, remoteRepositories);
        this.missingArtifacts = artifacts;
    }

    public List getMissingArtifacts() {
        return this.missingArtifacts;
    }

    private static String constructMessage(List artifacts) {
        StringBuffer buffer = new StringBuffer("Missing:\n");
        buffer.append("----------\n");
        int counter = 0;
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            String message = ++counter + ") " + artifact.getId();
            buffer.append(AbstractArtifactResolutionException.constructMissingArtifactMessage(message, "  ", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier(), artifact.getDownloadUrl(), artifact.getDependencyTrail()));
        }
        buffer.append("----------\n");
        int size = artifacts.size();
        buffer.append(size).append(" required artifact");
        if (size > 1) {
            buffer.append("s are");
        } else {
            buffer.append(" is");
        }
        buffer.append(" missing.\n\nfor artifact: ");
        return buffer.toString();
    }
}

