/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.RegexCompiler;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexObject;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.runtime.nodes.StringEqualsNode;
import com.oracle.truffle.regex.runtime.nodes.ToStringNode;
import com.oracle.truffle.regex.tregex.parser.RegexValidator;
import com.oracle.truffle.regex.tregex.parser.flavors.RegexFlavor;
import com.oracle.truffle.regex.tregex.parser.flavors.RegexFlavorProcessor;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;

@ExportLibrary(value=InteropLibrary.class)
public class RegexEngine
extends AbstractConstantKeysObject {
    private static final String PROP_VALIDATE = "validate";
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("validate");
    private final RegexCompiler compiler;
    private final RegexOptions options;

    public RegexEngine(RegexCompiler compiler, RegexOptions options) {
        this.compiler = compiler;
        this.options = options;
    }

    public RegexObject compile(RegexSource regexSource) throws RegexSyntaxException, UnsupportedRegexException {
        RegexObject regexObject;
        RegexFlavor flavor = this.options.getFlavor();
        if (flavor != null) {
            RegexFlavorProcessor flavorProcessor = flavor.forRegex(regexSource);
            flavorProcessor.validate();
            regexObject = new RegexObject(this.compiler, regexSource, flavorProcessor.getFlags(), flavorProcessor.getNumberOfCaptureGroups(), flavorProcessor.getNamedCaptureGroups());
        } else {
            RegexFlags flags = RegexFlags.parseFlags(regexSource.getFlags());
            RegexValidator validator = new RegexValidator(regexSource, flags, this.options);
            validator.validate();
            this.options.getFeatureSet().checkSupport(regexSource, validator.getFeatures());
            regexObject = new RegexObject(this.compiler, regexSource, flags, validator.getNumberOfCaptureGroups(), validator.getNamedCaptureGroups());
        }
        if (this.options.isRegressionTestMode()) {
            regexObject.getCompiledRegexObject();
        }
        return regexObject;
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "validate": {
                return ValidateMethod.getInstance();
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnknownIdentifierException.create((String)symbol);
    }

    @ExportMessage
    public boolean isExecutable() {
        return true;
    }

    @ExportMessage
    Object execute(Object[] args, @Cached.Shared(value="patternToStringNode") @Cached ToStringNode patternToStringNode, @Cached.Shared(value="flagsToStringNode") @Cached ToStringNode flagsToStringNode) throws ArityException, UnsupportedTypeException {
        return this.compile(RegexEngine.argsToRegexSource(args, patternToStringNode, flagsToStringNode));
    }

    @ExportMessage
    boolean isMemberInvocable(String member, @Cached.Shared(value="isValidatePropNode") @Cached StringEqualsNode isValidatePropNode) {
        return isValidatePropNode.execute(member, PROP_VALIDATE);
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args, @Cached.Shared(value="isValidatePropNode") @Cached StringEqualsNode isValidatePropNode, @Cached.Shared(value="patternToStringNode") @Cached ToStringNode patternToStringNode, @Cached.Shared(value="flagsToStringNode") @Cached ToStringNode flagsToStringNode) throws UnknownIdentifierException, ArityException, UnsupportedTypeException {
        if (!isValidatePropNode.execute(member, PROP_VALIDATE)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnknownIdentifierException.create((String)member);
        }
        RegexLanguage.validateRegex(RegexEngine.argsToRegexSource(args, patternToStringNode, flagsToStringNode));
        return true;
    }

    private static RegexSource argsToRegexSource(Object[] args, ToStringNode patternToStringNode, ToStringNode flagsToStringNode) throws ArityException, UnsupportedTypeException {
        if (args.length != 1 && args.length != 2) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw ArityException.create((int)2, (int)args.length);
        }
        String pattern = patternToStringNode.execute(args[0]);
        String flags = args.length == 2 ? flagsToStringNode.execute(args[1]) : "";
        return new RegexSource(pattern, flags);
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class ValidateMethod
    extends AbstractRegexObject {
        private static final ValidateMethod INSTANCE = new ValidateMethod();

        private ValidateMethod() {
        }

        public static ValidateMethod getInstance() {
            return INSTANCE;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] args, @Cached ToStringNode patternToStringNode, @Cached ToStringNode flagsToStringNode) throws ArityException, UnsupportedTypeException {
            RegexLanguage.validateRegex(RegexEngine.argsToRegexSource(args, patternToStringNode, flagsToStringNode));
            return true;
        }
    }
}

