/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.Profile;
import com.oracle.truffle.js.nodes.cast.JSTrimWhitespaceNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSTrimWhitespaceNode.class)
public final class JSTrimWhitespaceNodeGen
extends JSTrimWhitespaceNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private StringData string_cache;

    private JSTrimWhitespaceNodeGen() {
    }

    @Override
    public String executeString(String arg0Value) {
        int state = this.state_;
        if ((state & 7) != 0) {
            StringData s3_;
            if ((state & 1) != 0 && arg0Value.length() == 0) {
                return this.doStringZero(arg0Value);
            }
            if ((state & 2) != 0 && arg0Value.length() > 0 && !this.startsOrEndsWithWhitespace(arg0Value)) {
                return this.doStringNoWhitespace(arg0Value);
            }
            if ((state & 4) != 0 && (s3_ = this.string_cache) != null && arg0Value.length() > 0 && this.startsOrEndsWithWhitespace(arg0Value)) {
                return this.doString(arg0Value, s3_.needFirstBranch_, s3_.needLastBranch_, s3_.needSubstring_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private String executeAndSpecialize(String arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (arg0Value.length() == 0) {
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                String string = this.doStringZero(arg0Value);
                return string;
            }
            if (arg0Value.length() > 0 && !this.startsOrEndsWithWhitespace(arg0Value)) {
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                String string = this.doStringNoWhitespace(arg0Value);
                return string;
            }
            if (arg0Value.length() > 0 && this.startsOrEndsWithWhitespace(arg0Value)) {
                StringData s3_ = new StringData();
                s3_.needFirstBranch_ = BranchProfile.create();
                s3_.needLastBranch_ = BranchProfile.create();
                s3_.needSubstring_ = ConditionProfile.createBinaryProfile();
                this.string_cache = s3_;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                String string = this.doString(arg0Value, s3_.needFirstBranch_, s3_.needLastBranch_, s3_.needSubstring_);
                return string;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 7) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 7 & (state & 7) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doStringZero";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doStringNoWhitespace";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            ArrayList<List<Profile>> cached = new ArrayList<List<Profile>>();
            StringData s3_ = this.string_cache;
            if (s3_ != null) {
                cached.add(Arrays.asList(s3_.needFirstBranch_, s3_.needLastBranch_, s3_.needSubstring_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSTrimWhitespaceNode create() {
        return new JSTrimWhitespaceNodeGen();
    }

    @GeneratedBy(value=JSTrimWhitespaceNode.class)
    private static final class StringData {
        @CompilerDirectives.CompilationFinal
        BranchProfile needFirstBranch_;
        @CompilerDirectives.CompilationFinal
        BranchProfile needLastBranch_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile needSubstring_;

        StringData() {
        }
    }
}

