/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.clean;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.clean.Cleaner;
import org.apache.maven.plugin.clean.Fileset;
import org.apache.maven.plugin.clean.GlobSelector;

public class CleanMojo
extends AbstractMojo {
    private File directory;
    private File outputDirectory;
    private File testOutputDirectory;
    private File reportDirectory;
    private Boolean verbose;
    private Fileset[] filesets;
    private boolean followSymLinks;
    private boolean skip;
    private boolean failOnError;
    private boolean retryOnError;
    private boolean excludeDefaultDirectories;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Clean is skipped.");
            return;
        }
        Cleaner cleaner = new Cleaner(this.getLog(), this.isVerbose());
        try {
            int i;
            File[] directories = this.getDirectories();
            for (i = 0; i < directories.length; ++i) {
                File directory = directories[i];
                if (directory == null) continue;
                cleaner.delete(directory, null, this.followSymLinks, this.failOnError, this.retryOnError);
            }
            if (this.filesets != null) {
                for (i = 0; i < this.filesets.length; ++i) {
                    Fileset fileset = this.filesets[i];
                    if (fileset.getDirectory() == null) {
                        throw new MojoExecutionException("Missing base directory for " + fileset);
                    }
                    GlobSelector selector = new GlobSelector(fileset.getIncludes(), fileset.getExcludes(), fileset.isUseDefaultExcludes());
                    cleaner.delete(fileset.getDirectory(), selector, fileset.isFollowSymlinks(), this.failOnError, this.retryOnError);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to clean project: " + e.getMessage(), (Exception)e);
        }
    }

    private boolean isVerbose() {
        return this.verbose != null ? this.verbose.booleanValue() : this.getLog().isDebugEnabled();
    }

    private File[] getDirectories() {
        File[] directories = this.excludeDefaultDirectories ? new File[]{} : new File[]{this.directory, this.outputDirectory, this.testOutputDirectory, this.reportDirectory};
        return directories;
    }
}

