/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit.examples;

import org.custommonkey.xmlunit.ElementNameQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecursiveElementNameAndTextQualifier
implements ElementQualifier {
    private static final ElementNameQualifier NAME_QUALIFIER = new ElementNameQualifier();

    public boolean qualifyForComparison(Element currentControl, Element currentTest) {
        return this.compareNodes(currentControl, currentTest);
    }

    private boolean compareNodes(Node currentControl, Node currentTest) {
        try {
            int i;
            if (!NAME_QUALIFIER.qualifyForComparison((Element)currentControl, (Element)currentTest)) {
                return false;
            }
            NodeList controlNodes = null;
            NodeList testNodes = null;
            if (!currentControl.hasChildNodes() || !currentTest.hasChildNodes()) {
                return !currentControl.hasChildNodes() && !currentTest.hasChildNodes();
            }
            controlNodes = currentControl.getChildNodes();
            testNodes = currentTest.getChildNodes();
            if (RecursiveElementNameAndTextQualifier.countNodesWithoutConsecutiveTextNodes(controlNodes) != RecursiveElementNameAndTextQualifier.countNodesWithoutConsecutiveTextNodes(testNodes)) {
                return false;
            }
            int cNodes = controlNodes.getLength();
            int tNodes = testNodes.getLength();
            int j = 0;
            for (i = 0; i < cNodes && j < tNodes; ++i, ++j) {
                Node controlNode = controlNodes.item(i);
                Node testNode = testNodes.item(j);
                if (controlNode.getNodeType() != testNode.getNodeType()) {
                    return false;
                }
                if (controlNode.getNodeType() == 3) {
                    if (!RecursiveElementNameAndTextQualifier.catText(controlNode).equals(RecursiveElementNameAndTextQualifier.catText(testNode))) {
                        return false;
                    }
                    while (i < cNodes - 1 && controlNodes.item(i + 1).getNodeType() == 3) {
                        ++i;
                    }
                    while (j < tNodes - 1 && testNodes.item(j + 1).getNodeType() == 3) {
                        ++j;
                    }
                    continue;
                }
                if (this.compareNodes((Element)controlNode, (Element)testNode)) continue;
                return false;
            }
            return i == cNodes && j == tNodes;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String catText(Node textNode) {
        StringBuffer text = new StringBuffer();
        Node next = textNode;
        do {
            if (next.getNodeValue() == null) continue;
            text.append(next.getNodeValue().trim());
            next = next.getNextSibling();
        } while (next != null && next.getNodeType() == 3);
        return text.toString();
    }

    private static int countNodesWithoutConsecutiveTextNodes(NodeList l) {
        int count = 0;
        boolean lastNodeWasText = false;
        int length = l.getLength();
        for (int i = 0; i < length; ++i) {
            Node n = l.item(i);
            if (!lastNodeWasText || n.getNodeType() != 3) {
                ++count;
            }
            lastNodeWasText = n.getNodeType() == 3;
        }
        return count;
    }
}

