/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.util.collection.ClassificationBag;
import com.vladsch.flexmark.util.collection.OrderedSet;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class SubClassingBag<T> {
    private final ClassificationBag<Class, T> myItems;
    private final HashMap<Class, BitSet> mySubClassMap;

    public SubClassingBag(ClassificationBag<Class, T> items, HashMap<Class, List<Class>> subClassMap) {
        this.myItems = items;
        this.mySubClassMap = new HashMap();
        for (Class clazz : subClassMap.keySet()) {
            List<Class> classList = subClassMap.get(clazz);
            BitSet bitSet = this.myItems.categoriesBitSet((Collection<Class>)classList);
            if (bitSet.isEmpty()) continue;
            this.mySubClassMap.put(clazz, bitSet);
        }
    }

    public OrderedSet<T> getItems() {
        return this.myItems.getItems();
    }

    public boolean contains(T item) {
        return this.myItems.contains(item);
    }

    public boolean containsType(Class type) {
        return this.myItems.containsCategory(type);
    }

    public BitSet getTypeSet(Class category) {
        return this.mySubClassMap.get(category);
    }

    public int getTypeCount(Class category) {
        BitSet bitSet = this.mySubClassMap.get(category);
        return bitSet == null ? 0 : bitSet.cardinality();
    }

    public final <X> ReversibleIterable<X> itemsOfType(Class<X> xClass, Class ... categories) {
        return this.myItems.getCategoryItems(xClass, this.typeBitSet(xClass, categories));
    }

    public final <X> ReversibleIterable<X> itemsOfType(Class<X> xClass, Collection<Class<?>> categories) {
        return this.myItems.getCategoryItems(xClass, this.typeBitSet(xClass, categories));
    }

    public final <X> ReversibleIterable<X> reversedItemsOfType(Class<X> xClass, Class ... categories) {
        return this.myItems.getCategoryItemsReversed(xClass, this.typeBitSet(xClass, categories));
    }

    public final <X> ReversibleIterable<X> reversedItemsOfType(Class<X> xClass, Collection<Class<?>> categories) {
        return this.myItems.getCategoryItemsReversed(xClass, this.typeBitSet(xClass, categories));
    }

    public final BitSet typeBitSet(Class<?> xClass, Class ... categories) {
        BitSet bitSet = new BitSet();
        for (Class category : categories) {
            if (!xClass.isAssignableFrom(category) || !this.mySubClassMap.containsKey(category)) continue;
            bitSet.or(this.mySubClassMap.get(category));
        }
        return bitSet;
    }

    public final BitSet typeBitSet(Class<?> xClass, Collection<Class<?>> categories) {
        BitSet bitSet = new BitSet();
        for (Class<?> category : categories) {
            if (!xClass.isAssignableFrom(category) || !this.mySubClassMap.containsKey(category)) continue;
            bitSet.or(this.mySubClassMap.get(category));
        }
        return bitSet;
    }
}

