/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.ArrayList;

public final class SegmentedSequenceBuilder {
    private final ArrayList<BasedSequence> segments;
    private final BasedSequence base;

    public SegmentedSequenceBuilder(BasedSequence base) {
        this.segments = new ArrayList();
        this.base = base;
    }

    public SegmentedSequenceBuilder(BasedSequence base, int initialCapacity) {
        this.segments = new ArrayList(initialCapacity);
        this.base = base;
    }

    public SegmentedSequenceBuilder append(BasedSequence s) {
        this.segments.add(s);
        return this;
    }

    public SegmentedSequenceBuilder append(String str) {
        BasedSequence useBase;
        if (this.segments.isEmpty()) {
            useBase = this.base.subSequence(0, 0);
        } else {
            useBase = this.segments.get(this.segments.size() - 1);
            useBase = useBase.subSequence(useBase.length(), useBase.length());
        }
        return this.append(PrefixedSubSequence.of(str, useBase));
    }

    public BasedSequence toBasedSequence() {
        return SegmentedSequence.of(this.segments);
    }

    public BasedSequence[] toSegments() {
        return this.segments.toArray(BasedSequence.EMPTY_SEGMENTS);
    }

    public int length() {
        int total = 0;
        BasedSequence last = null;
        for (BasedSequence s : this.segments) {
            if (s.isEmpty()) continue;
            if (last != null && last.getEndOffset() < s.getStartOffset() && " \t\r\n".indexOf(last.charAt(last.length() - 1)) == -1 && " \t\r\n".indexOf(s.charAt(0)) == -1) {
                ++total;
            }
            ++total;
            last = s;
        }
        return total;
    }

    public boolean isEmpty() {
        for (BasedSequence s : this.segments) {
            if (s.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        boolean total = false;
        StringBuilder sb = new StringBuilder();
        BasedSequence last = null;
        for (BasedSequence s : this.segments) {
            if (s.isEmpty()) continue;
            if (last != null && last.getEndOffset() < s.getStartOffset() && " \t\r\n".indexOf(last.charAt(last.length() - 1)) == -1 && " \t\r\n".indexOf(s.charAt(0)) == -1 && s.baseSubSequence(last.getEndOffset(), s.getStartOffset()).endsWith(" ")) {
                sb.append(' ');
            }
            s.appendTo(sb);
            last = s;
        }
        return sb.toString();
    }
}

