#!/bin/sh

set -eux

PGDATA="$(pg_conftool -s show data_directory)"
trap "cat $PGDATA/*.log || :" EXIT

if [ "${DESTDIR:-}" ]; then
  # assume that pljava-1.2.3.jar is the first file found
  set -- $DESTDIR/usr/share/postgresql/$PGVERSION/pljava/pljava-*.jar
  PLJAR="$1"
  psql -c "ALTER USER $PGUSER SET pljava.classpath = '$PLJAR'"
fi

set -- ${DESTDIR:-}/usr/share/postgresql/$PGVERSION/pljava/pljava-examples-*.jar
EXJAR="$1"

psql -c "CREATE EXTENSION pljava"
psql -c "SELECT sqlj.install_jar('file:$EXJAR', 'examples', true)"
psql -c "SELECT sqlj.set_classpath('javatest', 'examples')"
psql -c "SELECT sqlj.get_classpath('javatest')"
psql -c "SELECT javatest.java_addone(1)"
