/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class Replace
extends MatchingTask {
    private File src = null;
    private NestedString token = null;
    private NestedString value;
    private File dir;

    public void execute() throws BuildException {
        if (this.token == null) {
            throw new BuildException("replace token must not be null", this.location);
        }
        if (this.token.getText().equals("")) {
            throw new BuildException("replace token must not be empty", this.location);
        }
        if (this.src == null && this.dir == null) {
            throw new BuildException("Either the file or the dir attribute must be specified", this.location);
        }
        this.log("Replacing " + this.token.getText() + " --> " + this.value.getText());
        if (this.src != null) {
            this.processFile(this.src);
        }
        if (this.dir != null) {
            DirectoryScanner ds = super.getDirectoryScanner(this.dir);
            String[] srcs = ds.getIncludedFiles();
            int i = 0;
            while (i < srcs.length) {
                File file = new File(this.dir, srcs[i]);
                this.processFile(file);
                ++i;
            }
        }
    }

    private void processFile(File src) throws BuildException {
        if (!src.exists()) {
            throw new BuildException("Replace: source file " + src.getPath() + " doesn't exist", this.location);
        }
        File temp = new File(src.getPath() + ".temp");
        if (temp.exists()) {
            throw new BuildException("Replace: temporary file " + temp.getPath() + " already exists", this.location);
        }
        try {
            boolean changes;
            BufferedReader br = new BufferedReader(new FileReader(src));
            BufferedWriter bw = new BufferedWriter(new FileWriter(temp));
            int fileLength = (int)src.length();
            char[] tmpBuf = new char[fileLength];
            int numread = 0;
            int totread = 0;
            while (numread != -1 && totread < fileLength) {
                numread = br.read(tmpBuf, totread, fileLength);
                totread += numread;
            }
            String buf = new String(tmpBuf);
            String linesep = System.getProperty("line.separator");
            String val = this.stringReplace(this.value.getText(), "\n", linesep);
            String tok = this.stringReplace(this.token.getText(), "\n", linesep);
            String newString = this.stringReplace(buf, tok, val);
            boolean bl = changes = !newString.equals(buf);
            if (changes) {
                bw.write(newString, 0, newString.length());
                bw.flush();
            }
            bw.close();
            br.close();
            if (changes) {
                src.delete();
                temp.renameTo(src);
            } else {
                temp.delete();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new BuildException(ioe, this.location);
        }
    }

    public void setFile(File file) {
        this.src = file;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setToken(String token) {
        this.createReplaceToken().addText(token);
    }

    public void setValue(String value) {
        this.createReplaceValue().addText(value);
    }

    public NestedString createReplaceToken() {
        if (this.token == null) {
            Replace replace = this;
            if (replace == null) {
                throw null;
            }
            this.token = replace.new NestedString();
        }
        return this.token;
    }

    public NestedString createReplaceValue() {
        return this.value;
    }

    private String stringReplace(String str, String str1, String str2) {
        StringBuffer ret = new StringBuffer();
        int start = 0;
        int found = str.indexOf(str1);
        while (found >= 0) {
            if (found > start) {
                ret.append(str.substring(start, found));
            }
            if (str2 != null) {
                ret.append(str2);
            }
            start = found + str1.length();
            found = str.indexOf(str1, start);
        }
        if (str.length() > start) {
            ret.append(str.substring(start, str.length()));
        }
        return ret.toString();
    }

    public Replace() {
        Replace replace = this;
        if (replace == null) {
            throw null;
        }
        this.value = replace.new NestedString();
        this.dir = null;
    }

    public class NestedString {
        private StringBuffer buf = new StringBuffer();

        public void addText(String val) {
            this.buf.append(val);
        }

        public String getText() {
            return this.buf.toString();
        }
    }
}

