/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sound;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.sound.AntSoundPlayer;

public class SoundTask
extends Task {
    private BuildAlert success = null;
    private BuildAlert fail = null;

    public BuildAlert createSuccess() {
        this.success = new BuildAlert();
        return this.success;
    }

    public BuildAlert createFail() {
        this.fail = new BuildAlert();
        return this.fail;
    }

    public void init() {
    }

    public void execute() throws BuildException {
        if (this.success == null && this.fail == null) {
            throw new BuildException("No nested elements provided.");
        }
        AntSoundPlayer soundPlayer = new AntSoundPlayer();
        if (this.success != null) {
            soundPlayer.addBuildSuccesfulSound(this.success.getSource(), this.success.getLoops(), this.success.getDuration());
        }
        if (this.fail != null) {
            soundPlayer.addBuildFailedSound(this.fail.getSource(), this.fail.getLoops(), this.fail.getDuration());
        }
        this.getProject().addBuildListener((BuildListener)soundPlayer);
    }

    public static class BuildAlert {
        private File file = null;
        private int loops = 1;
        private Long duration = null;

        public void setDuration(Long duration) {
            this.duration = duration;
        }

        public void setSource(File file) {
            this.file = file;
        }

        public void setLoops(int loops) {
            this.loops = loops;
        }

        public Long getDuration() {
            return this.duration;
        }

        public File getSource() {
            return this.file;
        }

        public int getLoops() {
            return this.loops;
        }
    }
}

