/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;

public class SummaryJUnitResultFormatter
implements JUnitResultFormatter {
    private NumberFormat nf = NumberFormat.getInstance();
    private OutputStream out;

    public void startTestSuite(JUnitTest suite) {
    }

    public void startTest(Test t) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, Throwable t) {
    }

    public void addError(Test test, Throwable t) {
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTestSuite(JUnitTest suite) throws BuildException {
        StringBuffer sb = new StringBuffer("Tests run: ");
        sb.append(suite.runCount());
        sb.append(", Failures: ");
        sb.append(suite.failureCount());
        sb.append(", Errors: ");
        sb.append(suite.errorCount());
        sb.append(", Time elapsed: ");
        sb.append(this.nf.format((double)suite.getRunTime() / 1000.0));
        sb.append(" sec");
        sb.append(System.getProperty("line.separator"));
        try {
            try {
                this.out.write(sb.toString().getBytes());
                this.out.flush();
            }
            catch (IOException ioex) {
                throw new BuildException("Unable to write summary output", (Throwable)ioex);
            }
            Object var4_3 = null;
            if (this.out == System.out) return;
            if (this.out == System.err) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.out == System.out) throw throwable;
            if (this.out == System.err) throw throwable;
            try {
                this.out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        this.out.close();
        return;
    }
}

