/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.stylebook.BasicEngine;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Engine;
import org.apache.stylebook.InitializationException;
import org.apache.stylebook.Loader;
import org.apache.stylebook.LoadingException;
import org.apache.stylebook.Logger;
import org.apache.stylebook.Project;
import org.apache.stylebook.StreamHandler;
import org.apache.stylebook.URLHandler;

public class StyleBook
implements Logger {
    private URL project = null;
    private Properties properties = new Properties();
    private String propertiesfile = "org/apache/stylebook/data/stylebook.properties";
    private static String error = null;

    public StyleBook(String[] stringArray) throws IOException {
        Object object;
        Object object2;
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this.propertiesfile);
        this.properties.load(inputStream);
        Object object3 = null;
        Object object4 = null;
        int n = 0;
        while (n < stringArray.length) {
            object2 = stringArray[n];
            int n2 = ((String)object2).indexOf(61);
            if (n2 < 0) {
                if (object3 != null) {
                    if (object4 != null) {
                        StyleBook.exit("Duplicate Style (\"" + (String)object4 + "\",\"" + (String)object2 + "\")", 1);
                    } else {
                        object4 = object2;
                    }
                } else {
                    object3 = object2;
                }
            } else {
                object = ((String)object2).substring(0, n2);
                String string = ((String)object2).substring(n2 + 1);
                String string2 = (String)this.properties.setProperty((String)object, string);
                StyleBook.log("Overriding " + (String)object + "=\"" + string + "\" (Old=\"" + string2 + "\")");
            }
            ++n;
        }
        if (object3 == null) {
            StyleBook.exit("Project file non specified", 1);
        }
        if (object4 == null) {
            StyleBook.exit("Style file non specified", 1);
        }
        object2 = new File((String)object3);
        File file = new File((String)object4);
        object = new URLHandler((File)object2, file);
        URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)object);
        this.project = new URL("sbk:/sources/" + ((File)object2).getName());
        StyleBook.log("Project URL: \"" + this.project + "\"");
    }

    private static void exit(Exception exception, int n) {
        StyleBook.log(exception);
        try {
            System.exit(n);
        }
        catch (SecurityException securityException) {}
    }

    private static void exit(String string, int n) {
        StyleBook.log(string);
        try {
            System.exit(n);
        }
        catch (SecurityException securityException) {}
    }

    private Engine getEngine() throws Exception {
        String string = this.properties.getProperty("parserClass");
        URL uRL = new URL(this.properties.getProperty("engineConfig"));
        return new BasicEngine(string, uRL, this);
    }

    private Project getProject(Engine engine) throws Exception {
        Loader loader = new Loader(engine);
        URL uRL = new URL(this.properties.getProperty("loaderConfig"));
        return loader.load(uRL, this.project);
    }

    private static void log(Exception exception) {
        StyleBook.log("Caught " + exception.getClass().getName() + ": " + exception.getMessage());
    }

    public void log(Object object, String string) {
        String string2 = object.getClass().getName();
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        System.out.println("[" + string2 + "] " + string);
    }

    private static void log(String string) {
        System.out.println("[StyleBook] " + string);
    }

    public static void main(String[] stringArray) throws IOException {
        try {
            StyleBook styleBook = new StyleBook(stringArray);
            Engine engine = styleBook.getEngine();
            Project project = styleBook.getProject(engine);
            String string = styleBook.properties.getProperty("targetDirectory");
            StreamHandler streamHandler = new StreamHandler(string);
            Enumeration enumeration = project.getEntryNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                project.create(string2, streamHandler.getOutputStream(string2));
            }
        }
        catch (LoadingException loadingException) {
            StyleBook.log(loadingException);
            StyleBook.exit("Error creating project", 1);
            return;
        }
        catch (InitializationException initializationException) {
            StyleBook.log(initializationException);
            StyleBook.exit("Error creating engine", 1);
            return;
        }
        catch (CreationException creationException) {
            Exception exception = creationException.getException();
            if (exception != null) {
                StyleBook.log(exception);
            }
            StyleBook.exit(creationException, 1);
            return;
        }
        catch (Exception exception) {
            StyleBook.exit(exception, 1);
            return;
        }
        StyleBook.exit("All done successfully", 0);
    }
}

