/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Layout;
import org.apache.log4j.helpers.DateLayout;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class TTCCLayout
extends DateLayout {
    public static final String THREAD_PRINTING_OPTION = "ThreadPrinting";
    public static final String CATEGORY_PREFIXING_OPTION = "CategoryPrefixing";
    public static final String CONTEXT_PRINTING_OPTION = "ContextPrinting";
    private boolean threadPrinting = true;
    private boolean categoryPrefixing = true;
    private boolean contextPrinting = true;
    protected final StringBuffer buf = new StringBuffer(256);

    public TTCCLayout() {
        this.setDateFormat("RELATIVE", null);
    }

    public TTCCLayout(String dateFormatType) {
        this.setDateFormat(dateFormatType);
    }

    public String[] getOptionStrings() {
        return OptionConverter.concatanateArrays(super.getOptionStrings(), new String[]{THREAD_PRINTING_OPTION, CATEGORY_PREFIXING_OPTION, CONTEXT_PRINTING_OPTION});
    }

    public void setOption(String key, String value) {
        super.setOption(key, value);
        if (key.equalsIgnoreCase(THREAD_PRINTING_OPTION)) {
            this.threadPrinting = OptionConverter.toBoolean(value, this.threadPrinting);
        } else if (key.equalsIgnoreCase(CATEGORY_PREFIXING_OPTION)) {
            this.categoryPrefixing = OptionConverter.toBoolean(value, this.categoryPrefixing);
        } else if (key.equalsIgnoreCase(CONTEXT_PRINTING_OPTION)) {
            this.contextPrinting = OptionConverter.toBoolean(value, this.contextPrinting);
        }
    }

    public void setThreadPrinting(boolean threadPrinting) {
        this.threadPrinting = threadPrinting;
    }

    public boolean getThreadPrinting() {
        return this.threadPrinting;
    }

    public void setCategoryPrefixing(boolean categoryPrefixing) {
        this.categoryPrefixing = categoryPrefixing;
    }

    public boolean getCategoryPrefixing() {
        return this.categoryPrefixing;
    }

    public void setContextPrinting(boolean contextPrinting) {
        this.contextPrinting = contextPrinting;
    }

    public boolean getContextPrinting() {
        return this.contextPrinting;
    }

    public String format(LoggingEvent event) {
        String ndc;
        this.buf.setLength(0);
        this.dateFormat(this.buf, event);
        if (this.threadPrinting) {
            this.buf.append('[');
            this.buf.append(event.getThreadName());
            this.buf.append("] ");
        }
        this.buf.append(event.priority.toString());
        this.buf.append(' ');
        if (this.categoryPrefixing) {
            this.buf.append(event.categoryName);
            this.buf.append(' ');
        }
        if (this.contextPrinting && (ndc = event.getNDC()) != null) {
            this.buf.append(ndc);
            this.buf.append(' ');
        }
        this.buf.append("- ");
        this.buf.append(event.getRenderedMessage());
        this.buf.append(Layout.LINE_SEP);
        return this.buf.toString();
    }

    public boolean ignoresThrowable() {
        return true;
    }
}

