/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;

public class PGpath
extends PGobject
implements Serializable,
Cloneable {
    public boolean open;
    public PGpoint[] points;

    public PGpath() {
        this.setType("path");
    }

    public PGpath(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGpath(PGpoint[] points, boolean open) {
        this();
        this.points = points;
        this.open = open;
    }

    public Object clone() {
        PGpoint[] ary = new PGpoint[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            ary[i] = (PGpoint)this.points[i].clone();
            ++i;
        }
        return new PGpath(ary, this.open);
    }

    public void closePath() {
        this.open = false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGpath) {
            PGpath p = (PGpath)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            if (p.open != this.open) {
                return false;
            }
            int i = 0;
            while (i < this.points.length) {
                if (!this.points[i].equals(p.points[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String getValue() {
        StringBuffer b = new StringBuffer(this.open ? "[" : "(");
        int p = 0;
        while (p < this.points.length) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].toString());
            ++p;
        }
        b.append(this.open ? "]" : ")");
        return b.toString();
    }

    public boolean isClosed() {
        return this.open ^ true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void openPath() {
        this.open = true;
    }

    public void setValue(String s) throws SQLException {
        if (s.startsWith("[") && s.endsWith("]")) {
            this.open = true;
            s = PGtokenizer.removeBox(s);
        } else if (s.startsWith("(") && s.endsWith(")")) {
            this.open = false;
            s = PGtokenizer.removePara(s);
        } else {
            throw new PSQLException("postgresql.geo.path");
        }
        PGtokenizer t = new PGtokenizer(s, ',');
        int npoints = t.getSize();
        this.points = new PGpoint[npoints];
        int p = 0;
        while (p < npoints) {
            this.points[p] = new PGpoint(t.getToken(p));
            ++p;
        }
    }
}

