/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Cookie;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionTokensSet;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsTableModel;
import org.zaproxy.zap.session.CookieBasedSessionManagementHelper;
import org.zaproxy.zap.utils.ThreadUtils;

public class HttpSessionsSite {
    private static final Logger LOGGER = LogManager.getLogger(HttpSessionsSite.class);
    private static int lastGeneratedSessionID = 0;
    private ExtensionHttpSessions extension;
    private String site;
    private Set<HttpSession> sessions;
    private HttpSession activeSession;
    private HttpSessionsTableModel model;

    public HttpSessionsSite(ExtensionHttpSessions extension, String site) {
        this.extension = extension;
        this.site = site;
        this.sessions = new LinkedHashSet<HttpSession>();
        this.model = new HttpSessionsTableModel(this);
        this.activeSession = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpSession(HttpSession session) {
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            this.sessions.add(session);
        }
        ThreadUtils.invokeLater(() -> this.model.addHttpSession(session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHttpSession(HttpSession session) {
        if (session == this.activeSession) {
            this.activeSession = null;
        }
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            this.sessions.remove(session);
        }
        ThreadUtils.invokeLater(() -> this.model.removeHttpSession(session));
        session.invalidate();
    }

    public String getSite() {
        return this.site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public HttpSession getActiveSession() {
        return this.activeSession;
    }

    public void setActiveSession(HttpSession activeSession) {
        LOGGER.info("Setting new active session for site '{}': {}", (Object)this.site, (Object)activeSession);
        if (activeSession == null) {
            throw new IllegalArgumentException("When setting an active session, a non-null session has to be provided.");
        }
        if (this.activeSession == activeSession) {
            return;
        }
        if (this.activeSession != null) {
            this.activeSession.setActive(false);
            if (this.activeSession.getTokenValuesCount() == 0) {
                this.removeHttpSession(this.activeSession);
            } else {
                this.model.fireHttpSessionUpdated(this.activeSession);
            }
        }
        this.activeSession = activeSession;
        activeSession.setActive(true);
        this.model.fireHttpSessionUpdated(activeSession);
    }

    public void unsetActiveSession() {
        LOGGER.info("Setting no active session for site '{}'.", (Object)this.site);
        if (this.activeSession != null) {
            this.activeSession.setActive(false);
            if (this.activeSession.getTokenValuesCount() == 0) {
                this.removeHttpSession(this.activeSession);
            } else {
                this.model.fireHttpSessionUpdated(this.activeSession);
            }
            this.activeSession = null;
        }
    }

    private String generateUniqueSessionName() {
        String name;
        while (!this.isSessionNameUnique(name = Constant.messages.getString("httpsessions.session.defaultName", lastGeneratedSessionID++))) {
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSessionNameUnique(String name) {
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            for (HttpSession session : this.sessions) {
                if (!name.equals(session.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private static void validateSessionName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Session name must not be null.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Session name must not be empty.");
        }
    }

    private void createEmptySessionAndSetAsActive(String name) {
        HttpSessionsSite.validateSessionName(name);
        HttpSession session = new HttpSession(name, this.extension.getHttpSessionTokensSet(this.getSite()));
        this.addHttpSession(session);
        this.setActiveSession(session);
    }

    public void createEmptySession(String name) {
        HttpSessionsSite.validateSessionName(name);
        if (!this.isSessionNameUnique(name)) {
            return;
        }
        this.createEmptySessionAndSetAsActive(name);
    }

    public void createEmptySession() {
        this.createEmptySessionAndSetAsActive(this.generateUniqueSessionName());
    }

    public HttpSessionsTableModel getModel() {
        return this.model;
    }

    public void processHttpRequestMessage(HttpMessage message) {
        HttpSessionTokensSet siteTokensSet = this.extension.getHttpSessionTokensSet(this.getSite());
        if (siteTokensSet == null) {
            LOGGER.debug("No session tokens for: {}", (Object)this.getSite());
            return;
        }
        List<HttpCookie> requestCookies = message.getRequestHeader().getHttpCookies();
        HttpSession session = this.getMatchingHttpSession(requestCookies, siteTokensSet);
        LOGGER.debug("Matching session for request message (for site {}): {}", (Object)this.getSite(), (Object)session);
        if (this.activeSession != null && this.activeSession != session) {
            CookieBasedSessionManagementHelper.processMessageToMatchSession(message, requestCookies, this.activeSession);
        } else {
            if (this.activeSession == session) {
                LOGGER.debug("Session of request message is the same as the active session, so no request changes needed.");
            } else {
                LOGGER.debug("No active session is selected.");
            }
            message.setHttpSession(session);
        }
    }

    public void processHttpResponseMessage(HttpMessage message) {
        HttpSessionTokensSet siteTokensSet = this.extension.getHttpSessionTokensSet(this.getSite());
        if (siteTokensSet == null) {
            LOGGER.debug("No session tokens for: {}", (Object)this.getSite());
            return;
        }
        HashMap<String, Cookie> tokenValues = new HashMap<String, Cookie>();
        List<HttpCookie> cookiesToSet = message.getResponseHeader().getHttpCookies(message.getRequestHeader().getHostName());
        for (HttpCookie cookie : cookiesToSet) {
            String lcCookieName = cookie.getName();
            if (!siteTokensSet.isSessionToken(lcCookieName)) continue;
            try {
                long maxAge = cookie.getMaxAge() < -1L ? 0L : cookie.getMaxAge();
                Cookie ck = new Cookie(cookie.getDomain(), lcCookieName, cookie.getValue(), cookie.getPath(), (int)maxAge, cookie.getSecure());
                tokenValues.put(lcCookieName, ck);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Failed to create cookie [{}] for site [{}]: {}", (Object)cookie, (Object)this.getSite(), (Object)e.getMessage());
            }
        }
        List<HttpCookie> requestCookies = message.getRequestHeader().getHttpCookies();
        HttpSession session = message.getHttpSession();
        if (session == null || !session.isValid()) {
            session = this.getMatchingHttpSession(requestCookies, siteTokensSet);
            LOGGER.debug("Matching session for response message (from site {}): {}", (Object)this.getSite(), (Object)session);
        } else {
            LOGGER.debug("Matching cached session for response message (from site {}): {}", (Object)this.getSite(), (Object)session);
        }
        boolean newSession = false;
        if (session == null) {
            session = new HttpSession(this.generateUniqueSessionName(), this.extension.getHttpSessionTokensSet(this.getSite()));
            this.addHttpSession(session);
            for (HttpCookie cookie : requestCookies) {
                String path;
                String cookieName = cookie.getName();
                if (!siteTokensSet.isSessionToken(cookieName) || tokenValues.containsKey(cookieName)) continue;
                String domain = cookie.getDomain();
                if (domain == null) {
                    domain = message.getRequestHeader().getHostName();
                }
                if ((path = cookie.getPath()) == null) {
                    path = "/";
                }
                Cookie ck = new Cookie(domain, cookieName, cookie.getValue(), path, (int)cookie.getMaxAge(), cookie.getSecure());
                tokenValues.put(cookieName, ck);
            }
            newSession = true;
        }
        if (!tokenValues.isEmpty()) {
            for (Map.Entry tv : tokenValues.entrySet()) {
                session.setTokenValue((String)tv.getKey(), (Cookie)tv.getValue());
            }
        }
        if (newSession) {
            LOGGER.debug("Created a new session as no match was found: {}", (Object)session);
        }
        session.setMessagesMatched(session.getMessagesMatched() + 1);
        this.model.fireHttpSessionUpdated(session);
        message.setHttpSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpSession getMatchingHttpSession(List<HttpCookie> cookies, HttpSessionTokensSet siteTokens) {
        ArrayList<HttpSession> sessionsCopy;
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            sessionsCopy = new ArrayList<HttpSession>(this.sessions);
        }
        return CookieBasedSessionManagementHelper.getMatchingHttpSession(sessionsCopy, cookies, siteTokens);
    }

    public String toString() {
        return "HttpSessionsSite [site=" + this.site + ", activeSession=" + this.activeSession + ", sessions=" + this.sessions + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupSessionToken(String token) {
        if (this.sessions.isEmpty()) {
            return;
        }
        LOGGER.debug("Removing duplicates and cleaning up sessions for site - token: {} - {}", (Object)this.site, (Object)token);
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            HttpSessionTokensSet siteTokensSet = this.extension.getHttpSessionTokensSet(this.site);
            if (siteTokensSet == null) {
                LOGGER.info("No more session tokens. Removing all sessions...");
                for (HttpSession session : this.sessions) {
                    session.invalidate();
                }
                this.sessions.clear();
                this.activeSession = null;
                ThreadUtils.invokeLater(() -> this.model.removeAllElements());
                return;
            }
            HashMap<String, HttpSession> uniqueSession = new HashMap<String, HttpSession>(this.sessions.size());
            LinkedList<HttpSession> toDelete = new LinkedList<HttpSession>();
            for (HttpSession session : this.sessions) {
                session.removeToken(token);
                if (session.getTokenValuesCount() == 0 && !session.isActive()) {
                    toDelete.add(session);
                    continue;
                }
                this.model.fireHttpSessionUpdated(session);
                if (uniqueSession.containsKey(session.getTokenValuesString())) {
                    HttpSession prevSession = (HttpSession)uniqueSession.get(session.getTokenValuesString());
                    if (session.isActive()) {
                        toDelete.add(prevSession);
                        session.setMessagesMatched(session.getMessagesMatched() + prevSession.getMessagesMatched());
                        continue;
                    }
                    toDelete.add(session);
                    prevSession.setMessagesMatched(session.getMessagesMatched() + prevSession.getMessagesMatched());
                    continue;
                }
                uniqueSession.put(session.getTokenValuesString(), session);
            }
            LOGGER.info("Removing duplicate or empty sessions: {}", toDelete);
            for (HttpSession ses : toDelete) {
                ses.invalidate();
                this.sessions.remove(ses);
                ThreadUtils.invokeLater(() -> this.model.removeHttpSession(ses));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<HttpSession> getHttpSessions() {
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            return Collections.unmodifiableSet(this.sessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getHttpSession(String name) {
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            for (HttpSession session : this.sessions) {
                if (!session.getName().equals(name)) continue;
                return session;
            }
        }
        return null;
    }

    public boolean renameHttpSession(String oldName, String newName) {
        if (newName == null || newName.isEmpty()) {
            LOGGER.warn("Trying to rename session from {} illegal name: {}", (Object)oldName, (Object)newName);
            return false;
        }
        HttpSession session = this.getHttpSession(oldName);
        if (session == null) {
            return false;
        }
        if (this.getHttpSession(newName) != null) {
            LOGGER.warn("Trying to rename session from {} to already existing: {}", (Object)oldName, (Object)newName);
            return false;
        }
        session.setName(newName);
        this.model.fireHttpSessionUpdated(session);
        return true;
    }

    static void resetLastGeneratedSessionId() {
        lastGeneratedSessionID = 0;
    }

    public static int getNextSessionId() {
        return lastGeneratedSessionID++;
    }
}

