/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.httpclient.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.RecordTag;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.db.TableTag;
import org.parosproxy.paros.model.HistoryReferenceEventPublisher;
import org.parosproxy.paros.model.HttpMessageCachedData;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.model.Target;

public class HistoryReference {
    public static final int TYPE_TEMPORARY = 0;
    @Deprecated
    public static final int TYPE_MANUAL = 1;
    public static final int TYPE_PROXIED = 1;
    public static final int TYPE_ZAP_USER = 15;
    public static final int TYPE_SPIDER = 2;
    public static final int TYPE_SCANNER = 3;
    public static final int TYPE_HIDDEN = 6;
    public static final int TYPE_BRUTE_FORCE = 7;
    public static final int TYPE_FUZZER = 8;
    public static final int TYPE_SPIDER_TASK = 9;
    public static final int TYPE_SPIDER_AJAX = 10;
    public static final int TYPE_AUTHENTICATION = 11;
    public static final int TYPE_ACCESS_CONTROL = 13;
    public static final int TYPE_ZEST_SCRIPT = 12;
    public static final int TYPE_SCANNER_TEMPORARY = 14;
    private static final Set<Integer> TEMPORARY_HISTORY_TYPES = new HashSet<Integer>();
    public static final Set<Integer> DEFAULT_TEMPORARY_HISTORY_TYPES;
    public static final int TYPE_PROXY_CONNECT = 16;
    public static final int TYPE_SEQUENCE_TEMPORARY = 17;
    public static final int TYPE_SPIDER_AJAX_TEMPORARY = 18;
    public static final int TYPE_SPIDER_TEMPORARY = 19;
    public static final int TYPE_FUZZER_TEMPORARY = 20;
    public static final int TYPE_CALLBACK = 21;
    public static final int TYPE_OAST = 22;
    public static final int TYPE_PARAM_DIGGER = 23;
    private static DecimalFormat decimalFormat;
    private static TableHistory staticTableHistory;
    private static TableTag staticTableTag;
    private static TableAlert staticTableAlert;
    private int historyId = 0;
    private int historyType = 1;
    private SiteNode siteNode = null;
    private String display = null;
    private long sessionId = 0L;
    private ArrayList<String> icons = null;
    private ArrayList<Boolean> clearIfManual = null;
    private Set<Alert> alerts;
    private List<String> tags = new ArrayList<String>();
    private boolean webSocketUpgrade;
    private static final Logger LOGGER;
    private HttpMessage httpMessage;
    private HttpMessageCachedData httpMessageCachedData;

    public long getSessionId() {
        return this.sessionId;
    }

    public HistoryReference(int historyId) throws HttpMalformedHeaderException, DatabaseException {
        this(historyId, false);
    }

    public HistoryReference(int historyId, boolean keepMessage) throws HttpMalformedHeaderException, DatabaseException {
        RecordHistory history = null;
        this.icons = new ArrayList();
        this.clearIfManual = new ArrayList();
        history = staticTableHistory.read(historyId);
        if (history == null) {
            throw new HttpMalformedHeaderException();
        }
        HttpMessage msg = history.getHttpMessage();
        this.tags = HistoryReference.getTags(historyId);
        this.build(history.getSessionId(), history.getHistoryId(), history.getHistoryType(), msg);
        if (keepMessage) {
            this.httpMessage = msg;
        }
    }

    public HistoryReference(Session session, int historyType, HttpMessage msg) throws HttpMalformedHeaderException, DatabaseException {
        RecordHistory history = null;
        this.icons = new ArrayList();
        this.clearIfManual = new ArrayList();
        history = staticTableHistory.write(session.getSessionId(), historyType, msg);
        this.build(session.getSessionId(), history.getHistoryId(), history.getHistoryType(), msg);
        msg.setHistoryRef(this);
        this.tags = HistoryReference.getTags(this.historyId);
        List<RecordAlert> alerts = staticTableAlert.getAlertsBySourceHistoryId(this.historyId);
        for (RecordAlert alert : alerts) {
            this.addAlert(new Alert(alert, this));
        }
    }

    public ArrayList<Boolean> getClearIfManual() {
        return this.clearIfManual;
    }

    public ArrayList<String> getCustomIcons() {
        return this.icons;
    }

    public void setCustomIcon(String i, boolean c) {
        this.icons.add(i);
        this.clearIfManual.add(c);
    }

    private void build(long sessionId, int historyId, int historyType, HttpMessage msg) {
        this.sessionId = sessionId;
        this.historyId = historyId;
        this.historyType = historyType;
        this.webSocketUpgrade = msg.isWebSocketUpgrade();
        if (historyType == 1 || historyType == 15) {
            this.display = this.getDisplay(msg);
        }
        msg.setHistoryRef(this);
        this.httpMessageCachedData = new HttpMessageCachedData(msg);
    }

    public static void setTableHistory(TableHistory tableHistory) {
        staticTableHistory = tableHistory;
    }

    public static void setTableTag(TableTag tableTag) {
        staticTableTag = tableTag;
    }

    public static void setTableAlert(TableAlert tableAlert) {
        staticTableAlert = tableAlert;
    }

    public int getHistoryId() {
        return this.historyId;
    }

    public HttpMessage getHttpMessage() throws HttpMalformedHeaderException, DatabaseException {
        if (this.httpMessage != null) {
            return this.httpMessage;
        }
        RecordHistory history = staticTableHistory.read(this.historyId);
        if (history == null) {
            throw new HttpMalformedHeaderException("No history reference for id " + this.historyId + " type=" + this.historyType);
        }
        history.getHttpMessage().setHistoryRef(this);
        return history.getHttpMessage();
    }

    public void clearHttpMessage() {
        this.httpMessage = null;
    }

    public URI getURI() {
        return this.httpMessageCachedData.getUri();
    }

    public String toString() {
        if (this.display != null) {
            return this.display;
        }
        HttpMessage msg = null;
        try {
            msg = this.getHttpMessage();
            this.display = this.getDisplay(msg);
        }
        catch (DatabaseException | HttpMalformedHeaderException e1) {
            this.display = "";
        }
        return this.display;
    }

    public int getHistoryType() {
        return this.historyType;
    }

    public void delete() {
        if (this.historyId > 0) {
            try {
                staticTableTag.deleteTagsForHistoryID(this.historyId);
                staticTableHistory.delete(this.historyId);
                this.notifyEvent("href.removed");
            }
            catch (DatabaseException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public SiteNode getSiteNode() {
        return this.siteNode;
    }

    public void setSiteNode(SiteNode siteNode) {
        this.siteNode = siteNode;
    }

    private String getDisplay(HttpMessage msg) {
        StringBuilder sb = new StringBuilder(Integer.toString(this.historyId));
        sb.append(' ');
        sb.append(msg.getRequestHeader().getPrimeHeader());
        if (!msg.getResponseHeader().isEmpty()) {
            sb.append(" \t=> ").append(msg.getResponseHeader().getPrimeHeader());
            sb.append("\t [").append(decimalFormat.format((double)msg.getTimeElapsedMillis() / 1000.0)).append(" s]");
        }
        return sb.toString();
    }

    public void addTag(String tag) {
        if (this.insertTagDb(tag)) {
            this.tags.add(tag);
            this.notifyEvent("href.tag.added");
        }
    }

    private boolean insertTagDb(String tag) {
        try {
            staticTableTag.insert(this.historyId, tag);
            return true;
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to persist tag: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private void notifyEvent(String event) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("historyReferenceId", Integer.toString(this.historyId));
        ZAP.getEventBus().publishSyncEvent(HistoryReferenceEventPublisher.getPublisher(), new Event(HistoryReferenceEventPublisher.getPublisher(), event, new Target(this.getSiteNode()), map));
    }

    public void deleteTag(String tag) {
        if (this.deleteTagDb(tag)) {
            this.tags.remove(tag);
            this.notifyEvent("href.tag.removed");
        }
    }

    private boolean deleteTagDb(String tag) {
        try {
            staticTableTag.delete(this.historyId, tag);
            return true;
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to delete tag: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setNote(String note) {
        try {
            staticTableHistory.updateNote(this.historyId, note);
            this.httpMessageCachedData.setNote(note != null && note.length() > 0);
            this.notifyEvent("href.note.set");
        }
        catch (DatabaseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void loadAlerts() {
        try {
            List<RecordAlert> alerts = staticTableAlert.getAlertsBySourceHistoryId(this.historyId);
            for (RecordAlert alert : alerts) {
                this.addAlert(new Alert(alert, this));
            }
        }
        catch (DatabaseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized boolean addAlert(Alert alert) {
        if (this.alerts == null) {
            this.alerts = new HashSet<Alert>();
        }
        boolean added = false;
        if (this.alerts.add(alert)) {
            alert.setHistoryRef(this);
            added = true;
        }
        if (this.siteNode != null) {
            this.siteNode.addAlert(alert);
        }
        return added;
    }

    public synchronized void updateAlert(Alert alert) {
        if (this.alerts == null) {
            return;
        }
        for (Alert a : this.alerts) {
            if (a.getAlertId() != alert.getAlertId()) continue;
            this.alerts.remove(a);
            this.alerts.add(alert);
            if (this.siteNode != null) {
                this.siteNode.updateAlert(alert);
            }
            return;
        }
    }

    public synchronized void deleteAlert(Alert alert) {
        if (this.alerts != null) {
            this.alerts.remove(alert);
            if (this.siteNode != null) {
                this.siteNode.deleteAlert(alert);
            }
        }
    }

    public synchronized void deleteAllAlerts() {
        if (this.alerts != null) {
            this.alerts.clear();
        }
    }

    public synchronized boolean hasAlert(Alert alert) {
        if (this.alerts == null) {
            return false;
        }
        return this.alerts.contains(alert);
    }

    public synchronized boolean hasAlerts() {
        if (this.alerts == null) {
            return false;
        }
        return !this.alerts.isEmpty();
    }

    public int getHighestAlert() {
        int i = -1;
        if (this.alerts == null) {
            return i;
        }
        for (Alert a : this.alerts) {
            if (a.getConfidence() == 0 || a.getRisk() <= i) continue;
            i = a.getRisk();
        }
        return i;
    }

    public synchronized List<Alert> getAlerts() {
        if (this.alerts == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Alert>(this.alerts);
    }

    public String getMethod() {
        return this.httpMessageCachedData.getMethod();
    }

    public int getStatusCode() {
        return this.httpMessageCachedData.getStatusCode();
    }

    public String getReason() {
        return this.httpMessageCachedData.getReason();
    }

    public int getRtt() {
        return this.httpMessageCachedData.getRtt();
    }

    public void setTags(List<String> tags) {
        if (tags == null) {
            throw new IllegalArgumentException("Parameter tags must not be null.");
        }
        for (String tag : tags) {
            if (this.tags.contains(tag)) continue;
            this.insertTagDb(tag);
        }
        for (String tag : this.tags) {
            if (tags.contains(tag)) continue;
            this.deleteTagDb(tag);
        }
        this.tags = new ArrayList<String>(tags);
        this.notifyEvent("href.tags.set");
    }

    @Deprecated
    public void setTags(Vector<String> tags) {
        this.setTags((List<String>)tags);
    }

    public boolean hasNote() {
        return this.httpMessageCachedData.hasNote();
    }

    public long getTimeSentMillis() {
        return this.httpMessageCachedData.getTimeSentMillis();
    }

    public long getTimeReceivedMillis() {
        return this.httpMessageCachedData.getTimeReceivedMillis();
    }

    public boolean isWebSocketUpgrade() {
        return this.webSocketUpgrade;
    }

    public int getRequestHeaderLength() {
        return this.httpMessageCachedData.getRequestHeaderLength();
    }

    public int getRequestBodyLength() {
        return this.httpMessageCachedData.getRequestBodyLength();
    }

    public int getResponseHeaderLength() {
        return this.httpMessageCachedData.getResponseHeaderLength();
    }

    public int getResponseBodyLength() {
        return this.httpMessageCachedData.getResponseBodyLength();
    }

    public String getRequestBody() {
        String requestBody = this.httpMessageCachedData.getRequestBody();
        if (requestBody == null) {
            try {
                requestBody = this.getHttpMessage().getRequestBody().toString();
                this.httpMessageCachedData.setRequestBody(requestBody);
            }
            catch (DatabaseException | HttpMalformedHeaderException e) {
                LOGGER.error("Failed to reload request body from database with history ID: {}", (Object)this.historyId, (Object)e);
                requestBody = "";
            }
        }
        return requestBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTemporaryType(int type) {
        Set<Integer> set = TEMPORARY_HISTORY_TYPES;
        synchronized (set) {
            TEMPORARY_HISTORY_TYPES.add(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTemporaryType(int type) {
        Integer typeInteger = type;
        if (DEFAULT_TEMPORARY_HISTORY_TYPES.contains(typeInteger)) {
            return;
        }
        Set<Integer> set = TEMPORARY_HISTORY_TYPES;
        synchronized (set) {
            TEMPORARY_HISTORY_TYPES.remove(typeInteger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Integer> getTemporaryTypes() {
        Set<Integer> set = TEMPORARY_HISTORY_TYPES;
        synchronized (set) {
            return new HashSet<Integer>(TEMPORARY_HISTORY_TYPES);
        }
    }

    public static List<String> getTags(int historyId) throws DatabaseException {
        if (staticTableTag == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> tags = new ArrayList<String>();
        List<RecordTag> rtags = staticTableTag.getTagsForHistoryID(historyId);
        for (RecordTag rtag : rtags) {
            tags.add(rtag.getTag());
        }
        return tags;
    }

    static {
        decimalFormat = new DecimalFormat("##0.###");
        staticTableHistory = null;
        staticTableTag = null;
        staticTableAlert = null;
        HashSet<Integer> defaultHistoryTypes = new HashSet<Integer>();
        defaultHistoryTypes.add(0);
        defaultHistoryTypes.add(14);
        defaultHistoryTypes.add(11);
        defaultHistoryTypes.add(9);
        defaultHistoryTypes.add(17);
        defaultHistoryTypes.add(18);
        defaultHistoryTypes.add(19);
        defaultHistoryTypes.add(20);
        DEFAULT_TEMPORARY_HISTORY_TYPES = Collections.unmodifiableSet(defaultHistoryTypes);
        TEMPORARY_HISTORY_TYPES.addAll(DEFAULT_TEMPORARY_HISTORY_TYPES);
        LOGGER = LogManager.getLogger(HistoryReference.class);
    }
}

