/* 
   Unix SMB/CIFS implementation.
   ioctl and fsctl definitions
   
   Copyright (C) Andrew Tridgell              2003
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


/* ioctl codes */
#define IOCTL_QUERY_JOB_INFO      0x530060


/* filesystem control codes */
#define FSCTL_METHOD_BUFFERED	0x00000000
#define FSCTL_METHOD_IN_DIRECT	0x00000001
#define FSCTL_METHOD_OUT_DIRECT	0x00000002
#define FSCTL_METHOD_NEITHER	0x00000003

#define FSCTL_ACCESS_ANY	0x00000000
#define FSCTL_ACCESS_READ	0x00004000
#define FSCTL_ACCESS_WRITE	0x00008000

#define FSCTL_FILESYSTEM		0x00090000
#define FSCTL_REQUEST_OPLOCK_LEVEL_1    (FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0000 | FSCTL_METHOD_BUFFERED)
#define FSCTL_REQUEST_OPLOCK_LEVEL_2    (FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0004 | FSCTL_METHOD_BUFFERED)
#define FSCTL_REQUEST_BATCH_OPLOCK      (FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0008 | FSCTL_METHOD_BUFFERED)
#define FSCTL_OPLOCK_BREAK_ACKNOWLEDGE  (FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x000C | FSCTL_METHOD_BUFFERED)
#define FSCTL_OPBATCH_ACK_CLOSE_PENDING (FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0010 | FSCTL_METHOD_BUFFERED)
#define FSCTL_OPLOCK_BREAK_NOTIFY       (FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0014 | FSCTL_METHOD_BUFFERED)
#define FSCTL_FILESYS_GET_STATISTICS	(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0060 | FSCTL_METHOD_BUFFERED)
#define FSCTL_GET_NTFS_VOLUME_DATA	(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0064 | FSCTL_METHOD_BUFFERED)
#define FSCTL_FIND_FILES_BY_SID		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x008C | FSCTL_METHOD_NEITHER)
#define FSCTL_SET_OBJECT_ID		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0098 | FSCTL_METHOD_BUFFERED)
#define FSCTL_GET_OBJECT_ID		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x009C | FSCTL_METHOD_BUFFERED)
#define FSCTL_DELETE_OBJECT_ID		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x00A0 | FSCTL_METHOD_BUFFERED)
#define FSCTL_SET_REPARSE_POINT		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x00A4 | FSCTL_METHOD_BUFFERED)
#define FSCTL_GET_REPARSE_POINT		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x00A8 | FSCTL_METHOD_BUFFERED)
#define FSCTL_DELETE_REPARSE_POINT	(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x00AC | FSCTL_METHOD_BUFFERED)
#define FSCTL_CREATE_OR_GET_OBJECT_ID	(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x00C0 | FSCTL_METHOD_BUFFERED)
#define FSCTL_SET_SPARSE		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x00C4 | FSCTL_METHOD_BUFFERED)

#define FSCTL_NAMED_PIPE		0x00110000
#define FSCTL_NAMED_PIPE_READ_WRITE	(FSCTL_NAMED_PIPE | FSCTL_ACCESS_ANY | 0xC014 | FSCTL_METHOD_NEITHER)

#define FSCTL_NETWORK_FILESYSTEM	0x00140000
#define FSCTL_GET_SHADOW_COPY_DATA	(FSCTL_NETWORK_FILESYSTEM | FSCTL_ACCESS_READ | 0x0064 | FSCTL_METHOD_BUFFERED)
