/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.catacombae.io.InputStreamReadable;
import org.catacombae.io.OutputStreamWritable;
import org.catacombae.io.Readable;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.io.Writable;

public class IOUtil
extends org.catacombae.util.IOUtil {
    public static long streamCopy(InputStream is, OutputStream os, int bufferSize) throws IOException {
        try {
            return IOUtil.streamCopy((Readable)new InputStreamReadable(is), (Writable)new OutputStreamWritable(os), bufferSize);
        }
        catch (RuntimeIOException e) {
            IOException cause = e.getIOCause();
            if (cause != null) {
                throw cause;
            }
            throw e;
        }
    }

    public static long streamCopy(Readable is, OutputStream os, int bufferSize) throws IOException {
        try {
            return IOUtil.streamCopy(is, (Writable)new OutputStreamWritable(os), bufferSize);
        }
        catch (RuntimeIOException e) {
            IOException cause = e.getIOCause();
            if (cause != null) {
                throw cause;
            }
            throw e;
        }
    }

    public static long streamCopy(InputStream is, Writable os, int bufferSize) throws IOException {
        try {
            return IOUtil.streamCopy((Readable)new InputStreamReadable(is), os, bufferSize);
        }
        catch (RuntimeIOException e) {
            IOException cause = e.getIOCause();
            if (cause != null) {
                throw cause;
            }
            throw e;
        }
    }

    public static long streamCopy(Readable is, Writable os, int bufferSize) throws RuntimeIOException {
        int bytesRead;
        byte[] buffer = new byte[bufferSize];
        long totalBytesCopied = 0L;
        while ((bytesRead = is.read(buffer)) > 0) {
            os.write(buffer, 0, bytesRead);
            totalBytesCopied += (long)bytesRead;
        }
        return totalBytesCopied;
    }
}

