% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bonds.R
\name{get.bond.order}
\alias{get.bond.order}
\title{Get an object representing bond order}
\usage{
get.bond.order(order = "single")
}
\arguments{
\item{order}{A character vector that can be one of single, double, triple,
quadruple, quintuple, sextuple or unset. Case is ignored}
}
\value{
A \code{jObjRef} representing an `Order` enum object
}
\description{
This function returns a Java enum representing a
bond order. This can be used to modify the order
of pre-existing bonds
}
\examples{
\dontrun{
m <- parse.smiles('CCN')[[1]]
b <- get.bonds(m)[[1]]
b$setOrder(get.bond.order("double"))
}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
