% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_zmq_context.r
\name{Context Functions}
\alias{Context Functions}
\alias{zmq.ctx.new}
\alias{zmq.ctx.destroy}
\title{Context Functions}
\usage{
zmq.ctx.new()

zmq.ctx.destroy(ctx)
}
\arguments{
\item{ctx}{a ZMQ context}
}
\value{
\code{zmq.ctx.new()} returns an R external pointer (\code{ctx})
generated by ZMQ C API pointing to a context if successful, otherwise
returns an R \code{NULL}.

\code{zmq.ctx.destroy()} returns 0 if successful, otherwise returns -1 and
sets \code{errno} to either \code{EFAULT} or \code{EINTR}.
}
\description{
Context functions
}
\details{
\code{zmq.ctx.new()} initializes a ZMQ context for starting communication.

\code{zmq.ctx.destroy()} terminates the context for stopping communication.
}
\examples{
\dontrun{
library(pbdZMQ, quietly = TRUE)

context <- zmq.ctx.new()
zmq.ctx.destroy(context)
}

}
\references{
ZeroMQ/4.1.0 API Reference:
\url{https://libzmq.readthedocs.io/en/zeromq4-1/}

Programming with Big Data in R Website: \url{https://pbdr.org/}
}
\seealso{
\code{\link{zmq.socket}()}, \code{\link{zmq.close}()},
\code{\link{zmq.bind}()}, \code{\link{zmq.connect}()}.
}
\author{
Wei-Chen Chen \email{wccsnow@gmail.com}.
}
\keyword{programming}
