% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors-day.r
\name{day}
\alias{day}
\alias{mday}
\alias{wday}
\alias{qday}
\alias{yday}
\alias{day<-}
\alias{mday<-}
\alias{qday<-}
\alias{wday<-}
\alias{yday<-}
\title{Get/set days component of a date-time}
\usage{
day(x)

mday(x)

wday(
  x,
  label = FALSE,
  abbr = TRUE,
  week_start = getOption("lubridate.week.start", 7),
  locale = Sys.getlocale("LC_TIME")
)

qday(x)

yday(x)

day(x) <- value

mday(x) <- value

qday(x) <- value

qday(x) <- value

wday(x, week_start = getOption("lubridate.week.start", 7)) <- value

yday(x) <- value
}
\arguments{
\item{x}{a POSIXct, POSIXlt, Date, chron, yearmon, yearqtr, zoo, zooreg, timeDate,
xts, its, ti, jul, timeSeries, or fts object.}

\item{label}{logical. Only available for wday. TRUE will display the day of the week
as an ordered factor of character strings, such as "Sunday." FALSE will display the
day of the week as a number.}

\item{abbr}{logical. Only available for wday. FALSE will display the day of the week
as an ordered factor of character strings, such as "Sunday." TRUE will display an
abbreviated version of the label, such as "Sun". abbr is disregarded if label =
FALSE.}

\item{week_start}{day on which week starts following ISO conventions: 1 means Monday
and 7 means Sunday (default). When \code{label = FALSE} and \code{week_start = 7}, the number
returned for Sunday is 1, for Monday is 2, etc. When \code{label = TRUE}, the returned
value is a factor with the first level being the week start (e.g. Sunday if
\code{week_start = 7}). You can set \code{lubridate.week.start} option to control this
parameter globally.}

\item{locale}{locale to use for day names. Default to current locale.}

\item{value}{(for \verb{wday<-}) a numeric or a string giving the name of the day in the
current locale or in English. Can be abbreviated. When a string, the value of
\code{week_start} is ignored.}
}
\value{
\code{wday()} returns the day of the week as a decimal number or an ordered factor
if label is \code{TRUE}.
}
\description{
Get/set days component of a date-time
}
\details{
\code{mday()} and \code{yday()} return the day of the month and day of the year
respectively. \code{day()} and \verb{day<-()} are aliases for \code{mday()} and \verb{mday<-()}.
}
\examples{
x <- as.Date("2009-09-02")
wday(x) # 4
wday(x, label = TRUE) # Wed

wday(x, week_start = 1) # 3
wday(x, week_start = 7) # 4

wday(x, label = TRUE, week_start = 7) # Wed (Sun is the first level)
wday(x, label = TRUE, week_start = 1) # Wed (Mon is the first level)

wday(ymd(080101))
wday(ymd(080101), label = TRUE, abbr = FALSE)
wday(ymd(080101), label = TRUE, abbr = TRUE)
wday(ymd(080101) + days(-2:4), label = TRUE, abbr = TRUE)

x <- as.Date("2009-09-02")
yday(x) # 245
mday(x) # 2
yday(x) <- 1 # "2009-01-01"
yday(x) <- 366 # "2010-01-01"
mday(x) > 3
}
\keyword{chron}
\keyword{manip}
\keyword{methods}
\keyword{utilities}
