% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-not-subset.R, R/chk-subset.R
\name{vld_not_subset}
\alias{vld_not_subset}
\alias{chk_subset}
\alias{vld_subset}
\title{Check Subset}
\usage{
vld_not_subset(x, values)

chk_subset(x, values, x_name = NULL)

vld_subset(x, values)
}
\arguments{
\item{x}{The object to check.}

\item{values}{A vector of the permitted values.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if all values in values using

\code{all(x \%in\% values)}

Pay attention to the order of the arguments \code{value} and \code{x}
in this function compared to \code{\link[=chk_superset]{chk_superset()}}
}
\section{Functions}{
\itemize{
\item \code{vld_not_subset()}: Validate Not Subset

\item \code{vld_subset()}: Validate Subset

}}
\examples{
# vld_not_subset
vld_not_subset(numeric(0), 1:10)
vld_not_subset(1, 1:10)
vld_not_subset(11, 1:10)
# chk_subset
chk_subset(1, 1:10)
try(chk_subset(11, 1:10))
# vld_subset
vld_subset(numeric(0), 1:10)
vld_subset(1, 1:10)
vld_subset(11, 1:10)
}
\seealso{
\code{\link[=all]{all()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other set_checkers: 
\code{\link{chk_not_subset}()},
\code{\link{chk_orderset}()},
\code{\link{chk_superset}()},
\code{\link{vld_orderset}()}
}
\concept{set_checkers}
