<?php

namespace Sabre\HTTP;

require_once 'Sabre/HTTP/ResponseMock.php';

class ResponseTest extends \PHPUnit_Framework_TestCase {

    /**
     * @var Sabre\HTTP\ResponseMock
     */
    private $response;

    function setUp() {

        $this->response = new ResponseMock();

    }

    function testGetStatusMessage() {

        $msg = $this->response->getStatusMessage(200);
        $this->assertEquals('HTTP/1.1 200 OK',$msg);

    }

    function testSetHeader() {

        $this->response->setHeader('Content-Type','text/html');
        $this->assertEquals('text/html', $this->response->headers['Content-Type']);


    }
    function testSetHeaders() {

        $this->response->setHeaders(array('Content-Type'=>'text/html'));
        $this->assertEquals('text/html', $this->response->headers['Content-Type']);


    }

    function testSendStatus() {

        $this->response->sendStatus(404);
        $this->assertEquals('HTTP/1.1 404 Not Found', $this->response->status);

    }

    function testSendBody() {

        ob_start();
        $response = new Response();
        $response->sendBody('hello');
        $this->assertEquals('hello',ob_get_clean());

    }

    function testSendBodyStream() {

        ob_start();
        $stream = fopen('php://memory','r+');
        fwrite($stream,'hello');
        rewind($stream);
        $response = new Response();
        $response->sendBody($stream);
        $this->assertEquals('hello',ob_get_clean());

    }

}
