<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Kumaraswamy

> Kumaraswamy's double bounded distribution.

<section class="usage">

## Usage

```javascript
var kumaraswamy = require( '@stdlib/stats/base/dists/kumaraswamy' );
```

#### kumaraswamy

Kumaraswamy's double bounded distribution.

```javascript
var dist = kumaraswamy;
// returns {...}
```

The namespace contains the following distribution functions:

<!-- <toc pattern="*+(cdf|pdf|mgf|quantile)*"> -->

<div class="namespace-toc">

-   <span class="signature">[`cdf( x, a, b )`][@stdlib/stats/base/dists/kumaraswamy/cdf]</span><span class="delimiter">: </span><span class="description">Kumaraswamy's double bounded distribution cumulative distribution function.</span>
-   <span class="signature">[`logcdf( x, a, b )`][@stdlib/stats/base/dists/kumaraswamy/logcdf]</span><span class="delimiter">: </span><span class="description">evaluate the natural logarithm of the cumulative distribution function for a Kumaraswamy's double bounded distribution.</span>
-   <span class="signature">[`logpdf( x, a, b )`][@stdlib/stats/base/dists/kumaraswamy/logpdf]</span><span class="delimiter">: </span><span class="description">evaluate the natural logarithm of the probability density function for a Kumaraswamy's double bounded distribution.</span>
-   <span class="signature">[`pdf( x, a, b )`][@stdlib/stats/base/dists/kumaraswamy/pdf]</span><span class="delimiter">: </span><span class="description">Kumaraswamy's double bounded distribution probability density function.</span>
-   <span class="signature">[`quantile( p, a, b )`][@stdlib/stats/base/dists/kumaraswamy/quantile]</span><span class="delimiter">: </span><span class="description">Kumaraswamy's double bounded distribution quantile function.</span>

</div>

<!-- </toc> -->

The namespace contains the following functions for calculating distribution properties:

<!-- <toc pattern="*+(entropy|kurtosis|mean|median|mode|skewness|stdev|variance)*"> -->

<div class="namespace-toc">

-   <span class="signature">[`kurtosis( a, b )`][@stdlib/stats/base/dists/kumaraswamy/kurtosis]</span><span class="delimiter">: </span><span class="description">Kumaraswamy's double bounded distribution excess kurtosis.</span>
-   <span class="signature">[`mean( a, b )`][@stdlib/stats/base/dists/kumaraswamy/mean]</span><span class="delimiter">: </span><span class="description">Kumaraswamy's double bounded distribution expected value.</span>
-   <span class="signature">[`median( a, b )`][@stdlib/stats/base/dists/kumaraswamy/median]</span><span class="delimiter">: </span><span class="description">Kumaraswamy's double bounded distribution median.</span>
-   <span class="signature">[`mode( a, b )`][@stdlib/stats/base/dists/kumaraswamy/mode]</span><span class="delimiter">: </span><span class="description">Kumaraswamy's double bounded distribution mode.</span>
-   <span class="signature">[`skewness( a, b )`][@stdlib/stats/base/dists/kumaraswamy/skewness]</span><span class="delimiter">: </span><span class="description">Kumaraswamy's double bounded distribution skewness.</span>
-   <span class="signature">[`stdev( a, b )`][@stdlib/stats/base/dists/kumaraswamy/stdev]</span><span class="delimiter">: </span><span class="description">Kumaraswamy's double bounded distribution standard deviation.</span>
-   <span class="signature">[`variance( a, b )`][@stdlib/stats/base/dists/kumaraswamy/variance]</span><span class="delimiter">: </span><span class="description">Kumaraswamy's double bounded distribution variance.</span>

</div>

<!-- </toc> -->

The namespace contains a constructor function for creating a [Kumaraswamy's double bounded][kumaraswamy-distribution] distribution object.

<!-- <toc pattern="*ctor*"> -->

<div class="namespace-toc">

-   <span class="signature">[`Kumaraswamy( [a, b] )`][@stdlib/stats/base/dists/kumaraswamy/ctor]</span><span class="delimiter">: </span><span class="description">Kumaraswamy's double bounded distribution constructor.</span>

</div>

<!-- </toc> -->

```javascript
var Kumaraswamy = require( '@stdlib/stats/base/dists/kumaraswamy' ).Kumaraswamy;

var dist = new Kumaraswamy( 2.0, 4.0 );

var y = dist.logpdf( 0.8 );
// returns ~-1.209
```

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better examples -->

<!-- eslint no-undef: "error" -->

```javascript
var objectKeys = require( '@stdlib/utils/keys' );
var kumaraswamy = require( '@stdlib/stats/base/dists/kumaraswamy' );

console.log( objectKeys( kumaraswamy ) );
```

</section>

<!-- /.examples -->

<section class="links">

[kumaraswamy-distribution]: https://en.wikipedia.org/wiki/Kumaraswamy_distribution

<!-- <toc-links> -->

[@stdlib/stats/base/dists/kumaraswamy/ctor]: https://github.com/stdlib-js/stats/tree/main/base/dists/kumaraswamy/ctor

[@stdlib/stats/base/dists/kumaraswamy/kurtosis]: https://github.com/stdlib-js/stats/tree/main/base/dists/kumaraswamy/kurtosis

[@stdlib/stats/base/dists/kumaraswamy/mean]: https://github.com/stdlib-js/stats/tree/main/base/dists/kumaraswamy/mean

[@stdlib/stats/base/dists/kumaraswamy/median]: https://github.com/stdlib-js/stats/tree/main/base/dists/kumaraswamy/median

[@stdlib/stats/base/dists/kumaraswamy/mode]: https://github.com/stdlib-js/stats/tree/main/base/dists/kumaraswamy/mode

[@stdlib/stats/base/dists/kumaraswamy/skewness]: https://github.com/stdlib-js/stats/tree/main/base/dists/kumaraswamy/skewness

[@stdlib/stats/base/dists/kumaraswamy/stdev]: https://github.com/stdlib-js/stats/tree/main/base/dists/kumaraswamy/stdev

[@stdlib/stats/base/dists/kumaraswamy/variance]: https://github.com/stdlib-js/stats/tree/main/base/dists/kumaraswamy/variance

[@stdlib/stats/base/dists/kumaraswamy/cdf]: https://github.com/stdlib-js/stats/tree/main/base/dists/kumaraswamy/cdf

[@stdlib/stats/base/dists/kumaraswamy/logcdf]: https://github.com/stdlib-js/stats/tree/main/base/dists/kumaraswamy/logcdf

[@stdlib/stats/base/dists/kumaraswamy/logpdf]: https://github.com/stdlib-js/stats/tree/main/base/dists/kumaraswamy/logpdf

[@stdlib/stats/base/dists/kumaraswamy/pdf]: https://github.com/stdlib-js/stats/tree/main/base/dists/kumaraswamy/pdf

[@stdlib/stats/base/dists/kumaraswamy/quantile]: https://github.com/stdlib-js/stats/tree/main/base/dists/kumaraswamy/quantile

<!-- </toc-links> -->

</section>

<!-- /.links -->
