#------------------------------------------------------
#
#  This file contains interim functionality to support the legacy form of options
#  and other variables (e.g. WITH_MPI instead of the preferred LIBGRIDXC_WITH_MPI).
#
# In modern versions of CMake (>= 3.13) the existence of a variable with the same name
# as an option will make the 'option' command a no-op, and the option variable will take the
# pre-existing value, but it will not be put in the cache:
#
#   In CMake 3.13 and above the option() command prefers to do nothing
#   when a normal variable of the given name already exists. It does not
#   create or update a cache entry or remove the normal variable. The
#   new behavior is consistent between the first and later runs in a
#   build tree. This policy provides compatibility with projects that
#   have not been updated to expect the new behavior.
#
# We take advantage of this to implement a simple mechanism to honor old-style
# 'option' names: We copy their values into normal variables with the new name.
#
# Variables set explicitly with the form WITH_XXX will be cache variables,
# and the matching LIBGRIDXC_WITH_XXX normal variables.
#
# Variables of the form LIBGRIDXC_WITH_YYY set explicitly will be cache variables.
#
# Variables of the form LIBGRIDXC_WITH_YYY not set explicitly will also be cache variables, as
# they will be set to default values inside Libgridxc with the 'option' statement.

# This 'asymmetry' is not bad in principle, and might actually be informative.
# Note also that the cache will in all cases contain the relevant information to reproduce
# all the settings across 'cmake' runs, even if some of the variables are normal, as they
# will be derived in all runs from cache information.
#

message(STATUS
"Allowing non-prefixed variables (e.g. WITH_MPI --> LIBGRIDXC_WITH_MPI)")

foreach(opt
	WITH_MPI
	WITH_LIBXC
	WITH_GRID_SP
	BUILD_DOCS	
)

   if( DEFINED ${opt} )
     if ( NOT DEFINED LIBGRIDXC_${opt})
      set(LIBGRIDXC_${opt} ${${opt}})
      message(STATUS " >> Using value of deprecated ${opt} option variable for new variable LIBGRIDXC_${opt}")
     else ()
      message(STATUS " >> Both the deprecated ${opt} option variable and the new variable LIBGRIDXC_${opt} are set")
      message(STATUS "${opt}: ${${opt}}")
      message(STATUS "LIBGRIDXC_${opt}: ${LIBGRIDXC_${opt}}")
      message(STATUS " **** WARNING: The new variable LIBGRIDXC_${opt} takes precedence")
     endif()
   endif()

endforeach()

