//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmediaservices

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// TransformsClient contains the methods for the Transforms group.
// Don't use this type directly, use NewTransformsClient() instead.
type TransformsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewTransformsClient creates a new instance of TransformsClient with the specified values.
// subscriptionID - The unique identifier for a Microsoft Azure subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewTransformsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*TransformsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &TransformsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or updates a new Transform.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01
// resourceGroupName - The name of the resource group within the Azure subscription.
// accountName - The Media Services account name.
// transformName - The Transform name.
// parameters - The request parameters
// options - TransformsClientCreateOrUpdateOptions contains the optional parameters for the TransformsClient.CreateOrUpdate
// method.
func (client *TransformsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, transformName string, parameters Transform, options *TransformsClientCreateOrUpdateOptions) (TransformsClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, accountName, transformName, parameters, options)
	if err != nil {
		return TransformsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TransformsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return TransformsClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *TransformsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, accountName string, transformName string, parameters Transform, options *TransformsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if transformName == "" {
		return nil, errors.New("parameter transformName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{transformName}", url.PathEscape(transformName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *TransformsClient) createOrUpdateHandleResponse(resp *http.Response) (TransformsClientCreateOrUpdateResponse, error) {
	result := TransformsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Transform); err != nil {
		return TransformsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Deletes a Transform.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01
// resourceGroupName - The name of the resource group within the Azure subscription.
// accountName - The Media Services account name.
// transformName - The Transform name.
// options - TransformsClientDeleteOptions contains the optional parameters for the TransformsClient.Delete method.
func (client *TransformsClient) Delete(ctx context.Context, resourceGroupName string, accountName string, transformName string, options *TransformsClientDeleteOptions) (TransformsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, accountName, transformName, options)
	if err != nil {
		return TransformsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TransformsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return TransformsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return TransformsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *TransformsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, accountName string, transformName string, options *TransformsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if transformName == "" {
		return nil, errors.New("parameter transformName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{transformName}", url.PathEscape(transformName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets a Transform.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01
// resourceGroupName - The name of the resource group within the Azure subscription.
// accountName - The Media Services account name.
// transformName - The Transform name.
// options - TransformsClientGetOptions contains the optional parameters for the TransformsClient.Get method.
func (client *TransformsClient) Get(ctx context.Context, resourceGroupName string, accountName string, transformName string, options *TransformsClientGetOptions) (TransformsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, accountName, transformName, options)
	if err != nil {
		return TransformsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TransformsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return TransformsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *TransformsClient) getCreateRequest(ctx context.Context, resourceGroupName string, accountName string, transformName string, options *TransformsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if transformName == "" {
		return nil, errors.New("parameter transformName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{transformName}", url.PathEscape(transformName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *TransformsClient) getHandleResponse(resp *http.Response) (TransformsClientGetResponse, error) {
	result := TransformsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Transform); err != nil {
		return TransformsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists the Transforms in the account.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01
// resourceGroupName - The name of the resource group within the Azure subscription.
// accountName - The Media Services account name.
// options - TransformsClientListOptions contains the optional parameters for the TransformsClient.List method.
func (client *TransformsClient) NewListPager(resourceGroupName string, accountName string, options *TransformsClientListOptions) *runtime.Pager[TransformsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[TransformsClientListResponse]{
		More: func(page TransformsClientListResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *TransformsClientListResponse) (TransformsClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, resourceGroupName, accountName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.ODataNextLink)
			}
			if err != nil {
				return TransformsClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return TransformsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return TransformsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *TransformsClient) listCreateRequest(ctx context.Context, resourceGroupName string, accountName string, options *TransformsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Orderby != nil {
		reqQP.Set("$orderby", *options.Orderby)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *TransformsClient) listHandleResponse(resp *http.Response) (TransformsClientListResponse, error) {
	result := TransformsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TransformCollection); err != nil {
		return TransformsClientListResponse{}, err
	}
	return result, nil
}

// Update - Updates a Transform.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01
// resourceGroupName - The name of the resource group within the Azure subscription.
// accountName - The Media Services account name.
// transformName - The Transform name.
// parameters - The request parameters
// options - TransformsClientUpdateOptions contains the optional parameters for the TransformsClient.Update method.
func (client *TransformsClient) Update(ctx context.Context, resourceGroupName string, accountName string, transformName string, parameters Transform, options *TransformsClientUpdateOptions) (TransformsClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, accountName, transformName, parameters, options)
	if err != nil {
		return TransformsClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TransformsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return TransformsClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *TransformsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, accountName string, transformName string, parameters Transform, options *TransformsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if transformName == "" {
		return nil, errors.New("parameter transformName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{transformName}", url.PathEscape(transformName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// updateHandleResponse handles the Update response.
func (client *TransformsClient) updateHandleResponse(resp *http.Response) (TransformsClientUpdateResponse, error) {
	result := TransformsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Transform); err != nil {
		return TransformsClientUpdateResponse{}, err
	}
	return result, nil
}
