// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/netapp/v1/replication.proto

package netapppb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The replication states
// New enum values may be added in future to indicate possible new states.
type Replication_State int32

const (
	// Unspecified replication State
	Replication_STATE_UNSPECIFIED Replication_State = 0
	// Replication is creating.
	Replication_CREATING Replication_State = 1
	// Replication is ready.
	Replication_READY Replication_State = 2
	// Replication is updating.
	Replication_UPDATING Replication_State = 3
	// Replication is deleting.
	Replication_DELETING Replication_State = 5
	// Replication is in error state.
	Replication_ERROR Replication_State = 6
)

// Enum value maps for Replication_State.
var (
	Replication_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
		3: "UPDATING",
		5: "DELETING",
		6: "ERROR",
	}
	Replication_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
		"UPDATING":          3,
		"DELETING":          5,
		"ERROR":             6,
	}
)

func (x Replication_State) Enum() *Replication_State {
	p := new(Replication_State)
	*p = x
	return p
}

func (x Replication_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Replication_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_replication_proto_enumTypes[0].Descriptor()
}

func (Replication_State) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_replication_proto_enumTypes[0]
}

func (x Replication_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Replication_State.Descriptor instead.
func (Replication_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{1, 0}
}

// New enum values may be added in future to support different replication
// topology.
type Replication_ReplicationRole int32

const (
	// Unspecified replication role
	Replication_REPLICATION_ROLE_UNSPECIFIED Replication_ReplicationRole = 0
	// Indicates Source volume.
	Replication_SOURCE Replication_ReplicationRole = 1
	// Indicates Destination volume.
	Replication_DESTINATION Replication_ReplicationRole = 2
)

// Enum value maps for Replication_ReplicationRole.
var (
	Replication_ReplicationRole_name = map[int32]string{
		0: "REPLICATION_ROLE_UNSPECIFIED",
		1: "SOURCE",
		2: "DESTINATION",
	}
	Replication_ReplicationRole_value = map[string]int32{
		"REPLICATION_ROLE_UNSPECIFIED": 0,
		"SOURCE":                       1,
		"DESTINATION":                  2,
	}
)

func (x Replication_ReplicationRole) Enum() *Replication_ReplicationRole {
	p := new(Replication_ReplicationRole)
	*p = x
	return p
}

func (x Replication_ReplicationRole) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Replication_ReplicationRole) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_replication_proto_enumTypes[1].Descriptor()
}

func (Replication_ReplicationRole) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_replication_proto_enumTypes[1]
}

func (x Replication_ReplicationRole) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Replication_ReplicationRole.Descriptor instead.
func (Replication_ReplicationRole) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{1, 1}
}

// Schedule for Replication.
// New enum values may be added in future to support different frequency of
// replication.
type Replication_ReplicationSchedule int32

const (
	// Unspecified ReplicationSchedule
	Replication_REPLICATION_SCHEDULE_UNSPECIFIED Replication_ReplicationSchedule = 0
	// Replication happens once every 10 minutes.
	Replication_EVERY_10_MINUTES Replication_ReplicationSchedule = 1
	// Replication happens once every hour.
	Replication_HOURLY Replication_ReplicationSchedule = 2
	// Replication happens once every day.
	Replication_DAILY Replication_ReplicationSchedule = 3
)

// Enum value maps for Replication_ReplicationSchedule.
var (
	Replication_ReplicationSchedule_name = map[int32]string{
		0: "REPLICATION_SCHEDULE_UNSPECIFIED",
		1: "EVERY_10_MINUTES",
		2: "HOURLY",
		3: "DAILY",
	}
	Replication_ReplicationSchedule_value = map[string]int32{
		"REPLICATION_SCHEDULE_UNSPECIFIED": 0,
		"EVERY_10_MINUTES":                 1,
		"HOURLY":                           2,
		"DAILY":                            3,
	}
)

func (x Replication_ReplicationSchedule) Enum() *Replication_ReplicationSchedule {
	p := new(Replication_ReplicationSchedule)
	*p = x
	return p
}

func (x Replication_ReplicationSchedule) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Replication_ReplicationSchedule) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_replication_proto_enumTypes[2].Descriptor()
}

func (Replication_ReplicationSchedule) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_replication_proto_enumTypes[2]
}

func (x Replication_ReplicationSchedule) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Replication_ReplicationSchedule.Descriptor instead.
func (Replication_ReplicationSchedule) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{1, 2}
}

// Mirroring states.
// No new value is expected to be added in future.
type Replication_MirrorState int32

const (
	// Unspecified MirrorState
	Replication_MIRROR_STATE_UNSPECIFIED Replication_MirrorState = 0
	// Destination volume is being prepared.
	Replication_PREPARING Replication_MirrorState = 1
	// Destination volume has been initialized and is ready to receive
	// replication transfers.
	Replication_MIRRORED Replication_MirrorState = 2
	// Destination volume is not receiving replication transfers.
	Replication_STOPPED Replication_MirrorState = 3
	// Replication is in progress.
	Replication_TRANSFERRING Replication_MirrorState = 4
)

// Enum value maps for Replication_MirrorState.
var (
	Replication_MirrorState_name = map[int32]string{
		0: "MIRROR_STATE_UNSPECIFIED",
		1: "PREPARING",
		2: "MIRRORED",
		3: "STOPPED",
		4: "TRANSFERRING",
	}
	Replication_MirrorState_value = map[string]int32{
		"MIRROR_STATE_UNSPECIFIED": 0,
		"PREPARING":                1,
		"MIRRORED":                 2,
		"STOPPED":                  3,
		"TRANSFERRING":             4,
	}
)

func (x Replication_MirrorState) Enum() *Replication_MirrorState {
	p := new(Replication_MirrorState)
	*p = x
	return p
}

func (x Replication_MirrorState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Replication_MirrorState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_replication_proto_enumTypes[3].Descriptor()
}

func (Replication_MirrorState) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_replication_proto_enumTypes[3]
}

func (x Replication_MirrorState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Replication_MirrorState.Descriptor instead.
func (Replication_MirrorState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{1, 3}
}

// TransferStats reports all statistics related to replication transfer.
type TransferStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// bytes trasferred so far in current transfer.
	TransferBytes *int64 `protobuf:"varint,1,opt,name=transfer_bytes,json=transferBytes,proto3,oneof" json:"transfer_bytes,omitempty"`
	// Total time taken during transfer.
	TotalTransferDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=total_transfer_duration,json=totalTransferDuration,proto3,oneof" json:"total_transfer_duration,omitempty"`
	// Last transfer size in bytes.
	LastTransferBytes *int64 `protobuf:"varint,3,opt,name=last_transfer_bytes,json=lastTransferBytes,proto3,oneof" json:"last_transfer_bytes,omitempty"`
	// Time taken during last transfer.
	LastTransferDuration *durationpb.Duration `protobuf:"bytes,4,opt,name=last_transfer_duration,json=lastTransferDuration,proto3,oneof" json:"last_transfer_duration,omitempty"`
	// Lag duration indicates the duration by which Destination region volume
	// content lags behind the primary region volume content.
	LagDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=lag_duration,json=lagDuration,proto3,oneof" json:"lag_duration,omitempty"`
	// Time when progress was updated last.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3,oneof" json:"update_time,omitempty"`
	// Time when last transfer completed.
	LastTransferEndTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=last_transfer_end_time,json=lastTransferEndTime,proto3,oneof" json:"last_transfer_end_time,omitempty"`
	// A message describing the cause of the last transfer failure.
	LastTransferError *string `protobuf:"bytes,8,opt,name=last_transfer_error,json=lastTransferError,proto3,oneof" json:"last_transfer_error,omitempty"`
}

func (x *TransferStats) Reset() {
	*x = TransferStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferStats) ProtoMessage() {}

func (x *TransferStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferStats.ProtoReflect.Descriptor instead.
func (*TransferStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{0}
}

func (x *TransferStats) GetTransferBytes() int64 {
	if x != nil && x.TransferBytes != nil {
		return *x.TransferBytes
	}
	return 0
}

func (x *TransferStats) GetTotalTransferDuration() *durationpb.Duration {
	if x != nil {
		return x.TotalTransferDuration
	}
	return nil
}

func (x *TransferStats) GetLastTransferBytes() int64 {
	if x != nil && x.LastTransferBytes != nil {
		return *x.LastTransferBytes
	}
	return 0
}

func (x *TransferStats) GetLastTransferDuration() *durationpb.Duration {
	if x != nil {
		return x.LastTransferDuration
	}
	return nil
}

func (x *TransferStats) GetLagDuration() *durationpb.Duration {
	if x != nil {
		return x.LagDuration
	}
	return nil
}

func (x *TransferStats) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *TransferStats) GetLastTransferEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastTransferEndTime
	}
	return nil
}

func (x *TransferStats) GetLastTransferError() string {
	if x != nil && x.LastTransferError != nil {
		return *x.LastTransferError
	}
	return ""
}

// Replication is a nested resource under Volume, that describes a
// cross-region replication relationship between 2 volumes in different
// regions.
type Replication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the Replication.
	// Format:
	// `projects/{project_id}/locations/{location}/volumes/{volume_id}/replications/{replication_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. State of the replication.
	State Replication_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.netapp.v1.Replication_State" json:"state,omitempty"`
	// Output only. State details of the replication.
	StateDetails string `protobuf:"bytes,3,opt,name=state_details,json=stateDetails,proto3" json:"state_details,omitempty"`
	// Output only. Indicates whether this points to source or destination.
	Role Replication_ReplicationRole `protobuf:"varint,4,opt,name=role,proto3,enum=google.cloud.netapp.v1.Replication_ReplicationRole" json:"role,omitempty"`
	// Required. Indicates the schedule for replication.
	ReplicationSchedule Replication_ReplicationSchedule `protobuf:"varint,5,opt,name=replication_schedule,json=replicationSchedule,proto3,enum=google.cloud.netapp.v1.Replication_ReplicationSchedule" json:"replication_schedule,omitempty"`
	// Output only. Indicates the state of mirroring.
	MirrorState Replication_MirrorState `protobuf:"varint,6,opt,name=mirror_state,json=mirrorState,proto3,enum=google.cloud.netapp.v1.Replication_MirrorState" json:"mirror_state,omitempty"`
	// Output only. Condition of the relationship. Can be one of the following:
	// - true: The replication relationship is healthy. It has not missed the most
	// recent scheduled transfer.
	// - false: The replication relationship is not healthy. It has missed the
	// most recent scheduled transfer.
	Healthy *bool `protobuf:"varint,8,opt,name=healthy,proto3,oneof" json:"healthy,omitempty"`
	// Output only. Replication create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Full name of destination volume resource.
	// Example : "projects/{project}/locations/{location}/volumes/{volume_id}"
	DestinationVolume string `protobuf:"bytes,10,opt,name=destination_volume,json=destinationVolume,proto3" json:"destination_volume,omitempty"`
	// Output only. Replication transfer statistics.
	TransferStats *TransferStats `protobuf:"bytes,11,opt,name=transfer_stats,json=transferStats,proto3" json:"transfer_stats,omitempty"`
	// Resource labels to represent user provided metadata.
	Labels map[string]string `protobuf:"bytes,12,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A description about this replication relationship.
	Description *string `protobuf:"bytes,13,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Required. Input only. Destination volume parameters
	DestinationVolumeParameters *DestinationVolumeParameters `protobuf:"bytes,14,opt,name=destination_volume_parameters,json=destinationVolumeParameters,proto3" json:"destination_volume_parameters,omitempty"`
	// Output only. Full name of source volume resource.
	// Example : "projects/{project}/locations/{location}/volumes/{volume_id}"
	SourceVolume string `protobuf:"bytes,15,opt,name=source_volume,json=sourceVolume,proto3" json:"source_volume,omitempty"`
}

func (x *Replication) Reset() {
	*x = Replication{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Replication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Replication) ProtoMessage() {}

func (x *Replication) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Replication.ProtoReflect.Descriptor instead.
func (*Replication) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{1}
}

func (x *Replication) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Replication) GetState() Replication_State {
	if x != nil {
		return x.State
	}
	return Replication_STATE_UNSPECIFIED
}

func (x *Replication) GetStateDetails() string {
	if x != nil {
		return x.StateDetails
	}
	return ""
}

func (x *Replication) GetRole() Replication_ReplicationRole {
	if x != nil {
		return x.Role
	}
	return Replication_REPLICATION_ROLE_UNSPECIFIED
}

func (x *Replication) GetReplicationSchedule() Replication_ReplicationSchedule {
	if x != nil {
		return x.ReplicationSchedule
	}
	return Replication_REPLICATION_SCHEDULE_UNSPECIFIED
}

func (x *Replication) GetMirrorState() Replication_MirrorState {
	if x != nil {
		return x.MirrorState
	}
	return Replication_MIRROR_STATE_UNSPECIFIED
}

func (x *Replication) GetHealthy() bool {
	if x != nil && x.Healthy != nil {
		return *x.Healthy
	}
	return false
}

func (x *Replication) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Replication) GetDestinationVolume() string {
	if x != nil {
		return x.DestinationVolume
	}
	return ""
}

func (x *Replication) GetTransferStats() *TransferStats {
	if x != nil {
		return x.TransferStats
	}
	return nil
}

func (x *Replication) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Replication) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Replication) GetDestinationVolumeParameters() *DestinationVolumeParameters {
	if x != nil {
		return x.DestinationVolumeParameters
	}
	return nil
}

func (x *Replication) GetSourceVolume() string {
	if x != nil {
		return x.SourceVolume
	}
	return ""
}

// ListReplications lists replications.
type ListReplicationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The volume for which to retrieve replication information,
	// in the format
	// `projects/{project_id}/locations/{location}/volumes/{volume_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value to use if there are additional
	// results to retrieve for this list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Sort results. Supported values are "name", "name desc" or "" (unsorted).
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// List filter.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListReplicationsRequest) Reset() {
	*x = ListReplicationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReplicationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReplicationsRequest) ProtoMessage() {}

func (x *ListReplicationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReplicationsRequest.ProtoReflect.Descriptor instead.
func (*ListReplicationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{2}
}

func (x *ListReplicationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReplicationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReplicationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListReplicationsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListReplicationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// ListReplicationsResponse is the result of ListReplicationsRequest.
type ListReplicationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of replications in the project for the specified volume.
	Replications []*Replication `protobuf:"bytes,1,rep,name=replications,proto3" json:"replications,omitempty"`
	// The token you can use to retrieve the next page of results. Not returned
	// if there are no more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListReplicationsResponse) Reset() {
	*x = ListReplicationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReplicationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReplicationsResponse) ProtoMessage() {}

func (x *ListReplicationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReplicationsResponse.ProtoReflect.Descriptor instead.
func (*ListReplicationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{3}
}

func (x *ListReplicationsResponse) GetReplications() []*Replication {
	if x != nil {
		return x.Replications
	}
	return nil
}

func (x *ListReplicationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListReplicationsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// GetReplicationRequest gets the state of a replication.
type GetReplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The replication resource name, in the format
	// `projects/{project_id}/locations/{location}/volumes/{volume_id}/replications/{replication_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReplicationRequest) Reset() {
	*x = GetReplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetReplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReplicationRequest) ProtoMessage() {}

func (x *GetReplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReplicationRequest.ProtoReflect.Descriptor instead.
func (*GetReplicationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{4}
}

func (x *GetReplicationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// DestinationVolumeParameters specify input parameters used for creating
// destination volume.
type DestinationVolumeParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Existing destination StoragePool name.
	StoragePool string `protobuf:"bytes,1,opt,name=storage_pool,json=storagePool,proto3" json:"storage_pool,omitempty"`
	// Desired destination volume resource id. If not specified, source volume's
	// resource id will be used.
	// This value must start with a lowercase letter followed by up to 62
	// lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
	VolumeId string `protobuf:"bytes,2,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// Destination volume's share name. If not specified, source volume's share
	// name will be used.
	ShareName string `protobuf:"bytes,3,opt,name=share_name,json=shareName,proto3" json:"share_name,omitempty"`
	// Description for the destination volume.
	Description *string `protobuf:"bytes,4,opt,name=description,proto3,oneof" json:"description,omitempty"`
}

func (x *DestinationVolumeParameters) Reset() {
	*x = DestinationVolumeParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationVolumeParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationVolumeParameters) ProtoMessage() {}

func (x *DestinationVolumeParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationVolumeParameters.ProtoReflect.Descriptor instead.
func (*DestinationVolumeParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{5}
}

func (x *DestinationVolumeParameters) GetStoragePool() string {
	if x != nil {
		return x.StoragePool
	}
	return ""
}

func (x *DestinationVolumeParameters) GetVolumeId() string {
	if x != nil {
		return x.VolumeId
	}
	return ""
}

func (x *DestinationVolumeParameters) GetShareName() string {
	if x != nil {
		return x.ShareName
	}
	return ""
}

func (x *DestinationVolumeParameters) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

// CreateReplicationRequest creates a replication.
type CreateReplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The NetApp volume to create the replications of, in the format
	// `projects/{project_id}/locations/{location}/volumes/{volume_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A replication resource
	Replication *Replication `protobuf:"bytes,2,opt,name=replication,proto3" json:"replication,omitempty"`
	// Required. ID of the replication to create.
	// This value must start with a lowercase letter followed by up to 62
	// lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
	ReplicationId string `protobuf:"bytes,3,opt,name=replication_id,json=replicationId,proto3" json:"replication_id,omitempty"`
}

func (x *CreateReplicationRequest) Reset() {
	*x = CreateReplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateReplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReplicationRequest) ProtoMessage() {}

func (x *CreateReplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReplicationRequest.ProtoReflect.Descriptor instead.
func (*CreateReplicationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{6}
}

func (x *CreateReplicationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReplicationRequest) GetReplication() *Replication {
	if x != nil {
		return x.Replication
	}
	return nil
}

func (x *CreateReplicationRequest) GetReplicationId() string {
	if x != nil {
		return x.ReplicationId
	}
	return ""
}

// DeleteReplicationRequest deletes a replication.
type DeleteReplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The replication resource name, in the format
	// `projects/*/locations/*/volumes/*/replications/{replication_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteReplicationRequest) Reset() {
	*x = DeleteReplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteReplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteReplicationRequest) ProtoMessage() {}

func (x *DeleteReplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteReplicationRequest.ProtoReflect.Descriptor instead.
func (*DeleteReplicationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteReplicationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// UpdateReplicationRequest updates description and/or labels for a replication.
type UpdateReplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Mask of fields to update.  At least one path must be supplied in
	// this field.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. A replication resource
	Replication *Replication `protobuf:"bytes,2,opt,name=replication,proto3" json:"replication,omitempty"`
}

func (x *UpdateReplicationRequest) Reset() {
	*x = UpdateReplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateReplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateReplicationRequest) ProtoMessage() {}

func (x *UpdateReplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateReplicationRequest.ProtoReflect.Descriptor instead.
func (*UpdateReplicationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateReplicationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateReplicationRequest) GetReplication() *Replication {
	if x != nil {
		return x.Replication
	}
	return nil
}

// StopReplicationRequest stops a replication until resumed.
type StopReplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the replication, in the format of
	// projects/{project_id}/locations/{location}/volumes/{volume_id}/replications/{replication_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Indicates whether to stop replication forcefully while data transfer is in
	// progress.
	// Warning! if force is true, this will abort any current transfers
	// and can lead to data loss due to partial transfer.
	// If force is false, stop replication will fail while data transfer is in
	// progress and you will need to retry later.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *StopReplicationRequest) Reset() {
	*x = StopReplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopReplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopReplicationRequest) ProtoMessage() {}

func (x *StopReplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopReplicationRequest.ProtoReflect.Descriptor instead.
func (*StopReplicationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{9}
}

func (x *StopReplicationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StopReplicationRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// ResumeReplicationRequest resumes a stopped replication.
type ResumeReplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the replication, in the format of
	// projects/{project_id}/locations/{location}/volumes/{volume_id}/replications/{replication_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ResumeReplicationRequest) Reset() {
	*x = ResumeReplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResumeReplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeReplicationRequest) ProtoMessage() {}

func (x *ResumeReplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeReplicationRequest.ProtoReflect.Descriptor instead.
func (*ResumeReplicationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{10}
}

func (x *ResumeReplicationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ReverseReplicationDirectionRequest reverses direction of replication. Source
// becomes destination and destination becomes source.
type ReverseReplicationDirectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the replication, in the format of
	// projects/{project_id}/locations/{location}/volumes/{volume_id}/replications/{replication_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ReverseReplicationDirectionRequest) Reset() {
	*x = ReverseReplicationDirectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReverseReplicationDirectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReverseReplicationDirectionRequest) ProtoMessage() {}

func (x *ReverseReplicationDirectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_replication_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReverseReplicationDirectionRequest.ProtoReflect.Descriptor instead.
func (*ReverseReplicationDirectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_replication_proto_rawDescGZIP(), []int{11}
}

func (x *ReverseReplicationDirectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_netapp_v1_replication_proto protoreflect.FileDescriptor

var file_google_cloud_netapp_v1_replication_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xe4, 0x05, 0x0a, 0x0d, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0d, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x42, 0x79, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x56, 0x0a, 0x17, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x01, 0x52, 0x15, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x6c, 0x61, 0x73, 0x74, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x02, 0x52, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x42, 0x79, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x54, 0x0a, 0x16,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x03, 0x52, 0x14, 0x6c, 0x61, 0x73, 0x74, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88,
	0x01, 0x01, 0x12, 0x41, 0x0a, 0x0c, 0x6c, 0x61, 0x67, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x04, 0x52, 0x0b, 0x6c, 0x61, 0x67, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x05, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x54, 0x0a, 0x16, 0x6c, 0x61, 0x73, 0x74, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x48, 0x06, 0x52, 0x13, 0x6c, 0x61, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a,
	0x13, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x07, 0x52, 0x11, 0x6c, 0x61,
	0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x88,
	0x01, 0x01, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x6c, 0x61, 0x67, 0x5f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x42, 0x16, 0x0a, 0x14, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xee, 0x0c, 0x0a, 0x0b, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x44, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x4c, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x6f, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12,
	0x6f, 0x0a, 0x14, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x12, 0x57, 0x0a, 0x0c, 0x6d, 0x69, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x69, 0x72, 0x72,
	0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6d, 0x69,
	0x72, 0x72, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x07, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x07, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x53, 0x0a, 0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x52, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x47, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x7f, 0x0a, 0x1d, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x02, 0x52, 0x1b, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x49, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x24, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x5e,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05,
	0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x06, 0x22, 0x50,
	0x0a, 0x0f, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c,
	0x65, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x10, 0x01, 0x12,
	0x0f, 0x0a, 0x0b, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02,
	0x22, 0x68, 0x0a, 0x13, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x52, 0x45, 0x50, 0x4c, 0x49,
	0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a,
	0x10, 0x45, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x31, 0x30, 0x5f, 0x4d, 0x49, 0x4e, 0x55, 0x54, 0x45,
	0x53, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x4f, 0x55, 0x52, 0x4c, 0x59, 0x10, 0x02, 0x12,
	0x09, 0x0a, 0x05, 0x44, 0x41, 0x49, 0x4c, 0x59, 0x10, 0x03, 0x22, 0x67, 0x0a, 0x0b, 0x4d, 0x69,
	0x72, 0x72, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4d, 0x49, 0x52,
	0x52, 0x4f, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52, 0x45, 0x50, 0x41,
	0x52, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x49, 0x52, 0x52, 0x4f, 0x52,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10,
	0x03, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x52, 0x49, 0x4e,
	0x47, 0x10, 0x04, 0x3a, 0x97, 0x01, 0xea, 0x41, 0x93, 0x01, 0x0a, 0x21, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x7b,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2a, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x32, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x0a,
	0x08, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xcb, 0x01, 0x0a, 0x17, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xad, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x56, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xde, 0x01, 0x0a, 0x1b, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x4c, 0x0a, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x1b, 0x0a,
	0x09, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xd5, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x4a, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0e,
	0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x59, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x12, 0x4a, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6d,
	0x0a, 0x16, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x59, 0x0a,
	0x18, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x63, 0x0a, 0x22, 0x52, 0x65, 0x76, 0x65,
	0x72, 0x73, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0xb2, 0x01,
	0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x70, 0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74,
	0x41, 0x70, 0x70, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_netapp_v1_replication_proto_rawDescOnce sync.Once
	file_google_cloud_netapp_v1_replication_proto_rawDescData = file_google_cloud_netapp_v1_replication_proto_rawDesc
)

func file_google_cloud_netapp_v1_replication_proto_rawDescGZIP() []byte {
	file_google_cloud_netapp_v1_replication_proto_rawDescOnce.Do(func() {
		file_google_cloud_netapp_v1_replication_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_netapp_v1_replication_proto_rawDescData)
	})
	return file_google_cloud_netapp_v1_replication_proto_rawDescData
}

var file_google_cloud_netapp_v1_replication_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_netapp_v1_replication_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_netapp_v1_replication_proto_goTypes = []interface{}{
	(Replication_State)(0),                     // 0: google.cloud.netapp.v1.Replication.State
	(Replication_ReplicationRole)(0),           // 1: google.cloud.netapp.v1.Replication.ReplicationRole
	(Replication_ReplicationSchedule)(0),       // 2: google.cloud.netapp.v1.Replication.ReplicationSchedule
	(Replication_MirrorState)(0),               // 3: google.cloud.netapp.v1.Replication.MirrorState
	(*TransferStats)(nil),                      // 4: google.cloud.netapp.v1.TransferStats
	(*Replication)(nil),                        // 5: google.cloud.netapp.v1.Replication
	(*ListReplicationsRequest)(nil),            // 6: google.cloud.netapp.v1.ListReplicationsRequest
	(*ListReplicationsResponse)(nil),           // 7: google.cloud.netapp.v1.ListReplicationsResponse
	(*GetReplicationRequest)(nil),              // 8: google.cloud.netapp.v1.GetReplicationRequest
	(*DestinationVolumeParameters)(nil),        // 9: google.cloud.netapp.v1.DestinationVolumeParameters
	(*CreateReplicationRequest)(nil),           // 10: google.cloud.netapp.v1.CreateReplicationRequest
	(*DeleteReplicationRequest)(nil),           // 11: google.cloud.netapp.v1.DeleteReplicationRequest
	(*UpdateReplicationRequest)(nil),           // 12: google.cloud.netapp.v1.UpdateReplicationRequest
	(*StopReplicationRequest)(nil),             // 13: google.cloud.netapp.v1.StopReplicationRequest
	(*ResumeReplicationRequest)(nil),           // 14: google.cloud.netapp.v1.ResumeReplicationRequest
	(*ReverseReplicationDirectionRequest)(nil), // 15: google.cloud.netapp.v1.ReverseReplicationDirectionRequest
	nil,                           // 16: google.cloud.netapp.v1.Replication.LabelsEntry
	(*durationpb.Duration)(nil),   // 17: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil), // 18: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil), // 19: google.protobuf.FieldMask
}
var file_google_cloud_netapp_v1_replication_proto_depIdxs = []int32{
	17, // 0: google.cloud.netapp.v1.TransferStats.total_transfer_duration:type_name -> google.protobuf.Duration
	17, // 1: google.cloud.netapp.v1.TransferStats.last_transfer_duration:type_name -> google.protobuf.Duration
	17, // 2: google.cloud.netapp.v1.TransferStats.lag_duration:type_name -> google.protobuf.Duration
	18, // 3: google.cloud.netapp.v1.TransferStats.update_time:type_name -> google.protobuf.Timestamp
	18, // 4: google.cloud.netapp.v1.TransferStats.last_transfer_end_time:type_name -> google.protobuf.Timestamp
	0,  // 5: google.cloud.netapp.v1.Replication.state:type_name -> google.cloud.netapp.v1.Replication.State
	1,  // 6: google.cloud.netapp.v1.Replication.role:type_name -> google.cloud.netapp.v1.Replication.ReplicationRole
	2,  // 7: google.cloud.netapp.v1.Replication.replication_schedule:type_name -> google.cloud.netapp.v1.Replication.ReplicationSchedule
	3,  // 8: google.cloud.netapp.v1.Replication.mirror_state:type_name -> google.cloud.netapp.v1.Replication.MirrorState
	18, // 9: google.cloud.netapp.v1.Replication.create_time:type_name -> google.protobuf.Timestamp
	4,  // 10: google.cloud.netapp.v1.Replication.transfer_stats:type_name -> google.cloud.netapp.v1.TransferStats
	16, // 11: google.cloud.netapp.v1.Replication.labels:type_name -> google.cloud.netapp.v1.Replication.LabelsEntry
	9,  // 12: google.cloud.netapp.v1.Replication.destination_volume_parameters:type_name -> google.cloud.netapp.v1.DestinationVolumeParameters
	5,  // 13: google.cloud.netapp.v1.ListReplicationsResponse.replications:type_name -> google.cloud.netapp.v1.Replication
	5,  // 14: google.cloud.netapp.v1.CreateReplicationRequest.replication:type_name -> google.cloud.netapp.v1.Replication
	19, // 15: google.cloud.netapp.v1.UpdateReplicationRequest.update_mask:type_name -> google.protobuf.FieldMask
	5,  // 16: google.cloud.netapp.v1.UpdateReplicationRequest.replication:type_name -> google.cloud.netapp.v1.Replication
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_netapp_v1_replication_proto_init() }
func file_google_cloud_netapp_v1_replication_proto_init() {
	if File_google_cloud_netapp_v1_replication_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_netapp_v1_replication_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_replication_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Replication); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_replication_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReplicationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_replication_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReplicationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_replication_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetReplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_replication_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationVolumeParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_replication_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateReplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_replication_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteReplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_replication_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateReplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_replication_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopReplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_replication_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResumeReplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_replication_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReverseReplicationDirectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_netapp_v1_replication_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_cloud_netapp_v1_replication_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_google_cloud_netapp_v1_replication_proto_msgTypes[5].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_netapp_v1_replication_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_netapp_v1_replication_proto_goTypes,
		DependencyIndexes: file_google_cloud_netapp_v1_replication_proto_depIdxs,
		EnumInfos:         file_google_cloud_netapp_v1_replication_proto_enumTypes,
		MessageInfos:      file_google_cloud_netapp_v1_replication_proto_msgTypes,
	}.Build()
	File_google_cloud_netapp_v1_replication_proto = out.File
	file_google_cloud_netapp_v1_replication_proto_rawDesc = nil
	file_google_cloud_netapp_v1_replication_proto_goTypes = nil
	file_google_cloud_netapp_v1_replication_proto_depIdxs = nil
}
