module ha (
        input logic a,
        input logic b,
        output logic s,
        output logic c);
    
    assign s = a ^ b;
    assign c = a & b;
    endmodule



module fa (
        input logic x,
        input logic y,
        input logic z,
        output logic s,
        output logic c);
    
    assign s = x ^ y ^ z;
    assign c = (x & y) | (x & z) | (y & z);
    endmodule


module MERGED_32_32
  (
   input logic [31:0]  IN1,
   input logic [31:0]  IN2,
   output logic [63:0] result);

   logic [65:0]        res1, res2, res3, res4;
   
   
   WT_SB4_LF_17_17 m1 ({0, IN1[15:0]}, {0, IN2[15:0]}, res1[33:0]);
   WT_SB4_LF_17_17 m2 ({0, IN1[15:0]}, {IN2[31], IN2[31:16]}, res2[49:16]);
   WT_SB4_LF_17_17 m3 ({IN1[31], IN1[31:16]}, {0, IN2[15:0]}, res3[49:16]);
   WT_SB4_LF_17_17 m4 ({IN1[31], IN1[31:16]}, {IN2[31], IN2[31:16]}, res4[65:32]); 

   assign res2[15:0] = 0;
   assign res3[15:0] = 0;
   assign res4[31:0] = 0;
   
   assign res1[65:34] = 0; // sign of res1 will always be zero.
   assign res2[65:50] = {16{res2[49]}}; //sign extend
   assign res3[65:50] = {16{res3[49]}}; //sign extend
   
   assign result = res1 + res2 + res3 + res4;
   

   endmodule

   
		    

module WT_SB4_LF_17_17(
        input logic [16:0] IN1,
        input logic [16:0] IN2,
        output logic [33:0] result);
    
    
// Creating Partial Products 

    wire logic const1;
    assign const1 = 1'b1;
    
    // Signed Booth Radix-4 Partial Products Row 1
    wire logic select_e_0, select_ne_0, select_2x_0, tcomp0, select_n2x_0;
    assign select_e_0 = ((~ IN1[1]) & (IN1[0] ^ 1'b0));
    assign select_ne_0 = IN1[1] &  (IN1[0] ^ 1'b0);
    assign select_2x_0 = (~ IN1[1]) & IN1[0] & 1'b0;
    assign select_n2x_0 = IN1[1] & (~ IN1[0]) & (~ 1'b0);
    wire logic pp_0_0;
    assign pp_0_0 = (select_e_0 & IN2[0] | select_2x_0 & 1'b0 | select_n2x_0 & 1'b1 | select_ne_0 & (~ IN2[0])  );
    wire logic pp_0_1;
    assign pp_0_1 = (select_e_0 & IN2[1] | select_2x_0 & IN2[0] | select_n2x_0 & (~ IN2[0]) | select_ne_0 & (~ IN2[1])  );
    wire logic pp_0_2;
    assign pp_0_2 = (select_e_0 & IN2[2] | select_2x_0 & IN2[1] | select_n2x_0 & (~ IN2[1]) | select_ne_0 & (~ IN2[2])  );
    wire logic pp_0_3;
    assign pp_0_3 = (select_e_0 & IN2[3] | select_2x_0 & IN2[2] | select_n2x_0 & (~ IN2[2]) | select_ne_0 & (~ IN2[3])  );
    wire logic pp_0_4;
    assign pp_0_4 = (select_e_0 & IN2[4] | select_2x_0 & IN2[3] | select_n2x_0 & (~ IN2[3]) | select_ne_0 & (~ IN2[4])  );
    wire logic pp_0_5;
    assign pp_0_5 = (select_e_0 & IN2[5] | select_2x_0 & IN2[4] | select_n2x_0 & (~ IN2[4]) | select_ne_0 & (~ IN2[5])  );
    wire logic pp_0_6;
    assign pp_0_6 = (select_e_0 & IN2[6] | select_2x_0 & IN2[5] | select_n2x_0 & (~ IN2[5]) | select_ne_0 & (~ IN2[6])  );
    wire logic pp_0_7;
    assign pp_0_7 = (select_e_0 & IN2[7] | select_2x_0 & IN2[6] | select_n2x_0 & (~ IN2[6]) | select_ne_0 & (~ IN2[7])  );
    wire logic pp_0_8;
    assign pp_0_8 = (select_e_0 & IN2[8] | select_2x_0 & IN2[7] | select_n2x_0 & (~ IN2[7]) | select_ne_0 & (~ IN2[8])  );
    wire logic pp_0_9;
    assign pp_0_9 = (select_e_0 & IN2[9] | select_2x_0 & IN2[8] | select_n2x_0 & (~ IN2[8]) | select_ne_0 & (~ IN2[9])  );
    wire logic pp_0_10;
    assign pp_0_10 = (select_e_0 & IN2[10] | select_2x_0 & IN2[9] | select_n2x_0 & (~ IN2[9]) | select_ne_0 & (~ IN2[10])  );
    wire logic pp_0_11;
    assign pp_0_11 = (select_e_0 & IN2[11] | select_2x_0 & IN2[10] | select_n2x_0 & (~ IN2[10]) | select_ne_0 & (~ IN2[11])  );
    wire logic pp_0_12;
    assign pp_0_12 = (select_e_0 & IN2[12] | select_2x_0 & IN2[11] | select_n2x_0 & (~ IN2[11]) | select_ne_0 & (~ IN2[12])  );
    wire logic pp_0_13;
    assign pp_0_13 = (select_e_0 & IN2[13] | select_2x_0 & IN2[12] | select_n2x_0 & (~ IN2[12]) | select_ne_0 & (~ IN2[13])  );
    wire logic pp_0_14;
    assign pp_0_14 = (select_e_0 & IN2[14] | select_2x_0 & IN2[13] | select_n2x_0 & (~ IN2[13]) | select_ne_0 & (~ IN2[14])  );
    wire logic pp_0_15;
    assign pp_0_15 = (select_e_0 & IN2[15] | select_2x_0 & IN2[14] | select_n2x_0 & (~ IN2[14]) | select_ne_0 & (~ IN2[15])  );
    wire logic pp_0_16;
    assign pp_0_16 = (select_e_0 & IN2[16] | select_2x_0 & IN2[15] | select_n2x_0 & (~ IN2[15]) | select_ne_0 & (~ IN2[16])  );
    wire logic pp_0_17;
    assign pp_0_17 = (select_e_0 & IN2[16] | select_2x_0 & IN2[16] | select_n2x_0 & (~ IN2[16]) | select_ne_0 & (~ IN2[16])  );
    wire logic pp_0_18;
    assign pp_0_18 = ~ (select_e_0 & IN2[16] | select_2x_0 & IN2[16] | select_n2x_0 & (~ IN2[16]) | select_ne_0 & (~ IN2[16])  );
    assign tcomp0 = select_ne_0 | select_n2x_0;
    
    // Signed Booth Radix-4 Partial Products Row 2
    wire logic select_e_1, select_ne_1, select_2x_1, tcomp1, select_n2x_1;
    assign select_e_1 = ((~ IN1[3]) & (IN1[2] ^ IN1[1]));
    assign select_ne_1 = IN1[3] &  (IN1[2] ^ IN1[1]);
    assign select_2x_1 = (~ IN1[3]) & IN1[2] & IN1[1];
    assign select_n2x_1 = IN1[3] & (~ IN1[2]) & (~ IN1[1]);
    wire logic pp_1_0;
    assign pp_1_0 = (select_e_1 & IN2[0] | select_2x_1 & 1'b0 | select_n2x_1 & 1'b1 | select_ne_1 & (~ IN2[0])  );
    wire logic pp_1_1;
    assign pp_1_1 = (select_e_1 & IN2[1] | select_2x_1 & IN2[0] | select_n2x_1 & (~ IN2[0]) | select_ne_1 & (~ IN2[1])  );
    wire logic pp_1_2;
    assign pp_1_2 = (select_e_1 & IN2[2] | select_2x_1 & IN2[1] | select_n2x_1 & (~ IN2[1]) | select_ne_1 & (~ IN2[2])  );
    wire logic pp_1_3;
    assign pp_1_3 = (select_e_1 & IN2[3] | select_2x_1 & IN2[2] | select_n2x_1 & (~ IN2[2]) | select_ne_1 & (~ IN2[3])  );
    wire logic pp_1_4;
    assign pp_1_4 = (select_e_1 & IN2[4] | select_2x_1 & IN2[3] | select_n2x_1 & (~ IN2[3]) | select_ne_1 & (~ IN2[4])  );
    wire logic pp_1_5;
    assign pp_1_5 = (select_e_1 & IN2[5] | select_2x_1 & IN2[4] | select_n2x_1 & (~ IN2[4]) | select_ne_1 & (~ IN2[5])  );
    wire logic pp_1_6;
    assign pp_1_6 = (select_e_1 & IN2[6] | select_2x_1 & IN2[5] | select_n2x_1 & (~ IN2[5]) | select_ne_1 & (~ IN2[6])  );
    wire logic pp_1_7;
    assign pp_1_7 = (select_e_1 & IN2[7] | select_2x_1 & IN2[6] | select_n2x_1 & (~ IN2[6]) | select_ne_1 & (~ IN2[7])  );
    wire logic pp_1_8;
    assign pp_1_8 = (select_e_1 & IN2[8] | select_2x_1 & IN2[7] | select_n2x_1 & (~ IN2[7]) | select_ne_1 & (~ IN2[8])  );
    wire logic pp_1_9;
    assign pp_1_9 = (select_e_1 & IN2[9] | select_2x_1 & IN2[8] | select_n2x_1 & (~ IN2[8]) | select_ne_1 & (~ IN2[9])  );
    wire logic pp_1_10;
    assign pp_1_10 = (select_e_1 & IN2[10] | select_2x_1 & IN2[9] | select_n2x_1 & (~ IN2[9]) | select_ne_1 & (~ IN2[10])  );
    wire logic pp_1_11;
    assign pp_1_11 = (select_e_1 & IN2[11] | select_2x_1 & IN2[10] | select_n2x_1 & (~ IN2[10]) | select_ne_1 & (~ IN2[11])  );
    wire logic pp_1_12;
    assign pp_1_12 = (select_e_1 & IN2[12] | select_2x_1 & IN2[11] | select_n2x_1 & (~ IN2[11]) | select_ne_1 & (~ IN2[12])  );
    wire logic pp_1_13;
    assign pp_1_13 = (select_e_1 & IN2[13] | select_2x_1 & IN2[12] | select_n2x_1 & (~ IN2[12]) | select_ne_1 & (~ IN2[13])  );
    wire logic pp_1_14;
    assign pp_1_14 = (select_e_1 & IN2[14] | select_2x_1 & IN2[13] | select_n2x_1 & (~ IN2[13]) | select_ne_1 & (~ IN2[14])  );
    wire logic pp_1_15;
    assign pp_1_15 = (select_e_1 & IN2[15] | select_2x_1 & IN2[14] | select_n2x_1 & (~ IN2[14]) | select_ne_1 & (~ IN2[15])  );
    wire logic pp_1_16;
    assign pp_1_16 = (select_e_1 & IN2[16] | select_2x_1 & IN2[15] | select_n2x_1 & (~ IN2[15]) | select_ne_1 & (~ IN2[16])  );
    wire logic pp_1_17;
    assign pp_1_17 = (select_e_1 & IN2[16] | select_2x_1 & IN2[16] | select_n2x_1 & (~ IN2[16]) | select_ne_1 & (~ IN2[16])  );
    wire logic pp_1_18;
    assign pp_1_18 = ~ (select_e_1 & IN2[16] | select_2x_1 & IN2[16] | select_n2x_1 & (~ IN2[16]) | select_ne_1 & (~ IN2[16])  );
    assign tcomp1 = select_ne_1 | select_n2x_1;
    
    // Signed Booth Radix-4 Partial Products Row 3
    wire logic select_e_2, select_ne_2, select_2x_2, tcomp2, select_n2x_2;
    assign select_e_2 = ((~ IN1[5]) & (IN1[4] ^ IN1[3]));
    assign select_ne_2 = IN1[5] &  (IN1[4] ^ IN1[3]);
    assign select_2x_2 = (~ IN1[5]) & IN1[4] & IN1[3];
    assign select_n2x_2 = IN1[5] & (~ IN1[4]) & (~ IN1[3]);
    wire logic pp_2_0;
    assign pp_2_0 = (select_e_2 & IN2[0] | select_2x_2 & 1'b0 | select_n2x_2 & 1'b1 | select_ne_2 & (~ IN2[0])  );
    wire logic pp_2_1;
    assign pp_2_1 = (select_e_2 & IN2[1] | select_2x_2 & IN2[0] | select_n2x_2 & (~ IN2[0]) | select_ne_2 & (~ IN2[1])  );
    wire logic pp_2_2;
    assign pp_2_2 = (select_e_2 & IN2[2] | select_2x_2 & IN2[1] | select_n2x_2 & (~ IN2[1]) | select_ne_2 & (~ IN2[2])  );
    wire logic pp_2_3;
    assign pp_2_3 = (select_e_2 & IN2[3] | select_2x_2 & IN2[2] | select_n2x_2 & (~ IN2[2]) | select_ne_2 & (~ IN2[3])  );
    wire logic pp_2_4;
    assign pp_2_4 = (select_e_2 & IN2[4] | select_2x_2 & IN2[3] | select_n2x_2 & (~ IN2[3]) | select_ne_2 & (~ IN2[4])  );
    wire logic pp_2_5;
    assign pp_2_5 = (select_e_2 & IN2[5] | select_2x_2 & IN2[4] | select_n2x_2 & (~ IN2[4]) | select_ne_2 & (~ IN2[5])  );
    wire logic pp_2_6;
    assign pp_2_6 = (select_e_2 & IN2[6] | select_2x_2 & IN2[5] | select_n2x_2 & (~ IN2[5]) | select_ne_2 & (~ IN2[6])  );
    wire logic pp_2_7;
    assign pp_2_7 = (select_e_2 & IN2[7] | select_2x_2 & IN2[6] | select_n2x_2 & (~ IN2[6]) | select_ne_2 & (~ IN2[7])  );
    wire logic pp_2_8;
    assign pp_2_8 = (select_e_2 & IN2[8] | select_2x_2 & IN2[7] | select_n2x_2 & (~ IN2[7]) | select_ne_2 & (~ IN2[8])  );
    wire logic pp_2_9;
    assign pp_2_9 = (select_e_2 & IN2[9] | select_2x_2 & IN2[8] | select_n2x_2 & (~ IN2[8]) | select_ne_2 & (~ IN2[9])  );
    wire logic pp_2_10;
    assign pp_2_10 = (select_e_2 & IN2[10] | select_2x_2 & IN2[9] | select_n2x_2 & (~ IN2[9]) | select_ne_2 & (~ IN2[10])  );
    wire logic pp_2_11;
    assign pp_2_11 = (select_e_2 & IN2[11] | select_2x_2 & IN2[10] | select_n2x_2 & (~ IN2[10]) | select_ne_2 & (~ IN2[11])  );
    wire logic pp_2_12;
    assign pp_2_12 = (select_e_2 & IN2[12] | select_2x_2 & IN2[11] | select_n2x_2 & (~ IN2[11]) | select_ne_2 & (~ IN2[12])  );
    wire logic pp_2_13;
    assign pp_2_13 = (select_e_2 & IN2[13] | select_2x_2 & IN2[12] | select_n2x_2 & (~ IN2[12]) | select_ne_2 & (~ IN2[13])  );
    wire logic pp_2_14;
    assign pp_2_14 = (select_e_2 & IN2[14] | select_2x_2 & IN2[13] | select_n2x_2 & (~ IN2[13]) | select_ne_2 & (~ IN2[14])  );
    wire logic pp_2_15;
    assign pp_2_15 = (select_e_2 & IN2[15] | select_2x_2 & IN2[14] | select_n2x_2 & (~ IN2[14]) | select_ne_2 & (~ IN2[15])  );
    wire logic pp_2_16;
    assign pp_2_16 = (select_e_2 & IN2[16] | select_2x_2 & IN2[15] | select_n2x_2 & (~ IN2[15]) | select_ne_2 & (~ IN2[16])  );
    wire logic pp_2_17;
    assign pp_2_17 = (select_e_2 & IN2[16] | select_2x_2 & IN2[16] | select_n2x_2 & (~ IN2[16]) | select_ne_2 & (~ IN2[16])  );
    wire logic pp_2_18;
    assign pp_2_18 = ~ (select_e_2 & IN2[16] | select_2x_2 & IN2[16] | select_n2x_2 & (~ IN2[16]) | select_ne_2 & (~ IN2[16])  );
    assign tcomp2 = select_ne_2 | select_n2x_2;
    
    // Signed Booth Radix-4 Partial Products Row 4
    wire logic select_e_3, select_ne_3, select_2x_3, tcomp3, select_n2x_3;
    assign select_e_3 = ((~ IN1[7]) & (IN1[6] ^ IN1[5]));
    assign select_ne_3 = IN1[7] &  (IN1[6] ^ IN1[5]);
    assign select_2x_3 = (~ IN1[7]) & IN1[6] & IN1[5];
    assign select_n2x_3 = IN1[7] & (~ IN1[6]) & (~ IN1[5]);
    wire logic pp_3_0;
    assign pp_3_0 = (select_e_3 & IN2[0] | select_2x_3 & 1'b0 | select_n2x_3 & 1'b1 | select_ne_3 & (~ IN2[0])  );
    wire logic pp_3_1;
    assign pp_3_1 = (select_e_3 & IN2[1] | select_2x_3 & IN2[0] | select_n2x_3 & (~ IN2[0]) | select_ne_3 & (~ IN2[1])  );
    wire logic pp_3_2;
    assign pp_3_2 = (select_e_3 & IN2[2] | select_2x_3 & IN2[1] | select_n2x_3 & (~ IN2[1]) | select_ne_3 & (~ IN2[2])  );
    wire logic pp_3_3;
    assign pp_3_3 = (select_e_3 & IN2[3] | select_2x_3 & IN2[2] | select_n2x_3 & (~ IN2[2]) | select_ne_3 & (~ IN2[3])  );
    wire logic pp_3_4;
    assign pp_3_4 = (select_e_3 & IN2[4] | select_2x_3 & IN2[3] | select_n2x_3 & (~ IN2[3]) | select_ne_3 & (~ IN2[4])  );
    wire logic pp_3_5;
    assign pp_3_5 = (select_e_3 & IN2[5] | select_2x_3 & IN2[4] | select_n2x_3 & (~ IN2[4]) | select_ne_3 & (~ IN2[5])  );
    wire logic pp_3_6;
    assign pp_3_6 = (select_e_3 & IN2[6] | select_2x_3 & IN2[5] | select_n2x_3 & (~ IN2[5]) | select_ne_3 & (~ IN2[6])  );
    wire logic pp_3_7;
    assign pp_3_7 = (select_e_3 & IN2[7] | select_2x_3 & IN2[6] | select_n2x_3 & (~ IN2[6]) | select_ne_3 & (~ IN2[7])  );
    wire logic pp_3_8;
    assign pp_3_8 = (select_e_3 & IN2[8] | select_2x_3 & IN2[7] | select_n2x_3 & (~ IN2[7]) | select_ne_3 & (~ IN2[8])  );
    wire logic pp_3_9;
    assign pp_3_9 = (select_e_3 & IN2[9] | select_2x_3 & IN2[8] | select_n2x_3 & (~ IN2[8]) | select_ne_3 & (~ IN2[9])  );
    wire logic pp_3_10;
    assign pp_3_10 = (select_e_3 & IN2[10] | select_2x_3 & IN2[9] | select_n2x_3 & (~ IN2[9]) | select_ne_3 & (~ IN2[10])  );
    wire logic pp_3_11;
    assign pp_3_11 = (select_e_3 & IN2[11] | select_2x_3 & IN2[10] | select_n2x_3 & (~ IN2[10]) | select_ne_3 & (~ IN2[11])  );
    wire logic pp_3_12;
    assign pp_3_12 = (select_e_3 & IN2[12] | select_2x_3 & IN2[11] | select_n2x_3 & (~ IN2[11]) | select_ne_3 & (~ IN2[12])  );
    wire logic pp_3_13;
    assign pp_3_13 = (select_e_3 & IN2[13] | select_2x_3 & IN2[12] | select_n2x_3 & (~ IN2[12]) | select_ne_3 & (~ IN2[13])  );
    wire logic pp_3_14;
    assign pp_3_14 = (select_e_3 & IN2[14] | select_2x_3 & IN2[13] | select_n2x_3 & (~ IN2[13]) | select_ne_3 & (~ IN2[14])  );
    wire logic pp_3_15;
    assign pp_3_15 = (select_e_3 & IN2[15] | select_2x_3 & IN2[14] | select_n2x_3 & (~ IN2[14]) | select_ne_3 & (~ IN2[15])  );
    wire logic pp_3_16;
    assign pp_3_16 = (select_e_3 & IN2[16] | select_2x_3 & IN2[15] | select_n2x_3 & (~ IN2[15]) | select_ne_3 & (~ IN2[16])  );
    wire logic pp_3_17;
    assign pp_3_17 = (select_e_3 & IN2[16] | select_2x_3 & IN2[16] | select_n2x_3 & (~ IN2[16]) | select_ne_3 & (~ IN2[16])  );
    wire logic pp_3_18;
    assign pp_3_18 = ~ (select_e_3 & IN2[16] | select_2x_3 & IN2[16] | select_n2x_3 & (~ IN2[16]) | select_ne_3 & (~ IN2[16])  );
    assign tcomp3 = select_ne_3 | select_n2x_3;
    
    // Signed Booth Radix-4 Partial Products Row 5
    wire logic select_e_4, select_ne_4, select_2x_4, tcomp4, select_n2x_4;
    assign select_e_4 = ((~ IN1[9]) & (IN1[8] ^ IN1[7]));
    assign select_ne_4 = IN1[9] &  (IN1[8] ^ IN1[7]);
    assign select_2x_4 = (~ IN1[9]) & IN1[8] & IN1[7];
    assign select_n2x_4 = IN1[9] & (~ IN1[8]) & (~ IN1[7]);
    wire logic pp_4_0;
    assign pp_4_0 = (select_e_4 & IN2[0] | select_2x_4 & 1'b0 | select_n2x_4 & 1'b1 | select_ne_4 & (~ IN2[0])  );
    wire logic pp_4_1;
    assign pp_4_1 = (select_e_4 & IN2[1] | select_2x_4 & IN2[0] | select_n2x_4 & (~ IN2[0]) | select_ne_4 & (~ IN2[1])  );
    wire logic pp_4_2;
    assign pp_4_2 = (select_e_4 & IN2[2] | select_2x_4 & IN2[1] | select_n2x_4 & (~ IN2[1]) | select_ne_4 & (~ IN2[2])  );
    wire logic pp_4_3;
    assign pp_4_3 = (select_e_4 & IN2[3] | select_2x_4 & IN2[2] | select_n2x_4 & (~ IN2[2]) | select_ne_4 & (~ IN2[3])  );
    wire logic pp_4_4;
    assign pp_4_4 = (select_e_4 & IN2[4] | select_2x_4 & IN2[3] | select_n2x_4 & (~ IN2[3]) | select_ne_4 & (~ IN2[4])  );
    wire logic pp_4_5;
    assign pp_4_5 = (select_e_4 & IN2[5] | select_2x_4 & IN2[4] | select_n2x_4 & (~ IN2[4]) | select_ne_4 & (~ IN2[5])  );
    wire logic pp_4_6;
    assign pp_4_6 = (select_e_4 & IN2[6] | select_2x_4 & IN2[5] | select_n2x_4 & (~ IN2[5]) | select_ne_4 & (~ IN2[6])  );
    wire logic pp_4_7;
    assign pp_4_7 = (select_e_4 & IN2[7] | select_2x_4 & IN2[6] | select_n2x_4 & (~ IN2[6]) | select_ne_4 & (~ IN2[7])  );
    wire logic pp_4_8;
    assign pp_4_8 = (select_e_4 & IN2[8] | select_2x_4 & IN2[7] | select_n2x_4 & (~ IN2[7]) | select_ne_4 & (~ IN2[8])  );
    wire logic pp_4_9;
    assign pp_4_9 = (select_e_4 & IN2[9] | select_2x_4 & IN2[8] | select_n2x_4 & (~ IN2[8]) | select_ne_4 & (~ IN2[9])  );
    wire logic pp_4_10;
    assign pp_4_10 = (select_e_4 & IN2[10] | select_2x_4 & IN2[9] | select_n2x_4 & (~ IN2[9]) | select_ne_4 & (~ IN2[10])  );
    wire logic pp_4_11;
    assign pp_4_11 = (select_e_4 & IN2[11] | select_2x_4 & IN2[10] | select_n2x_4 & (~ IN2[10]) | select_ne_4 & (~ IN2[11])  );
    wire logic pp_4_12;
    assign pp_4_12 = (select_e_4 & IN2[12] | select_2x_4 & IN2[11] | select_n2x_4 & (~ IN2[11]) | select_ne_4 & (~ IN2[12])  );
    wire logic pp_4_13;
    assign pp_4_13 = (select_e_4 & IN2[13] | select_2x_4 & IN2[12] | select_n2x_4 & (~ IN2[12]) | select_ne_4 & (~ IN2[13])  );
    wire logic pp_4_14;
    assign pp_4_14 = (select_e_4 & IN2[14] | select_2x_4 & IN2[13] | select_n2x_4 & (~ IN2[13]) | select_ne_4 & (~ IN2[14])  );
    wire logic pp_4_15;
    assign pp_4_15 = (select_e_4 & IN2[15] | select_2x_4 & IN2[14] | select_n2x_4 & (~ IN2[14]) | select_ne_4 & (~ IN2[15])  );
    wire logic pp_4_16;
    assign pp_4_16 = (select_e_4 & IN2[16] | select_2x_4 & IN2[15] | select_n2x_4 & (~ IN2[15]) | select_ne_4 & (~ IN2[16])  );
    wire logic pp_4_17;
    assign pp_4_17 = (select_e_4 & IN2[16] | select_2x_4 & IN2[16] | select_n2x_4 & (~ IN2[16]) | select_ne_4 & (~ IN2[16])  );
    wire logic pp_4_18;
    assign pp_4_18 = ~ (select_e_4 & IN2[16] | select_2x_4 & IN2[16] | select_n2x_4 & (~ IN2[16]) | select_ne_4 & (~ IN2[16])  );
    assign tcomp4 = select_ne_4 | select_n2x_4;
    
    // Signed Booth Radix-4 Partial Products Row 6
    wire logic select_e_5, select_ne_5, select_2x_5, tcomp5, select_n2x_5;
    assign select_e_5 = ((~ IN1[11]) & (IN1[10] ^ IN1[9]));
    assign select_ne_5 = IN1[11] &  (IN1[10] ^ IN1[9]);
    assign select_2x_5 = (~ IN1[11]) & IN1[10] & IN1[9];
    assign select_n2x_5 = IN1[11] & (~ IN1[10]) & (~ IN1[9]);
    wire logic pp_5_0;
    assign pp_5_0 = (select_e_5 & IN2[0] | select_2x_5 & 1'b0 | select_n2x_5 & 1'b1 | select_ne_5 & (~ IN2[0])  );
    wire logic pp_5_1;
    assign pp_5_1 = (select_e_5 & IN2[1] | select_2x_5 & IN2[0] | select_n2x_5 & (~ IN2[0]) | select_ne_5 & (~ IN2[1])  );
    wire logic pp_5_2;
    assign pp_5_2 = (select_e_5 & IN2[2] | select_2x_5 & IN2[1] | select_n2x_5 & (~ IN2[1]) | select_ne_5 & (~ IN2[2])  );
    wire logic pp_5_3;
    assign pp_5_3 = (select_e_5 & IN2[3] | select_2x_5 & IN2[2] | select_n2x_5 & (~ IN2[2]) | select_ne_5 & (~ IN2[3])  );
    wire logic pp_5_4;
    assign pp_5_4 = (select_e_5 & IN2[4] | select_2x_5 & IN2[3] | select_n2x_5 & (~ IN2[3]) | select_ne_5 & (~ IN2[4])  );
    wire logic pp_5_5;
    assign pp_5_5 = (select_e_5 & IN2[5] | select_2x_5 & IN2[4] | select_n2x_5 & (~ IN2[4]) | select_ne_5 & (~ IN2[5])  );
    wire logic pp_5_6;
    assign pp_5_6 = (select_e_5 & IN2[6] | select_2x_5 & IN2[5] | select_n2x_5 & (~ IN2[5]) | select_ne_5 & (~ IN2[6])  );
    wire logic pp_5_7;
    assign pp_5_7 = (select_e_5 & IN2[7] | select_2x_5 & IN2[6] | select_n2x_5 & (~ IN2[6]) | select_ne_5 & (~ IN2[7])  );
    wire logic pp_5_8;
    assign pp_5_8 = (select_e_5 & IN2[8] | select_2x_5 & IN2[7] | select_n2x_5 & (~ IN2[7]) | select_ne_5 & (~ IN2[8])  );
    wire logic pp_5_9;
    assign pp_5_9 = (select_e_5 & IN2[9] | select_2x_5 & IN2[8] | select_n2x_5 & (~ IN2[8]) | select_ne_5 & (~ IN2[9])  );
    wire logic pp_5_10;
    assign pp_5_10 = (select_e_5 & IN2[10] | select_2x_5 & IN2[9] | select_n2x_5 & (~ IN2[9]) | select_ne_5 & (~ IN2[10])  );
    wire logic pp_5_11;
    assign pp_5_11 = (select_e_5 & IN2[11] | select_2x_5 & IN2[10] | select_n2x_5 & (~ IN2[10]) | select_ne_5 & (~ IN2[11])  );
    wire logic pp_5_12;
    assign pp_5_12 = (select_e_5 & IN2[12] | select_2x_5 & IN2[11] | select_n2x_5 & (~ IN2[11]) | select_ne_5 & (~ IN2[12])  );
    wire logic pp_5_13;
    assign pp_5_13 = (select_e_5 & IN2[13] | select_2x_5 & IN2[12] | select_n2x_5 & (~ IN2[12]) | select_ne_5 & (~ IN2[13])  );
    wire logic pp_5_14;
    assign pp_5_14 = (select_e_5 & IN2[14] | select_2x_5 & IN2[13] | select_n2x_5 & (~ IN2[13]) | select_ne_5 & (~ IN2[14])  );
    wire logic pp_5_15;
    assign pp_5_15 = (select_e_5 & IN2[15] | select_2x_5 & IN2[14] | select_n2x_5 & (~ IN2[14]) | select_ne_5 & (~ IN2[15])  );
    wire logic pp_5_16;
    assign pp_5_16 = (select_e_5 & IN2[16] | select_2x_5 & IN2[15] | select_n2x_5 & (~ IN2[15]) | select_ne_5 & (~ IN2[16])  );
    wire logic pp_5_17;
    assign pp_5_17 = (select_e_5 & IN2[16] | select_2x_5 & IN2[16] | select_n2x_5 & (~ IN2[16]) | select_ne_5 & (~ IN2[16])  );
    wire logic pp_5_18;
    assign pp_5_18 = ~ (select_e_5 & IN2[16] | select_2x_5 & IN2[16] | select_n2x_5 & (~ IN2[16]) | select_ne_5 & (~ IN2[16])  );
    assign tcomp5 = select_ne_5 | select_n2x_5;
    
    // Signed Booth Radix-4 Partial Products Row 7
    wire logic select_e_6, select_ne_6, select_2x_6, tcomp6, select_n2x_6;
    assign select_e_6 = ((~ IN1[13]) & (IN1[12] ^ IN1[11]));
    assign select_ne_6 = IN1[13] &  (IN1[12] ^ IN1[11]);
    assign select_2x_6 = (~ IN1[13]) & IN1[12] & IN1[11];
    assign select_n2x_6 = IN1[13] & (~ IN1[12]) & (~ IN1[11]);
    wire logic pp_6_0;
    assign pp_6_0 = (select_e_6 & IN2[0] | select_2x_6 & 1'b0 | select_n2x_6 & 1'b1 | select_ne_6 & (~ IN2[0])  );
    wire logic pp_6_1;
    assign pp_6_1 = (select_e_6 & IN2[1] | select_2x_6 & IN2[0] | select_n2x_6 & (~ IN2[0]) | select_ne_6 & (~ IN2[1])  );
    wire logic pp_6_2;
    assign pp_6_2 = (select_e_6 & IN2[2] | select_2x_6 & IN2[1] | select_n2x_6 & (~ IN2[1]) | select_ne_6 & (~ IN2[2])  );
    wire logic pp_6_3;
    assign pp_6_3 = (select_e_6 & IN2[3] | select_2x_6 & IN2[2] | select_n2x_6 & (~ IN2[2]) | select_ne_6 & (~ IN2[3])  );
    wire logic pp_6_4;
    assign pp_6_4 = (select_e_6 & IN2[4] | select_2x_6 & IN2[3] | select_n2x_6 & (~ IN2[3]) | select_ne_6 & (~ IN2[4])  );
    wire logic pp_6_5;
    assign pp_6_5 = (select_e_6 & IN2[5] | select_2x_6 & IN2[4] | select_n2x_6 & (~ IN2[4]) | select_ne_6 & (~ IN2[5])  );
    wire logic pp_6_6;
    assign pp_6_6 = (select_e_6 & IN2[6] | select_2x_6 & IN2[5] | select_n2x_6 & (~ IN2[5]) | select_ne_6 & (~ IN2[6])  );
    wire logic pp_6_7;
    assign pp_6_7 = (select_e_6 & IN2[7] | select_2x_6 & IN2[6] | select_n2x_6 & (~ IN2[6]) | select_ne_6 & (~ IN2[7])  );
    wire logic pp_6_8;
    assign pp_6_8 = (select_e_6 & IN2[8] | select_2x_6 & IN2[7] | select_n2x_6 & (~ IN2[7]) | select_ne_6 & (~ IN2[8])  );
    wire logic pp_6_9;
    assign pp_6_9 = (select_e_6 & IN2[9] | select_2x_6 & IN2[8] | select_n2x_6 & (~ IN2[8]) | select_ne_6 & (~ IN2[9])  );
    wire logic pp_6_10;
    assign pp_6_10 = (select_e_6 & IN2[10] | select_2x_6 & IN2[9] | select_n2x_6 & (~ IN2[9]) | select_ne_6 & (~ IN2[10])  );
    wire logic pp_6_11;
    assign pp_6_11 = (select_e_6 & IN2[11] | select_2x_6 & IN2[10] | select_n2x_6 & (~ IN2[10]) | select_ne_6 & (~ IN2[11])  );
    wire logic pp_6_12;
    assign pp_6_12 = (select_e_6 & IN2[12] | select_2x_6 & IN2[11] | select_n2x_6 & (~ IN2[11]) | select_ne_6 & (~ IN2[12])  );
    wire logic pp_6_13;
    assign pp_6_13 = (select_e_6 & IN2[13] | select_2x_6 & IN2[12] | select_n2x_6 & (~ IN2[12]) | select_ne_6 & (~ IN2[13])  );
    wire logic pp_6_14;
    assign pp_6_14 = (select_e_6 & IN2[14] | select_2x_6 & IN2[13] | select_n2x_6 & (~ IN2[13]) | select_ne_6 & (~ IN2[14])  );
    wire logic pp_6_15;
    assign pp_6_15 = (select_e_6 & IN2[15] | select_2x_6 & IN2[14] | select_n2x_6 & (~ IN2[14]) | select_ne_6 & (~ IN2[15])  );
    wire logic pp_6_16;
    assign pp_6_16 = (select_e_6 & IN2[16] | select_2x_6 & IN2[15] | select_n2x_6 & (~ IN2[15]) | select_ne_6 & (~ IN2[16])  );
    wire logic pp_6_17;
    assign pp_6_17 = (select_e_6 & IN2[16] | select_2x_6 & IN2[16] | select_n2x_6 & (~ IN2[16]) | select_ne_6 & (~ IN2[16])  );
    wire logic pp_6_18;
    assign pp_6_18 = ~ (select_e_6 & IN2[16] | select_2x_6 & IN2[16] | select_n2x_6 & (~ IN2[16]) | select_ne_6 & (~ IN2[16])  );
    assign tcomp6 = select_ne_6 | select_n2x_6;
    
    // Signed Booth Radix-4 Partial Products Row 8
    wire logic select_e_7, select_ne_7, select_2x_7, tcomp7, select_n2x_7;
    assign select_e_7 = ((~ IN1[15]) & (IN1[14] ^ IN1[13]));
    assign select_ne_7 = IN1[15] &  (IN1[14] ^ IN1[13]);
    assign select_2x_7 = (~ IN1[15]) & IN1[14] & IN1[13];
    assign select_n2x_7 = IN1[15] & (~ IN1[14]) & (~ IN1[13]);
    wire logic pp_7_0;
    assign pp_7_0 = (select_e_7 & IN2[0] | select_2x_7 & 1'b0 | select_n2x_7 & 1'b1 | select_ne_7 & (~ IN2[0])  );
    wire logic pp_7_1;
    assign pp_7_1 = (select_e_7 & IN2[1] | select_2x_7 & IN2[0] | select_n2x_7 & (~ IN2[0]) | select_ne_7 & (~ IN2[1])  );
    wire logic pp_7_2;
    assign pp_7_2 = (select_e_7 & IN2[2] | select_2x_7 & IN2[1] | select_n2x_7 & (~ IN2[1]) | select_ne_7 & (~ IN2[2])  );
    wire logic pp_7_3;
    assign pp_7_3 = (select_e_7 & IN2[3] | select_2x_7 & IN2[2] | select_n2x_7 & (~ IN2[2]) | select_ne_7 & (~ IN2[3])  );
    wire logic pp_7_4;
    assign pp_7_4 = (select_e_7 & IN2[4] | select_2x_7 & IN2[3] | select_n2x_7 & (~ IN2[3]) | select_ne_7 & (~ IN2[4])  );
    wire logic pp_7_5;
    assign pp_7_5 = (select_e_7 & IN2[5] | select_2x_7 & IN2[4] | select_n2x_7 & (~ IN2[4]) | select_ne_7 & (~ IN2[5])  );
    wire logic pp_7_6;
    assign pp_7_6 = (select_e_7 & IN2[6] | select_2x_7 & IN2[5] | select_n2x_7 & (~ IN2[5]) | select_ne_7 & (~ IN2[6])  );
    wire logic pp_7_7;
    assign pp_7_7 = (select_e_7 & IN2[7] | select_2x_7 & IN2[6] | select_n2x_7 & (~ IN2[6]) | select_ne_7 & (~ IN2[7])  );
    wire logic pp_7_8;
    assign pp_7_8 = (select_e_7 & IN2[8] | select_2x_7 & IN2[7] | select_n2x_7 & (~ IN2[7]) | select_ne_7 & (~ IN2[8])  );
    wire logic pp_7_9;
    assign pp_7_9 = (select_e_7 & IN2[9] | select_2x_7 & IN2[8] | select_n2x_7 & (~ IN2[8]) | select_ne_7 & (~ IN2[9])  );
    wire logic pp_7_10;
    assign pp_7_10 = (select_e_7 & IN2[10] | select_2x_7 & IN2[9] | select_n2x_7 & (~ IN2[9]) | select_ne_7 & (~ IN2[10])  );
    wire logic pp_7_11;
    assign pp_7_11 = (select_e_7 & IN2[11] | select_2x_7 & IN2[10] | select_n2x_7 & (~ IN2[10]) | select_ne_7 & (~ IN2[11])  );
    wire logic pp_7_12;
    assign pp_7_12 = (select_e_7 & IN2[12] | select_2x_7 & IN2[11] | select_n2x_7 & (~ IN2[11]) | select_ne_7 & (~ IN2[12])  );
    wire logic pp_7_13;
    assign pp_7_13 = (select_e_7 & IN2[13] | select_2x_7 & IN2[12] | select_n2x_7 & (~ IN2[12]) | select_ne_7 & (~ IN2[13])  );
    wire logic pp_7_14;
    assign pp_7_14 = (select_e_7 & IN2[14] | select_2x_7 & IN2[13] | select_n2x_7 & (~ IN2[13]) | select_ne_7 & (~ IN2[14])  );
    wire logic pp_7_15;
    assign pp_7_15 = (select_e_7 & IN2[15] | select_2x_7 & IN2[14] | select_n2x_7 & (~ IN2[14]) | select_ne_7 & (~ IN2[15])  );
    wire logic pp_7_16;
    assign pp_7_16 = (select_e_7 & IN2[16] | select_2x_7 & IN2[15] | select_n2x_7 & (~ IN2[15]) | select_ne_7 & (~ IN2[16])  );
    wire logic pp_7_17;
    assign pp_7_17 = (select_e_7 & IN2[16] | select_2x_7 & IN2[16] | select_n2x_7 & (~ IN2[16]) | select_ne_7 & (~ IN2[16])  );
    wire logic pp_7_18;
    assign pp_7_18 = ~ (select_e_7 & IN2[16] | select_2x_7 & IN2[16] | select_n2x_7 & (~ IN2[16]) | select_ne_7 & (~ IN2[16])  );
    assign tcomp7 = select_ne_7 | select_n2x_7;
    
    // Signed Booth Radix-4 Partial Products Row 9
    wire logic select_e_8, select_ne_8, select_2x_8, tcomp8, select_n2x_8;
    assign select_e_8 = ((~ IN1[16]) & (IN1[16] ^ IN1[15]));
    assign select_ne_8 = IN1[16] &  (IN1[16] ^ IN1[15]);
    assign select_2x_8 = (~ IN1[16]) & IN1[16] & IN1[15];
    assign select_n2x_8 = IN1[16] & (~ IN1[16]) & (~ IN1[15]);
    wire logic pp_8_0;
    assign pp_8_0 = (select_e_8 & IN2[0] | select_2x_8 & 1'b0 | select_n2x_8 & 1'b1 | select_ne_8 & (~ IN2[0])  );
    wire logic pp_8_1;
    assign pp_8_1 = (select_e_8 & IN2[1] | select_2x_8 & IN2[0] | select_n2x_8 & (~ IN2[0]) | select_ne_8 & (~ IN2[1])  );
    wire logic pp_8_2;
    assign pp_8_2 = (select_e_8 & IN2[2] | select_2x_8 & IN2[1] | select_n2x_8 & (~ IN2[1]) | select_ne_8 & (~ IN2[2])  );
    wire logic pp_8_3;
    assign pp_8_3 = (select_e_8 & IN2[3] | select_2x_8 & IN2[2] | select_n2x_8 & (~ IN2[2]) | select_ne_8 & (~ IN2[3])  );
    wire logic pp_8_4;
    assign pp_8_4 = (select_e_8 & IN2[4] | select_2x_8 & IN2[3] | select_n2x_8 & (~ IN2[3]) | select_ne_8 & (~ IN2[4])  );
    wire logic pp_8_5;
    assign pp_8_5 = (select_e_8 & IN2[5] | select_2x_8 & IN2[4] | select_n2x_8 & (~ IN2[4]) | select_ne_8 & (~ IN2[5])  );
    wire logic pp_8_6;
    assign pp_8_6 = (select_e_8 & IN2[6] | select_2x_8 & IN2[5] | select_n2x_8 & (~ IN2[5]) | select_ne_8 & (~ IN2[6])  );
    wire logic pp_8_7;
    assign pp_8_7 = (select_e_8 & IN2[7] | select_2x_8 & IN2[6] | select_n2x_8 & (~ IN2[6]) | select_ne_8 & (~ IN2[7])  );
    wire logic pp_8_8;
    assign pp_8_8 = (select_e_8 & IN2[8] | select_2x_8 & IN2[7] | select_n2x_8 & (~ IN2[7]) | select_ne_8 & (~ IN2[8])  );
    wire logic pp_8_9;
    assign pp_8_9 = (select_e_8 & IN2[9] | select_2x_8 & IN2[8] | select_n2x_8 & (~ IN2[8]) | select_ne_8 & (~ IN2[9])  );
    wire logic pp_8_10;
    assign pp_8_10 = (select_e_8 & IN2[10] | select_2x_8 & IN2[9] | select_n2x_8 & (~ IN2[9]) | select_ne_8 & (~ IN2[10])  );
    wire logic pp_8_11;
    assign pp_8_11 = (select_e_8 & IN2[11] | select_2x_8 & IN2[10] | select_n2x_8 & (~ IN2[10]) | select_ne_8 & (~ IN2[11])  );
    wire logic pp_8_12;
    assign pp_8_12 = (select_e_8 & IN2[12] | select_2x_8 & IN2[11] | select_n2x_8 & (~ IN2[11]) | select_ne_8 & (~ IN2[12])  );
    wire logic pp_8_13;
    assign pp_8_13 = (select_e_8 & IN2[13] | select_2x_8 & IN2[12] | select_n2x_8 & (~ IN2[12]) | select_ne_8 & (~ IN2[13])  );
    wire logic pp_8_14;
    assign pp_8_14 = (select_e_8 & IN2[14] | select_2x_8 & IN2[13] | select_n2x_8 & (~ IN2[13]) | select_ne_8 & (~ IN2[14])  );
    wire logic pp_8_15;
    assign pp_8_15 = (select_e_8 & IN2[15] | select_2x_8 & IN2[14] | select_n2x_8 & (~ IN2[14]) | select_ne_8 & (~ IN2[15])  );
    wire logic pp_8_16;
    assign pp_8_16 = (select_e_8 & IN2[16] | select_2x_8 & IN2[15] | select_n2x_8 & (~ IN2[15]) | select_ne_8 & (~ IN2[16])  );
    wire logic pp_8_17;
    assign pp_8_17 = (select_e_8 & IN2[16] | select_2x_8 & IN2[16] | select_n2x_8 & (~ IN2[16]) | select_ne_8 & (~ IN2[16])  );
    wire logic pp_8_18;
    assign pp_8_18 = ~ (select_e_8 & IN2[16] | select_2x_8 & IN2[16] | select_n2x_8 & (~ IN2[16]) | select_ne_8 & (~ IN2[16])  );
    assign tcomp8 = select_ne_8 | select_n2x_8;
    
// Creating Summation Tree 

    logic s0 ,c0;
    ha ha0 (pp_0_0, tcomp0, s0, c0);
    logic s1 ,c1; 
    fa fa1 (pp_0_2, pp_1_0, tcomp1, s1, c1);
    logic s2 ,c2;
    ha ha2 (pp_0_3, pp_1_1, s2, c2);
    logic s3 ,c3; 
    fa fa3 (pp_0_4, pp_1_2, pp_2_0, s3, c3);
    logic s4 ,c4; 
    fa fa4 (pp_0_5, pp_1_3, pp_2_1, s4, c4);
    logic s5 ,c5; 
    fa fa5 (pp_0_6, pp_1_4, pp_2_2, s5, c5);
    logic s6 ,c6;
    ha ha6 (pp_3_0, tcomp3, s6, c6);
    logic s7 ,c7; 
    fa fa7 (pp_0_7, pp_1_5, pp_2_3, s7, c7);
    logic s8 ,c8; 
    fa fa8 (pp_0_8, pp_1_6, pp_2_4, s8, c8);
    logic s9 ,c9; 
    fa fa9 (pp_3_2, pp_4_0, tcomp4, s9, c9);
    logic s10 ,c10; 
    fa fa10 (pp_0_9, pp_1_7, pp_2_5, s10, c10);
    logic s11 ,c11;
    ha ha11 (pp_3_3, pp_4_1, s11, c11);
    logic s12 ,c12; 
    fa fa12 (pp_0_10, pp_1_8, pp_2_6, s12, c12);
    logic s13 ,c13; 
    fa fa13 (pp_3_4, pp_4_2, pp_5_0, s13, c13);
    logic s14 ,c14; 
    fa fa14 (pp_0_11, pp_1_9, pp_2_7, s14, c14);
    logic s15 ,c15; 
    fa fa15 (pp_3_5, pp_4_3, pp_5_1, s15, c15);
    logic s16 ,c16; 
    fa fa16 (pp_0_12, pp_1_10, pp_2_8, s16, c16);
    logic s17 ,c17; 
    fa fa17 (pp_3_6, pp_4_4, pp_5_2, s17, c17);
    logic s18 ,c18;
    ha ha18 (pp_6_0, tcomp6, s18, c18);
    logic s19 ,c19; 
    fa fa19 (pp_0_13, pp_1_11, pp_2_9, s19, c19);
    logic s20 ,c20; 
    fa fa20 (pp_3_7, pp_4_5, pp_5_3, s20, c20);
    logic s21 ,c21; 
    fa fa21 (pp_0_14, pp_1_12, pp_2_10, s21, c21);
    logic s22 ,c22; 
    fa fa22 (pp_3_8, pp_4_6, pp_5_4, s22, c22);
    logic s23 ,c23; 
    fa fa23 (pp_6_2, pp_7_0, tcomp7, s23, c23);
    logic s24 ,c24; 
    fa fa24 (pp_0_15, pp_1_13, pp_2_11, s24, c24);
    logic s25 ,c25; 
    fa fa25 (pp_3_9, pp_4_7, pp_5_5, s25, c25);
    logic s26 ,c26;
    ha ha26 (pp_6_3, pp_7_1, s26, c26);
    logic s27 ,c27; 
    fa fa27 (pp_0_16, pp_1_14, pp_2_12, s27, c27);
    logic s28 ,c28; 
    fa fa28 (pp_3_10, pp_4_8, pp_5_6, s28, c28);
    logic s29 ,c29; 
    fa fa29 (pp_6_4, pp_7_2, pp_8_0, s29, c29);
    logic s30 ,c30; 
    fa fa30 (pp_0_17, pp_1_15, pp_2_13, s30, c30);
    logic s31 ,c31; 
    fa fa31 (pp_3_11, pp_4_9, pp_5_7, s31, c31);
    logic s32 ,c32; 
    fa fa32 (pp_6_5, pp_7_3, pp_8_1, s32, c32);
    logic s33 ,c33; 
    fa fa33 (pp_0_18, pp_1_16, pp_2_14, s33, c33);
    logic s34 ,c34; 
    fa fa34 (pp_3_12, pp_4_10, pp_5_8, s34, c34);
    logic s35 ,c35; 
    fa fa35 (pp_6_6, pp_7_4, pp_8_2, s35, c35);
    logic s36 ,c36; 
    fa fa36 (const1, pp_1_17, pp_2_15, s36, c36);
    logic s37 ,c37; 
    fa fa37 (pp_3_13, pp_4_11, pp_5_9, s37, c37);
    logic s38 ,c38; 
    fa fa38 (pp_6_7, pp_7_5, pp_8_3, s38, c38);
    logic s39 ,c39; 
    fa fa39 (pp_1_18, pp_2_16, pp_3_14, s39, c39);
    logic s40 ,c40; 
    fa fa40 (pp_4_12, pp_5_10, pp_6_8, s40, c40);
    logic s41 ,c41;
    ha ha41 (pp_7_6, pp_8_4, s41, c41);
    logic s42 ,c42; 
    fa fa42 (const1, pp_2_17, pp_3_15, s42, c42);
    logic s43 ,c43; 
    fa fa43 (pp_4_13, pp_5_11, pp_6_9, s43, c43);
    logic s44 ,c44;
    ha ha44 (pp_7_7, pp_8_5, s44, c44);
    logic s45 ,c45; 
    fa fa45 (pp_2_18, pp_3_16, pp_4_14, s45, c45);
    logic s46 ,c46; 
    fa fa46 (pp_5_12, pp_6_10, pp_7_8, s46, c46);
    logic s47 ,c47; 
    fa fa47 (const1, pp_3_17, pp_4_15, s47, c47);
    logic s48 ,c48; 
    fa fa48 (pp_5_13, pp_6_11, pp_7_9, s48, c48);
    logic s49 ,c49; 
    fa fa49 (pp_3_18, pp_4_16, pp_5_14, s49, c49);
    logic s50 ,c50; 
    fa fa50 (pp_6_12, pp_7_10, pp_8_8, s50, c50);
    logic s51 ,c51; 
    fa fa51 (const1, pp_4_17, pp_5_15, s51, c51);
    logic s52 ,c52; 
    fa fa52 (pp_6_13, pp_7_11, pp_8_9, s52, c52);
    logic s53 ,c53; 
    fa fa53 (pp_4_18, pp_5_16, pp_6_14, s53, c53);
    logic s54 ,c54;
    ha ha54 (pp_7_12, pp_8_10, s54, c54);
    logic s55 ,c55; 
    fa fa55 (const1, pp_5_17, pp_6_15, s55, c55);
    logic s56 ,c56;
    ha ha56 (pp_7_13, pp_8_11, s56, c56);
    logic s57 ,c57; 
    fa fa57 (pp_5_18, pp_6_16, pp_7_14, s57, c57);
    logic s58 ,c58; 
    fa fa58 (const1, pp_6_17, pp_7_15, s58, c58);
    logic s59 ,c59; 
    fa fa59 (pp_6_18, pp_7_16, pp_8_14, s59, c59);
    logic s60 ,c60; 
    fa fa60 (const1, pp_7_17, pp_8_15, s60, c60);
    logic s61 ,c61;
    ha ha61 (pp_7_18, pp_8_16, s61, c61);
    logic s62 ,c62;
    ha ha62 (const1, pp_8_17, s62, c62);
    logic s63 ,c63;
    ha ha63 (pp_0_1, c0, s63, c63);
    logic s64 ,c64;
    ha ha64 (c1, s2, s64, c64);
    logic s65 ,c65; 
    fa fa65 (tcomp2, c2, s3, s65, c65);
    logic s66 ,c66;
    ha ha66 (c3, s4, s66, c66);
    logic s67 ,c67; 
    fa fa67 (c4, s5, s6, s67, c67);
    logic s68 ,c68; 
    fa fa68 (pp_3_1, c5, c6, s68, c68);
    logic s69 ,c69; 
    fa fa69 (c7, s8, s9, s69, c69);
    logic s70 ,c70; 
    fa fa70 (c8, c9, s10, s70, c70);
    logic s71 ,c71; 
    fa fa71 (tcomp5, c10, c11, s71, c71);
    logic s72 ,c72;
    ha ha72 (s12, s13, s72, c72);
    logic s73 ,c73; 
    fa fa73 (c12, c13, s14, s73, c73);
    logic s74 ,c74; 
    fa fa74 (c14, c15, s16, s74, c74);
    logic s75 ,c75;
    ha ha75 (s17, s18, s75, c75);
    logic s76 ,c76; 
    fa fa76 (pp_6_1, c16, c17, s76, c76);
    logic s77 ,c77; 
    fa fa77 (c18, s19, s20, s77, c77);
    logic s78 ,c78; 
    fa fa78 (c19, c20, s21, s78, c78);
    logic s79 ,c79;
    ha ha79 (s22, s23, s79, c79);
    logic s80 ,c80; 
    fa fa80 (c21, c22, c23, s80, c80);
    logic s81 ,c81; 
    fa fa81 (s24, s25, s26, s81, c81);
    logic s82 ,c82; 
    fa fa82 (tcomp8, c24, c25, s82, c82);
    logic s83 ,c83; 
    fa fa83 (c26, s27, s28, s83, c83);
    logic s84 ,c84; 
    fa fa84 (c27, c28, c29, s84, c84);
    logic s85 ,c85; 
    fa fa85 (s30, s31, s32, s85, c85);
    logic s86 ,c86; 
    fa fa86 (const1, c30, c31, s86, c86);
    logic s87 ,c87; 
    fa fa87 (c32, s33, s34, s87, c87);
    logic s88 ,c88; 
    fa fa88 (c33, c34, c35, s88, c88);
    logic s89 ,c89; 
    fa fa89 (s36, s37, s38, s89, c89);
    logic s90 ,c90; 
    fa fa90 (c36, c37, c38, s90, c90);
    logic s91 ,c91; 
    fa fa91 (s39, s40, s41, s91, c91);
    logic s92 ,c92; 
    fa fa92 (c39, c40, c41, s92, c92);
    logic s93 ,c93; 
    fa fa93 (s42, s43, s44, s93, c93);
    logic s94 ,c94; 
    fa fa94 (pp_8_6, c42, c43, s94, c94);
    logic s95 ,c95; 
    fa fa95 (c44, s45, s46, s95, c95);
    logic s96 ,c96; 
    fa fa96 (pp_8_7, c45, c46, s96, c96);
    logic s97 ,c97;
    ha ha97 (s47, s48, s97, c97);
    logic s98 ,c98; 
    fa fa98 (c47, c48, s49, s98, c98);
    logic s99 ,c99; 
    fa fa99 (c49, c50, s51, s99, c99);
    logic s100 ,c100; 
    fa fa100 (c51, c52, s53, s100, c100);
    logic s101 ,c101; 
    fa fa101 (c53, c54, s55, s101, c101);
    logic s102 ,c102; 
    fa fa102 (pp_8_12, c55, c56, s102, c102);
    logic s103 ,c103; 
    fa fa103 (pp_8_13, c57, s58, s103, c103);
    logic s104 ,c104;
    ha ha104 (c58, s59, s104, c104);
    logic s105 ,c105;
    ha ha105 (c59, s60, s105, c105);
    logic s106 ,c106;
    ha ha106 (c60, s61, s106, c106);
    logic s107 ,c107;
    ha ha107 (c61, s62, s107, c107);
    logic s108 ,c108;
    ha ha108 (s1, c63, s108, c108);
    logic s109 ,c109;
    ha ha109 (c64, s65, s109, c109);
    logic s110 ,c110;
    ha ha110 (c65, s66, s110, c110);
    logic s111 ,c111;
    ha ha111 (c66, s67, s111, c111);
    logic s112 ,c112; 
    fa fa112 (s7, c67, s68, s112, c112);
    logic s113 ,c113;
    ha ha113 (c68, s69, s113, c113);
    logic s114 ,c114; 
    fa fa114 (s11, c69, s70, s114, c114);
    logic s115 ,c115; 
    fa fa115 (c70, s71, s72, s115, c115);
    logic s116 ,c116; 
    fa fa116 (s15, c71, c72, s116, c116);
    logic s117 ,c117; 
    fa fa117 (c73, s74, s75, s117, c117);
    logic s118 ,c118; 
    fa fa118 (c74, c75, s76, s118, c118);
    logic s119 ,c119; 
    fa fa119 (c76, c77, s78, s119, c119);
    logic s120 ,c120; 
    fa fa120 (c78, c79, s80, s120, c120);
    logic s121 ,c121; 
    fa fa121 (s29, c80, c81, s121, c121);
    logic s122 ,c122;
    ha ha122 (s82, s83, s122, c122);
    logic s123 ,c123; 
    fa fa123 (c82, c83, s84, s123, c123);
    logic s124 ,c124; 
    fa fa124 (s35, c84, c85, s124, c124);
    logic s125 ,c125;
    ha ha125 (s86, s87, s125, c125);
    logic s126 ,c126; 
    fa fa126 (c86, c87, s88, s126, c126);
    logic s127 ,c127; 
    fa fa127 (c88, c89, s90, s127, c127);
    logic s128 ,c128; 
    fa fa128 (c90, c91, s92, s128, c128);
    logic s129 ,c129; 
    fa fa129 (c92, c93, s94, s129, c129);
    logic s130 ,c130; 
    fa fa130 (c94, c95, s96, s130, c130);
    logic s131 ,c131; 
    fa fa131 (s50, c96, c97, s131, c131);
    logic s132 ,c132; 
    fa fa132 (s52, c98, s99, s132, c132);
    logic s133 ,c133; 
    fa fa133 (s54, c99, s100, s133, c133);
    logic s134 ,c134; 
    fa fa134 (s56, c100, s101, s134, c134);
    logic s135 ,c135; 
    fa fa135 (s57, c101, s102, s135, c135);
    logic s136 ,c136;
    ha ha136 (c102, s103, s136, c136);
    logic s137 ,c137;
    ha ha137 (c103, s104, s137, c137);
    logic s138 ,c138;
    ha ha138 (c104, s105, s138, c138);
    logic s139 ,c139;
    ha ha139 (c105, s106, s139, c139);
    logic s140 ,c140;
    ha ha140 (c106, s107, s140, c140);
    logic s141 ,c141;
    ha ha141 (s64, c108, s141, c141);
    logic s142 ,c142;
    ha ha142 (c109, s110, s142, c142);
    logic s143 ,c143;
    ha ha143 (c110, s111, s143, c143);
    logic s144 ,c144;
    ha ha144 (c111, s112, s144, c144);
    logic s145 ,c145;
    ha ha145 (c112, s113, s145, c145);
    logic s146 ,c146;
    ha ha146 (c113, s114, s146, c146);
    logic s147 ,c147;
    ha ha147 (c114, s115, s147, c147);
    logic s148 ,c148; 
    fa fa148 (s73, c115, s116, s148, c148);
    logic s149 ,c149;
    ha ha149 (c116, s117, s149, c149);
    logic s150 ,c150; 
    fa fa150 (s77, c117, s118, s150, c150);
    logic s151 ,c151; 
    fa fa151 (s79, c118, s119, s151, c151);
    logic s152 ,c152; 
    fa fa152 (s81, c119, s120, s152, c152);
    logic s153 ,c153; 
    fa fa153 (c120, s121, s122, s153, c153);
    logic s154 ,c154; 
    fa fa154 (s85, c121, c122, s154, c154);
    logic s155 ,c155; 
    fa fa155 (c123, s124, s125, s155, c155);
    logic s156 ,c156; 
    fa fa156 (s89, c124, c125, s156, c156);
    logic s157 ,c157; 
    fa fa157 (s91, c126, s127, s157, c157);
    logic s158 ,c158; 
    fa fa158 (s93, c127, s128, s158, c158);
    logic s159 ,c159; 
    fa fa159 (s95, c128, s129, s159, c159);
    logic s160 ,c160; 
    fa fa160 (s97, c129, s130, s160, c160);
    logic s161 ,c161; 
    fa fa161 (s98, c130, s131, s161, c161);
    logic s162 ,c162;
    ha ha162 (c131, s132, s162, c162);
    logic s163 ,c163;
    ha ha163 (c132, s133, s163, c163);
    logic s164 ,c164;
    ha ha164 (c133, s134, s164, c164);
    logic s165 ,c165;
    ha ha165 (c134, s135, s165, c165);
    logic s166 ,c166;
    ha ha166 (c135, s136, s166, c166);
    logic s167 ,c167;
    ha ha167 (c136, s137, s167, c167);
    logic s168 ,c168;
    ha ha168 (c137, s138, s168, c168);
    logic s169 ,c169;
    ha ha169 (c138, s139, s169, c169);
    logic s170 ,c170;
    ha ha170 (c139, s140, s170, c170);
    logic s171 ,c171;
    ha ha171 (s109, c141, s171, c171);
    logic s172 ,c172;
    ha ha172 (c142, s143, s172, c172);
    logic s173 ,c173;
    ha ha173 (c143, s144, s173, c173);
    logic s174 ,c174;
    ha ha174 (c144, s145, s174, c174);
    logic s175 ,c175;
    ha ha175 (c145, s146, s175, c175);
    logic s176 ,c176;
    ha ha176 (c146, s147, s176, c176);
    logic s177 ,c177;
    ha ha177 (c147, s148, s177, c177);
    logic s178 ,c178;
    ha ha178 (c148, s149, s178, c178);
    logic s179 ,c179;
    ha ha179 (c149, s150, s179, c179);
    logic s180 ,c180;
    ha ha180 (c150, s151, s180, c180);
    logic s181 ,c181;
    ha ha181 (c151, s152, s181, c181);
    logic s182 ,c182;
    ha ha182 (c152, s153, s182, c182);
    logic s183 ,c183; 
    fa fa183 (s123, c153, s154, s183, c183);
    logic s184 ,c184;
    ha ha184 (c154, s155, s184, c184);
    logic s185 ,c185; 
    fa fa185 (s126, c155, s156, s185, c185);
    logic s186 ,c186;
    ha ha186 (c156, s157, s186, c186);
    logic s187 ,c187;
    ha ha187 (c157, s158, s187, c187);
    logic s188 ,c188;
    ha ha188 (c158, s159, s188, c188);
    logic s189 ,c189;
    ha ha189 (c159, s160, s189, c189);
    logic s190 ,c190;
    ha ha190 (c160, s161, s190, c190);
    logic s191 ,c191;
    ha ha191 (c161, s162, s191, c191);
    logic s192 ,c192;
    ha ha192 (c162, s163, s192, c192);
    logic s193 ,c193;
    ha ha193 (c163, s164, s193, c193);
    logic s194 ,c194;
    ha ha194 (c164, s165, s194, c194);
    logic s195 ,c195;
    ha ha195 (c165, s166, s195, c195);
    logic s196 ,c196;
    ha ha196 (c166, s167, s196, c196);
    logic s197 ,c197;
    ha ha197 (c167, s168, s197, c197);
    logic s198 ,c198;
    ha ha198 (c168, s169, s198, c198);
    logic s199 ,c199;
    ha ha199 (c169, s170, s199, c199);
    assign result[0] = s0;
    assign result[1] = s63;
    assign result[2] = s108;
    assign result[3] = s141;
    assign result[4] = s171;
    logic [29:0] adder_result;
    LF_29 final_adder ({c198, c197, c196, c195, c194, c193, c192, c191, c190, c189, c188, c187, c186, c185, c184, c183, c182, c181, c180, c179, c178, c177, c176, c175, c174, c173, c172, s172, s142 }, {s199, s198, s197, s196, s195, s194, s193, s192, s191, s190, s189, s188, s187, s186, s185, s184, s183, s182, s181, s180, s179, s178, s177, s176, s175, s174, s173, 1'b0, c171 }, adder_result );
    assign result[33:5] = adder_result[28:0];
    endmodule



module LF_29 ( 
        input logic [28:0] IN1,
        input logic [28:0] IN2,
        output logic [29:0] OUT);
    
    wire logic [28:0] p_0;
    wire logic [28:0] g_0;
    assign g_0 = IN1 & IN2;
    assign p_0 = IN1 ^ IN2;
    
    // LF stage 1
    wire logic p_1_1;
    wire logic g_1_1;
    assign p_1_1 = p_0[1] & p_0[0];
    assign g_1_1 = (p_0[1] & g_0[0]) | g_0[1];
    wire logic p_1_3;
    wire logic g_1_3;
    assign p_1_3 = p_0[3] & p_0[2];
    assign g_1_3 = (p_0[3] & g_0[2]) | g_0[3];
    wire logic p_1_5;
    wire logic g_1_5;
    assign p_1_5 = p_0[5] & p_0[4];
    assign g_1_5 = (p_0[5] & g_0[4]) | g_0[5];
    wire logic p_1_7;
    wire logic g_1_7;
    assign p_1_7 = p_0[7] & p_0[6];
    assign g_1_7 = (p_0[7] & g_0[6]) | g_0[7];
    wire logic p_1_9;
    wire logic g_1_9;
    assign p_1_9 = p_0[9] & p_0[8];
    assign g_1_9 = (p_0[9] & g_0[8]) | g_0[9];
    wire logic p_1_11;
    wire logic g_1_11;
    assign p_1_11 = p_0[11] & p_0[10];
    assign g_1_11 = (p_0[11] & g_0[10]) | g_0[11];
    wire logic p_1_13;
    wire logic g_1_13;
    assign p_1_13 = p_0[13] & p_0[12];
    assign g_1_13 = (p_0[13] & g_0[12]) | g_0[13];
    wire logic p_1_15;
    wire logic g_1_15;
    assign p_1_15 = p_0[15] & p_0[14];
    assign g_1_15 = (p_0[15] & g_0[14]) | g_0[15];
    wire logic p_1_17;
    wire logic g_1_17;
    assign p_1_17 = p_0[17] & p_0[16];
    assign g_1_17 = (p_0[17] & g_0[16]) | g_0[17];
    wire logic p_1_19;
    wire logic g_1_19;
    assign p_1_19 = p_0[19] & p_0[18];
    assign g_1_19 = (p_0[19] & g_0[18]) | g_0[19];
    wire logic p_1_21;
    wire logic g_1_21;
    assign p_1_21 = p_0[21] & p_0[20];
    assign g_1_21 = (p_0[21] & g_0[20]) | g_0[21];
    wire logic p_1_23;
    wire logic g_1_23;
    assign p_1_23 = p_0[23] & p_0[22];
    assign g_1_23 = (p_0[23] & g_0[22]) | g_0[23];
    wire logic p_1_25;
    wire logic g_1_25;
    assign p_1_25 = p_0[25] & p_0[24];
    assign g_1_25 = (p_0[25] & g_0[24]) | g_0[25];
    wire logic p_1_27;
    wire logic g_1_27;
    assign p_1_27 = p_0[27] & p_0[26];
    assign g_1_27 = (p_0[27] & g_0[26]) | g_0[27];
    
    // LF stage 2
    wire logic p_2_2;
    wire logic g_2_2;
    assign p_2_2 = p_0[2] & p_1_1;
    assign g_2_2 = (p_0[2] & g_1_1) | g_0[2];
    wire logic p_2_3;
    wire logic g_2_3;
    assign p_2_3 = p_1_3 & p_1_1;
    assign g_2_3 = (p_1_3 & g_1_1) | g_1_3;
    wire logic p_2_6;
    wire logic g_2_6;
    assign p_2_6 = p_0[6] & p_1_5;
    assign g_2_6 = (p_0[6] & g_1_5) | g_0[6];
    wire logic p_2_7;
    wire logic g_2_7;
    assign p_2_7 = p_1_7 & p_1_5;
    assign g_2_7 = (p_1_7 & g_1_5) | g_1_7;
    wire logic p_2_10;
    wire logic g_2_10;
    assign p_2_10 = p_0[10] & p_1_9;
    assign g_2_10 = (p_0[10] & g_1_9) | g_0[10];
    wire logic p_2_11;
    wire logic g_2_11;
    assign p_2_11 = p_1_11 & p_1_9;
    assign g_2_11 = (p_1_11 & g_1_9) | g_1_11;
    wire logic p_2_14;
    wire logic g_2_14;
    assign p_2_14 = p_0[14] & p_1_13;
    assign g_2_14 = (p_0[14] & g_1_13) | g_0[14];
    wire logic p_2_15;
    wire logic g_2_15;
    assign p_2_15 = p_1_15 & p_1_13;
    assign g_2_15 = (p_1_15 & g_1_13) | g_1_15;
    wire logic p_2_18;
    wire logic g_2_18;
    assign p_2_18 = p_0[18] & p_1_17;
    assign g_2_18 = (p_0[18] & g_1_17) | g_0[18];
    wire logic p_2_19;
    wire logic g_2_19;
    assign p_2_19 = p_1_19 & p_1_17;
    assign g_2_19 = (p_1_19 & g_1_17) | g_1_19;
    wire logic p_2_22;
    wire logic g_2_22;
    assign p_2_22 = p_0[22] & p_1_21;
    assign g_2_22 = (p_0[22] & g_1_21) | g_0[22];
    wire logic p_2_23;
    wire logic g_2_23;
    assign p_2_23 = p_1_23 & p_1_21;
    assign g_2_23 = (p_1_23 & g_1_21) | g_1_23;
    wire logic p_2_26;
    wire logic g_2_26;
    assign p_2_26 = p_0[26] & p_1_25;
    assign g_2_26 = (p_0[26] & g_1_25) | g_0[26];
    wire logic p_2_27;
    wire logic g_2_27;
    assign p_2_27 = p_1_27 & p_1_25;
    assign g_2_27 = (p_1_27 & g_1_25) | g_1_27;
    
    // LF stage 3
    wire logic p_3_4;
    wire logic g_3_4;
    assign p_3_4 = p_0[4] & p_2_3;
    assign g_3_4 = (p_0[4] & g_2_3) | g_0[4];
    wire logic p_3_5;
    wire logic g_3_5;
    assign p_3_5 = p_1_5 & p_2_3;
    assign g_3_5 = (p_1_5 & g_2_3) | g_1_5;
    wire logic p_3_6;
    wire logic g_3_6;
    assign p_3_6 = p_2_6 & p_2_3;
    assign g_3_6 = (p_2_6 & g_2_3) | g_2_6;
    wire logic p_3_7;
    wire logic g_3_7;
    assign p_3_7 = p_2_7 & p_2_3;
    assign g_3_7 = (p_2_7 & g_2_3) | g_2_7;
    wire logic p_3_12;
    wire logic g_3_12;
    assign p_3_12 = p_0[12] & p_2_11;
    assign g_3_12 = (p_0[12] & g_2_11) | g_0[12];
    wire logic p_3_13;
    wire logic g_3_13;
    assign p_3_13 = p_1_13 & p_2_11;
    assign g_3_13 = (p_1_13 & g_2_11) | g_1_13;
    wire logic p_3_14;
    wire logic g_3_14;
    assign p_3_14 = p_2_14 & p_2_11;
    assign g_3_14 = (p_2_14 & g_2_11) | g_2_14;
    wire logic p_3_15;
    wire logic g_3_15;
    assign p_3_15 = p_2_15 & p_2_11;
    assign g_3_15 = (p_2_15 & g_2_11) | g_2_15;
    wire logic p_3_20;
    wire logic g_3_20;
    assign p_3_20 = p_0[20] & p_2_19;
    assign g_3_20 = (p_0[20] & g_2_19) | g_0[20];
    wire logic p_3_21;
    wire logic g_3_21;
    assign p_3_21 = p_1_21 & p_2_19;
    assign g_3_21 = (p_1_21 & g_2_19) | g_1_21;
    wire logic p_3_22;
    wire logic g_3_22;
    assign p_3_22 = p_2_22 & p_2_19;
    assign g_3_22 = (p_2_22 & g_2_19) | g_2_22;
    wire logic p_3_23;
    wire logic g_3_23;
    assign p_3_23 = p_2_23 & p_2_19;
    assign g_3_23 = (p_2_23 & g_2_19) | g_2_23;
    wire logic p_3_28;
    wire logic g_3_28;
    assign p_3_28 = p_0[28] & p_2_27;
    assign g_3_28 = (p_0[28] & g_2_27) | g_0[28];
    
    // LF stage 4
    wire logic p_4_8;
    wire logic g_4_8;
    assign p_4_8 = p_0[8] & p_3_7;
    assign g_4_8 = (p_0[8] & g_3_7) | g_0[8];
    wire logic p_4_9;
    wire logic g_4_9;
    assign p_4_9 = p_1_9 & p_3_7;
    assign g_4_9 = (p_1_9 & g_3_7) | g_1_9;
    wire logic p_4_10;
    wire logic g_4_10;
    assign p_4_10 = p_2_10 & p_3_7;
    assign g_4_10 = (p_2_10 & g_3_7) | g_2_10;
    wire logic p_4_11;
    wire logic g_4_11;
    assign p_4_11 = p_2_11 & p_3_7;
    assign g_4_11 = (p_2_11 & g_3_7) | g_2_11;
    wire logic p_4_12;
    wire logic g_4_12;
    assign p_4_12 = p_3_12 & p_3_7;
    assign g_4_12 = (p_3_12 & g_3_7) | g_3_12;
    wire logic p_4_13;
    wire logic g_4_13;
    assign p_4_13 = p_3_13 & p_3_7;
    assign g_4_13 = (p_3_13 & g_3_7) | g_3_13;
    wire logic p_4_14;
    wire logic g_4_14;
    assign p_4_14 = p_3_14 & p_3_7;
    assign g_4_14 = (p_3_14 & g_3_7) | g_3_14;
    wire logic p_4_15;
    wire logic g_4_15;
    assign p_4_15 = p_3_15 & p_3_7;
    assign g_4_15 = (p_3_15 & g_3_7) | g_3_15;
    wire logic p_4_24;
    wire logic g_4_24;
    assign p_4_24 = p_0[24] & p_3_23;
    assign g_4_24 = (p_0[24] & g_3_23) | g_0[24];
    wire logic p_4_25;
    wire logic g_4_25;
    assign p_4_25 = p_1_25 & p_3_23;
    assign g_4_25 = (p_1_25 & g_3_23) | g_1_25;
    wire logic p_4_26;
    wire logic g_4_26;
    assign p_4_26 = p_2_26 & p_3_23;
    assign g_4_26 = (p_2_26 & g_3_23) | g_2_26;
    wire logic p_4_27;
    wire logic g_4_27;
    assign p_4_27 = p_2_27 & p_3_23;
    assign g_4_27 = (p_2_27 & g_3_23) | g_2_27;
    wire logic p_4_28;
    wire logic g_4_28;
    assign p_4_28 = p_3_28 & p_3_23;
    assign g_4_28 = (p_3_28 & g_3_23) | g_3_28;
    
    // LF stage 5
    wire logic p_5_16;
    wire logic g_5_16;
    assign p_5_16 = p_0[16] & p_4_15;
    assign g_5_16 = (p_0[16] & g_4_15) | g_0[16];
    wire logic p_5_17;
    wire logic g_5_17;
    assign p_5_17 = p_1_17 & p_4_15;
    assign g_5_17 = (p_1_17 & g_4_15) | g_1_17;
    wire logic p_5_18;
    wire logic g_5_18;
    assign p_5_18 = p_2_18 & p_4_15;
    assign g_5_18 = (p_2_18 & g_4_15) | g_2_18;
    wire logic p_5_19;
    wire logic g_5_19;
    assign p_5_19 = p_2_19 & p_4_15;
    assign g_5_19 = (p_2_19 & g_4_15) | g_2_19;
    wire logic p_5_20;
    wire logic g_5_20;
    assign p_5_20 = p_3_20 & p_4_15;
    assign g_5_20 = (p_3_20 & g_4_15) | g_3_20;
    wire logic p_5_21;
    wire logic g_5_21;
    assign p_5_21 = p_3_21 & p_4_15;
    assign g_5_21 = (p_3_21 & g_4_15) | g_3_21;
    wire logic p_5_22;
    wire logic g_5_22;
    assign p_5_22 = p_3_22 & p_4_15;
    assign g_5_22 = (p_3_22 & g_4_15) | g_3_22;
    wire logic p_5_23;
    wire logic g_5_23;
    assign p_5_23 = p_3_23 & p_4_15;
    assign g_5_23 = (p_3_23 & g_4_15) | g_3_23;
    wire logic p_5_24;
    wire logic g_5_24;
    assign p_5_24 = p_4_24 & p_4_15;
    assign g_5_24 = (p_4_24 & g_4_15) | g_4_24;
    wire logic p_5_25;
    wire logic g_5_25;
    assign p_5_25 = p_4_25 & p_4_15;
    assign g_5_25 = (p_4_25 & g_4_15) | g_4_25;
    wire logic p_5_26;
    wire logic g_5_26;
    assign p_5_26 = p_4_26 & p_4_15;
    assign g_5_26 = (p_4_26 & g_4_15) | g_4_26;
    wire logic p_5_27;
    wire logic g_5_27;
    assign p_5_27 = p_4_27 & p_4_15;
    assign g_5_27 = (p_4_27 & g_4_15) | g_4_27;
    wire logic p_5_28;
    wire logic g_5_28;
    assign p_5_28 = p_4_28 & p_4_15;
    assign g_5_28 = (p_4_28 & g_4_15) | g_4_28;
    
    // LF postprocess 
    assign OUT[0] = p_0[0];
    assign OUT[1] = p_0[1] ^ g_0[0];
    assign OUT[2] = p_0[2] ^ g_1_1;
    assign OUT[3] = p_0[3] ^ g_2_2;
    assign OUT[4] = p_0[4] ^ g_2_3;
    assign OUT[5] = p_0[5] ^ g_3_4;
    assign OUT[6] = p_0[6] ^ g_3_5;
    assign OUT[7] = p_0[7] ^ g_3_6;
    assign OUT[8] = p_0[8] ^ g_3_7;
    assign OUT[9] = p_0[9] ^ g_4_8;
    assign OUT[10] = p_0[10] ^ g_4_9;
    assign OUT[11] = p_0[11] ^ g_4_10;
    assign OUT[12] = p_0[12] ^ g_4_11;
    assign OUT[13] = p_0[13] ^ g_4_12;
    assign OUT[14] = p_0[14] ^ g_4_13;
    assign OUT[15] = p_0[15] ^ g_4_14;
    assign OUT[16] = p_0[16] ^ g_4_15;
    assign OUT[17] = p_0[17] ^ g_5_16;
    assign OUT[18] = p_0[18] ^ g_5_17;
    assign OUT[19] = p_0[19] ^ g_5_18;
    assign OUT[20] = p_0[20] ^ g_5_19;
    assign OUT[21] = p_0[21] ^ g_5_20;
    assign OUT[22] = p_0[22] ^ g_5_21;
    assign OUT[23] = p_0[23] ^ g_5_22;
    assign OUT[24] = p_0[24] ^ g_5_23;
    assign OUT[25] = p_0[25] ^ g_5_24;
    assign OUT[26] = p_0[26] ^ g_5_25;
    assign OUT[27] = p_0[27] ^ g_5_26;
    assign OUT[28] = p_0[28] ^ g_5_27;
    assign OUT[29] = g_5_28;
endmodule

